package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.CanvasappCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FieldpermissionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FieldsecurityprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrivilegeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.FileattachmentRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.PublisherRequest;
import microsoft.dynamics.crm.entity.request.SolutionRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.WebresourceRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "solutionid", 
    "pinpointsolutionid", 
    "_publisherid_value", 
    "_organizationid_value", 
    "pinpointassetid", 
    "isvisible", 
    "modifiedon", 
    "installedon", 
    "uniquename", 
    "solutionpackageversion", 
    "_configurationpageid_value", 
    "_parentsolutionid_value", 
    "updatedon", 
    "ismanaged", 
    "_modifiedonbehalfby_value", 
    "_modifiedby_value", 
    "versionnumber", 
    "_createdonbehalfby_value", 
    "_createdby_value", 
    "pinpointpublisherid", 
    "createdon", 
    "pinpointsolutiondefaultlocale", 
    "description", 
    "isapimanaged", 
    "version", 
    "friendlyname", 
    "solutiontype"})
@JsonInclude(Include.NON_NULL)
public class Solution extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.solution";
    }

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("pinpointsolutionid")
    protected Long pinpointsolutionid;

    @JsonProperty("_publisherid_value")
    protected String _publisherid_value;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("pinpointassetid")
    protected String pinpointassetid;

    @JsonProperty("isvisible")
    protected Boolean isvisible;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("installedon")
    protected OffsetDateTime installedon;

    @JsonProperty("uniquename")
    protected String uniquename;

    @JsonProperty("solutionpackageversion")
    protected String solutionpackageversion;

    @JsonProperty("_configurationpageid_value")
    protected String _configurationpageid_value;

    @JsonProperty("_parentsolutionid_value")
    protected String _parentsolutionid_value;

    @JsonProperty("updatedon")
    protected OffsetDateTime updatedon;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("pinpointpublisherid")
    protected Long pinpointpublisherid;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("pinpointsolutiondefaultlocale")
    protected String pinpointsolutiondefaultlocale;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("isapimanaged")
    protected Boolean isapimanaged;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("friendlyname")
    protected String friendlyname;

    @JsonProperty("solutiontype")
    protected Integer solutiontype;

    protected Solution() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSolution() {
        return new Builder();
    }

    public static final class Builder {
        private String solutionid;
        private Long pinpointsolutionid;
        private String _publisherid_value;
        private String _organizationid_value;
        private String pinpointassetid;
        private Boolean isvisible;
        private OffsetDateTime modifiedon;
        private OffsetDateTime installedon;
        private String uniquename;
        private String solutionpackageversion;
        private String _configurationpageid_value;
        private String _parentsolutionid_value;
        private OffsetDateTime updatedon;
        private Boolean ismanaged;
        private String _modifiedonbehalfby_value;
        private String _modifiedby_value;
        private Long versionnumber;
        private String _createdonbehalfby_value;
        private String _createdby_value;
        private Long pinpointpublisherid;
        private OffsetDateTime createdon;
        private String pinpointsolutiondefaultlocale;
        private String description;
        private Boolean isapimanaged;
        private String version;
        private String friendlyname;
        private Integer solutiontype;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder pinpointsolutionid(Long pinpointsolutionid) {
            this.pinpointsolutionid = pinpointsolutionid;
            this.changedFields = changedFields.add("pinpointsolutionid");
            return this;
        }

        public Builder _publisherid_value(String _publisherid_value) {
            this._publisherid_value = _publisherid_value;
            this.changedFields = changedFields.add("_publisherid_value");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder pinpointassetid(String pinpointassetid) {
            this.pinpointassetid = pinpointassetid;
            this.changedFields = changedFields.add("pinpointassetid");
            return this;
        }

        public Builder isvisible(Boolean isvisible) {
            this.isvisible = isvisible;
            this.changedFields = changedFields.add("isvisible");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder installedon(OffsetDateTime installedon) {
            this.installedon = installedon;
            this.changedFields = changedFields.add("installedon");
            return this;
        }

        public Builder uniquename(String uniquename) {
            this.uniquename = uniquename;
            this.changedFields = changedFields.add("uniquename");
            return this;
        }

        public Builder solutionpackageversion(String solutionpackageversion) {
            this.solutionpackageversion = solutionpackageversion;
            this.changedFields = changedFields.add("solutionpackageversion");
            return this;
        }

        public Builder _configurationpageid_value(String _configurationpageid_value) {
            this._configurationpageid_value = _configurationpageid_value;
            this.changedFields = changedFields.add("_configurationpageid_value");
            return this;
        }

        public Builder _parentsolutionid_value(String _parentsolutionid_value) {
            this._parentsolutionid_value = _parentsolutionid_value;
            this.changedFields = changedFields.add("_parentsolutionid_value");
            return this;
        }

        public Builder updatedon(OffsetDateTime updatedon) {
            this.updatedon = updatedon;
            this.changedFields = changedFields.add("updatedon");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder pinpointpublisherid(Long pinpointpublisherid) {
            this.pinpointpublisherid = pinpointpublisherid;
            this.changedFields = changedFields.add("pinpointpublisherid");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder pinpointsolutiondefaultlocale(String pinpointsolutiondefaultlocale) {
            this.pinpointsolutiondefaultlocale = pinpointsolutiondefaultlocale;
            this.changedFields = changedFields.add("pinpointsolutiondefaultlocale");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder isapimanaged(Boolean isapimanaged) {
            this.isapimanaged = isapimanaged;
            this.changedFields = changedFields.add("isapimanaged");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder friendlyname(String friendlyname) {
            this.friendlyname = friendlyname;
            this.changedFields = changedFields.add("friendlyname");
            return this;
        }

        public Builder solutiontype(Integer solutiontype) {
            this.solutiontype = solutiontype;
            this.changedFields = changedFields.add("solutiontype");
            return this;
        }

        public Solution build() {
            Solution _x = new Solution();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.solution";
            _x.solutionid = solutionid;
            _x.pinpointsolutionid = pinpointsolutionid;
            _x._publisherid_value = _publisherid_value;
            _x._organizationid_value = _organizationid_value;
            _x.pinpointassetid = pinpointassetid;
            _x.isvisible = isvisible;
            _x.modifiedon = modifiedon;
            _x.installedon = installedon;
            _x.uniquename = uniquename;
            _x.solutionpackageversion = solutionpackageversion;
            _x._configurationpageid_value = _configurationpageid_value;
            _x._parentsolutionid_value = _parentsolutionid_value;
            _x.updatedon = updatedon;
            _x.ismanaged = ismanaged;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.versionnumber = versionnumber;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._createdby_value = _createdby_value;
            _x.pinpointpublisherid = pinpointpublisherid;
            _x.createdon = createdon;
            _x.pinpointsolutiondefaultlocale = pinpointsolutiondefaultlocale;
            _x.description = description;
            _x.isapimanaged = isapimanaged;
            _x.version = version;
            _x.friendlyname = friendlyname;
            _x.solutiontype = solutiontype;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && solutionid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(solutionid.toString()));
        }
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Solution withSolutionid(String solutionid) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="pinpointsolutionid")
    @JsonIgnore
    public Optional<Long> getPinpointsolutionid() {
        return Optional.ofNullable(pinpointsolutionid);
    }

    public Solution withPinpointsolutionid(Long pinpointsolutionid) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("pinpointsolutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.pinpointsolutionid = pinpointsolutionid;
        return _x;
    }

    @Property(name="_publisherid_value")
    @JsonIgnore
    public Optional<String> get_publisherid_value() {
        return Optional.ofNullable(_publisherid_value);
    }

    public Solution with_publisherid_value(String _publisherid_value) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("_publisherid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x._publisherid_value = _publisherid_value;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Solution with_organizationid_value(String _organizationid_value) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="pinpointassetid")
    @JsonIgnore
    public Optional<String> getPinpointassetid() {
        return Optional.ofNullable(pinpointassetid);
    }

    public Solution withPinpointassetid(String pinpointassetid) {
        Checks.checkIsAscii(pinpointassetid);
        Solution _x = _copy();
        _x.changedFields = changedFields.add("pinpointassetid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.pinpointassetid = pinpointassetid;
        return _x;
    }

    @Property(name="isvisible")
    @JsonIgnore
    public Optional<Boolean> getIsvisible() {
        return Optional.ofNullable(isvisible);
    }

    public Solution withIsvisible(Boolean isvisible) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("isvisible");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.isvisible = isvisible;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Solution withModifiedon(OffsetDateTime modifiedon) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="installedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getInstalledon() {
        return Optional.ofNullable(installedon);
    }

    public Solution withInstalledon(OffsetDateTime installedon) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("installedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.installedon = installedon;
        return _x;
    }

    @Property(name="uniquename")
    @JsonIgnore
    public Optional<String> getUniquename() {
        return Optional.ofNullable(uniquename);
    }

    public Solution withUniquename(String uniquename) {
        Checks.checkIsAscii(uniquename);
        Solution _x = _copy();
        _x.changedFields = changedFields.add("uniquename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.uniquename = uniquename;
        return _x;
    }

    @Property(name="solutionpackageversion")
    @JsonIgnore
    public Optional<String> getSolutionpackageversion() {
        return Optional.ofNullable(solutionpackageversion);
    }

    public Solution withSolutionpackageversion(String solutionpackageversion) {
        Checks.checkIsAscii(solutionpackageversion);
        Solution _x = _copy();
        _x.changedFields = changedFields.add("solutionpackageversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.solutionpackageversion = solutionpackageversion;
        return _x;
    }

    @Property(name="_configurationpageid_value")
    @JsonIgnore
    public Optional<String> get_configurationpageid_value() {
        return Optional.ofNullable(_configurationpageid_value);
    }

    public Solution with_configurationpageid_value(String _configurationpageid_value) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("_configurationpageid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x._configurationpageid_value = _configurationpageid_value;
        return _x;
    }

    @Property(name="_parentsolutionid_value")
    @JsonIgnore
    public Optional<String> get_parentsolutionid_value() {
        return Optional.ofNullable(_parentsolutionid_value);
    }

    public Solution with_parentsolutionid_value(String _parentsolutionid_value) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("_parentsolutionid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x._parentsolutionid_value = _parentsolutionid_value;
        return _x;
    }

    @Property(name="updatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getUpdatedon() {
        return Optional.ofNullable(updatedon);
    }

    public Solution withUpdatedon(OffsetDateTime updatedon) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("updatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.updatedon = updatedon;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Solution withIsmanaged(Boolean ismanaged) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Solution with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Solution with_modifiedby_value(String _modifiedby_value) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Solution withVersionnumber(Long versionnumber) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Solution with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Solution with_createdby_value(String _createdby_value) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="pinpointpublisherid")
    @JsonIgnore
    public Optional<Long> getPinpointpublisherid() {
        return Optional.ofNullable(pinpointpublisherid);
    }

    public Solution withPinpointpublisherid(Long pinpointpublisherid) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("pinpointpublisherid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.pinpointpublisherid = pinpointpublisherid;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Solution withCreatedon(OffsetDateTime createdon) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="pinpointsolutiondefaultlocale")
    @JsonIgnore
    public Optional<String> getPinpointsolutiondefaultlocale() {
        return Optional.ofNullable(pinpointsolutiondefaultlocale);
    }

    public Solution withPinpointsolutiondefaultlocale(String pinpointsolutiondefaultlocale) {
        Checks.checkIsAscii(pinpointsolutiondefaultlocale);
        Solution _x = _copy();
        _x.changedFields = changedFields.add("pinpointsolutiondefaultlocale");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.pinpointsolutiondefaultlocale = pinpointsolutiondefaultlocale;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Solution withDescription(String description) {
        Checks.checkIsAscii(description);
        Solution _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.description = description;
        return _x;
    }

    @Property(name="isapimanaged")
    @JsonIgnore
    public Optional<Boolean> getIsapimanaged() {
        return Optional.ofNullable(isapimanaged);
    }

    public Solution withIsapimanaged(Boolean isapimanaged) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("isapimanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.isapimanaged = isapimanaged;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    public Solution withVersion(String version) {
        Checks.checkIsAscii(version);
        Solution _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.version = version;
        return _x;
    }

    @Property(name="friendlyname")
    @JsonIgnore
    public Optional<String> getFriendlyname() {
        return Optional.ofNullable(friendlyname);
    }

    public Solution withFriendlyname(String friendlyname) {
        Checks.checkIsAscii(friendlyname);
        Solution _x = _copy();
        _x.changedFields = changedFields.add("friendlyname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.friendlyname = friendlyname;
        return _x;
    }

    @Property(name="solutiontype")
    @JsonIgnore
    public Optional<Integer> getSolutiontype() {
        return Optional.ofNullable(solutiontype);
    }

    public Solution withSolutiontype(Integer solutiontype) {
        Solution _x = _copy();
        _x.changedFields = changedFields.add("solutiontype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solution");
        _x.solutiontype = solutiontype;
        return _x;
    }

    public Solution withUnmappedField(String name, String value) {
        Solution _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="configurationpageid")
    @JsonIgnore
    public WebresourceRequest getConfigurationpageid() {
        return new WebresourceRequest(contextPath.addSegment("configurationpageid"), RequestHelper.getValue(unmappedFields, "configurationpageid"));
    }

    @NavigationProperty(name="solution_solutioncomponent")
    @JsonIgnore
    public SolutioncomponentCollectionRequest getSolution_solutioncomponent() {
        return new SolutioncomponentCollectionRequest(
                        contextPath.addSegment("solution_solutioncomponent"), RequestHelper.getValue(unmappedFields, "solution_solutioncomponent"));
    }

    @NavigationProperty(name="publisherid")
    @JsonIgnore
    public PublisherRequest getPublisherid() {
        return new PublisherRequest(contextPath.addSegment("publisherid"), RequestHelper.getValue(unmappedFields, "publisherid"));
    }

    @NavigationProperty(name="Solution_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getSolution_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Solution_SyncErrors"), RequestHelper.getValue(unmappedFields, "Solution_SyncErrors"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="parentsolutionid")
    @JsonIgnore
    public SolutionRequest getParentsolutionid() {
        return new SolutionRequest(contextPath.addSegment("parentsolutionid"), RequestHelper.getValue(unmappedFields, "parentsolutionid"));
    }

    @NavigationProperty(name="solution_parent_solution")
    @JsonIgnore
    public SolutionCollectionRequest getSolution_parent_solution() {
        return new SolutionCollectionRequest(
                        contextPath.addSegment("solution_parent_solution"), RequestHelper.getValue(unmappedFields, "solution_parent_solution"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="regardingobjectid_fileattachment_solution")
    @JsonIgnore
    public FileattachmentCollectionRequest getRegardingobjectid_fileattachment_solution() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("regardingobjectid_fileattachment_solution"), RequestHelper.getValue(unmappedFields, "regardingobjectid_fileattachment_solution"));
    }

    @NavigationProperty(name="FK_CanvasApp_Solution")
    @JsonIgnore
    public CanvasappCollectionRequest getFK_CanvasApp_Solution() {
        return new CanvasappCollectionRequest(
                        contextPath.addSegment("FK_CanvasApp_Solution"), RequestHelper.getValue(unmappedFields, "FK_CanvasApp_Solution"));
    }

    @NavigationProperty(name="solution_fieldpermission")
    @JsonIgnore
    public FieldpermissionCollectionRequest getSolution_fieldpermission() {
        return new FieldpermissionCollectionRequest(
                        contextPath.addSegment("solution_fieldpermission"), RequestHelper.getValue(unmappedFields, "solution_fieldpermission"));
    }

    @NavigationProperty(name="solution_fieldsecurityprofile")
    @JsonIgnore
    public FieldsecurityprofileCollectionRequest getSolution_fieldsecurityprofile() {
        return new FieldsecurityprofileCollectionRequest(
                        contextPath.addSegment("solution_fieldsecurityprofile"), RequestHelper.getValue(unmappedFields, "solution_fieldsecurityprofile"));
    }

    @NavigationProperty(name="solution_privilege")
    @JsonIgnore
    public PrivilegeCollectionRequest getSolution_privilege() {
        return new PrivilegeCollectionRequest(
                        contextPath.addSegment("solution_privilege"), RequestHelper.getValue(unmappedFields, "solution_privilege"));
    }

    @NavigationProperty(name="solution_role")
    @JsonIgnore
    public RoleCollectionRequest getSolution_role() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("solution_role"), RequestHelper.getValue(unmappedFields, "solution_role"));
    }

    @NavigationProperty(name="fileid")
    @JsonIgnore
    public FileattachmentRequest getFileid() {
        return new FileattachmentRequest(contextPath.addSegment("fileid"), RequestHelper.getValue(unmappedFields, "fileid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Solution patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Solution _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Solution put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Solution _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Solution _copy() {
        Solution _x = new Solution();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.solutionid = solutionid;
        _x.pinpointsolutionid = pinpointsolutionid;
        _x._publisherid_value = _publisherid_value;
        _x._organizationid_value = _organizationid_value;
        _x.pinpointassetid = pinpointassetid;
        _x.isvisible = isvisible;
        _x.modifiedon = modifiedon;
        _x.installedon = installedon;
        _x.uniquename = uniquename;
        _x.solutionpackageversion = solutionpackageversion;
        _x._configurationpageid_value = _configurationpageid_value;
        _x._parentsolutionid_value = _parentsolutionid_value;
        _x.updatedon = updatedon;
        _x.ismanaged = ismanaged;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.versionnumber = versionnumber;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._createdby_value = _createdby_value;
        _x.pinpointpublisherid = pinpointpublisherid;
        _x.createdon = createdon;
        _x.pinpointsolutiondefaultlocale = pinpointsolutiondefaultlocale;
        _x.description = description;
        _x.isapimanaged = isapimanaged;
        _x.version = version;
        _x.friendlyname = friendlyname;
        _x.solutiontype = solutiontype;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Solution[");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("pinpointsolutionid=");
        b.append(this.pinpointsolutionid);
        b.append(", ");
        b.append("_publisherid_value=");
        b.append(this._publisherid_value);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("pinpointassetid=");
        b.append(this.pinpointassetid);
        b.append(", ");
        b.append("isvisible=");
        b.append(this.isvisible);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("installedon=");
        b.append(this.installedon);
        b.append(", ");
        b.append("uniquename=");
        b.append(this.uniquename);
        b.append(", ");
        b.append("solutionpackageversion=");
        b.append(this.solutionpackageversion);
        b.append(", ");
        b.append("_configurationpageid_value=");
        b.append(this._configurationpageid_value);
        b.append(", ");
        b.append("_parentsolutionid_value=");
        b.append(this._parentsolutionid_value);
        b.append(", ");
        b.append("updatedon=");
        b.append(this.updatedon);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("pinpointpublisherid=");
        b.append(this.pinpointpublisherid);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("pinpointsolutiondefaultlocale=");
        b.append(this.pinpointsolutiondefaultlocale);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("isapimanaged=");
        b.append(this.isapimanaged);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("friendlyname=");
        b.append(this.friendlyname);
        b.append(", ");
        b.append("solutiontype=");
        b.append(this.solutiontype);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
