package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.ActioncardCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppointmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostfollowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostregardingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgebaserecordRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageRequest;
import microsoft.dynamics.crm.entity.request.RecurrenceruleRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "dayofmonth", 
    "patternendtype", 
    "isalldayevent", 
    "outlookownerapptid", 
    "lastexpandedinstancedate", 
    "overriddencreatedon", 
    "location", 
    "effectivestartdate", 
    "_ruleid_value", 
    "category", 
    "patternstartdate", 
    "nextexpansioninstancedate", 
    "starttime", 
    "effectiveenddate", 
    "isnthmonthly", 
    "_groupid_value", 
    "seriesstatus", 
    "isregenerate", 
    "patternenddate", 
    "monthofyear", 
    "duration", 
    "isunsafe", 
    "isnthyearly", 
    "globalobjectid", 
    "importsequencenumber", 
    "daysofweekmask", 
    "deletedexceptionslist", 
    "subcategory", 
    "recurrencepatterntype", 
    "endtime", 
    "occurrences", 
    "firstdayofweek", 
    "interval", 
    "subscriptionid", 
    "isweekdaypattern", 
    "expansionstatecode", 
    "instance"})
@JsonInclude(Include.NON_NULL)
public class Recurringappointmentmaster extends Activitypointer implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.recurringappointmentmaster";
    }

    @JsonProperty("dayofmonth")
    protected Integer dayofmonth;

    @JsonProperty("patternendtype")
    protected Integer patternendtype;

    @JsonProperty("isalldayevent")
    protected Boolean isalldayevent;

    @JsonProperty("outlookownerapptid")
    protected Integer outlookownerapptid;

    @JsonProperty("lastexpandedinstancedate")
    protected OffsetDateTime lastexpandedinstancedate;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("location")
    protected String location;

    @JsonProperty("effectivestartdate")
    protected OffsetDateTime effectivestartdate;

    @JsonProperty("_ruleid_value")
    protected String _ruleid_value;

    @JsonProperty("category")
    protected String category;

    @JsonProperty("patternstartdate")
    protected OffsetDateTime patternstartdate;

    @JsonProperty("nextexpansioninstancedate")
    protected OffsetDateTime nextexpansioninstancedate;

    @JsonProperty("starttime")
    protected OffsetDateTime starttime;

    @JsonProperty("effectiveenddate")
    protected OffsetDateTime effectiveenddate;

    @JsonProperty("isnthmonthly")
    protected Boolean isnthmonthly;

    @JsonProperty("_groupid_value")
    protected String _groupid_value;

    @JsonProperty("seriesstatus")
    protected Boolean seriesstatus;

    @JsonProperty("isregenerate")
    protected Boolean isregenerate;

    @JsonProperty("patternenddate")
    protected OffsetDateTime patternenddate;

    @JsonProperty("monthofyear")
    protected Integer monthofyear;

    @JsonProperty("duration")
    protected Integer duration;

    @JsonProperty("isunsafe")
    protected Integer isunsafe;

    @JsonProperty("isnthyearly")
    protected Boolean isnthyearly;

    @JsonProperty("globalobjectid")
    protected String globalobjectid;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("daysofweekmask")
    protected Integer daysofweekmask;

    @JsonProperty("deletedexceptionslist")
    protected String deletedexceptionslist;

    @JsonProperty("subcategory")
    protected String subcategory;

    @JsonProperty("recurrencepatterntype")
    protected Integer recurrencepatterntype;

    @JsonProperty("endtime")
    protected OffsetDateTime endtime;

    @JsonProperty("occurrences")
    protected Integer occurrences;

    @JsonProperty("firstdayofweek")
    protected Integer firstdayofweek;

    @JsonProperty("interval")
    protected Integer interval;

    @JsonProperty("subscriptionid")
    protected String subscriptionid;

    @JsonProperty("isweekdaypattern")
    protected Boolean isweekdaypattern;

    @JsonProperty("expansionstatecode")
    protected Integer expansionstatecode;

    @JsonProperty("instance")
    protected Integer instance;

    protected Recurringappointmentmaster() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRecurringappointmentmaster() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime lastonholdtime;
        private Integer actualdurationminutes;
        private String _owningteam_value;
        private String exchangeitemid;
        private Boolean ismapiprivate;
        private OffsetDateTime createdon;
        private String seriesid;
        private Boolean leftvoicemail;
        private OffsetDateTime deliverylastattemptedon;
        private Boolean isbilled;
        private Boolean isworkflowcreated;
        private String _sendermailboxid_value;
        private String description;
        private String _regardingobjectid_value;
        private Integer onholdtime;
        private String _modifiedby_value;
        private Integer community;
        private String activityid;
        private OffsetDateTime sortdate;
        private Integer instancetypecode;
        private Integer timezoneruleversionnumber;
        private String _createdonbehalfby_value;
        private String _transactioncurrencyid_value;
        private Long versionnumber;
        private String processid;
        private OffsetDateTime scheduledend;
        private Integer prioritycode;
        private String _slaid_value;
        private String stageid;
        private OffsetDateTime actualstart;
        private String _owningbusinessunit_value;
        private String _owninguser_value;
        private Integer utcconversiontimezonecode;
        private String exchangeweblink;
        private Integer scheduleddurationminutes;
        private OffsetDateTime senton;
        private OffsetDateTime scheduledstart;
        private Integer statecode;
        private String subject;
        private OffsetDateTime postponeactivityprocessinguntil;
        private String _modifiedonbehalfby_value;
        private BigDecimal exchangerate;
        private Boolean isregularactivity;
        private Integer deliveryprioritycode;
        private String activityadditionalparams;
        private String traversedpath;
        private String _createdby_value;
        private String activitytypecode;
        private String _ownerid_value;
        private OffsetDateTime modifiedon;
        private String _slainvokedid_value;
        private Integer statuscode;
        private OffsetDateTime actualend;
        private Integer dayofmonth;
        private Integer patternendtype;
        private Boolean isalldayevent;
        private Integer outlookownerapptid;
        private OffsetDateTime lastexpandedinstancedate;
        private OffsetDateTime overriddencreatedon;
        private String location;
        private OffsetDateTime effectivestartdate;
        private String _ruleid_value;
        private String category;
        private OffsetDateTime patternstartdate;
        private OffsetDateTime nextexpansioninstancedate;
        private OffsetDateTime starttime;
        private OffsetDateTime effectiveenddate;
        private Boolean isnthmonthly;
        private String _groupid_value;
        private Boolean seriesstatus;
        private Boolean isregenerate;
        private OffsetDateTime patternenddate;
        private Integer monthofyear;
        private Integer duration;
        private Integer isunsafe;
        private Boolean isnthyearly;
        private String globalobjectid;
        private Integer importsequencenumber;
        private Integer daysofweekmask;
        private String deletedexceptionslist;
        private String subcategory;
        private Integer recurrencepatterntype;
        private OffsetDateTime endtime;
        private Integer occurrences;
        private Integer firstdayofweek;
        private Integer interval;
        private String subscriptionid;
        private Boolean isweekdaypattern;
        private Integer expansionstatecode;
        private Integer instance;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder lastonholdtime(OffsetDateTime lastonholdtime) {
            this.lastonholdtime = lastonholdtime;
            this.changedFields = changedFields.add("lastonholdtime");
            return this;
        }

        public Builder actualdurationminutes(Integer actualdurationminutes) {
            this.actualdurationminutes = actualdurationminutes;
            this.changedFields = changedFields.add("actualdurationminutes");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder exchangeitemid(String exchangeitemid) {
            this.exchangeitemid = exchangeitemid;
            this.changedFields = changedFields.add("exchangeitemid");
            return this;
        }

        public Builder ismapiprivate(Boolean ismapiprivate) {
            this.ismapiprivate = ismapiprivate;
            this.changedFields = changedFields.add("ismapiprivate");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder seriesid(String seriesid) {
            this.seriesid = seriesid;
            this.changedFields = changedFields.add("seriesid");
            return this;
        }

        public Builder leftvoicemail(Boolean leftvoicemail) {
            this.leftvoicemail = leftvoicemail;
            this.changedFields = changedFields.add("leftvoicemail");
            return this;
        }

        public Builder deliverylastattemptedon(OffsetDateTime deliverylastattemptedon) {
            this.deliverylastattemptedon = deliverylastattemptedon;
            this.changedFields = changedFields.add("deliverylastattemptedon");
            return this;
        }

        public Builder isbilled(Boolean isbilled) {
            this.isbilled = isbilled;
            this.changedFields = changedFields.add("isbilled");
            return this;
        }

        public Builder isworkflowcreated(Boolean isworkflowcreated) {
            this.isworkflowcreated = isworkflowcreated;
            this.changedFields = changedFields.add("isworkflowcreated");
            return this;
        }

        public Builder _sendermailboxid_value(String _sendermailboxid_value) {
            this._sendermailboxid_value = _sendermailboxid_value;
            this.changedFields = changedFields.add("_sendermailboxid_value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder _regardingobjectid_value(String _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder onholdtime(Integer onholdtime) {
            this.onholdtime = onholdtime;
            this.changedFields = changedFields.add("onholdtime");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder community(Integer community) {
            this.community = community;
            this.changedFields = changedFields.add("community");
            return this;
        }

        public Builder activityid(String activityid) {
            this.activityid = activityid;
            this.changedFields = changedFields.add("activityid");
            return this;
        }

        public Builder sortdate(OffsetDateTime sortdate) {
            this.sortdate = sortdate;
            this.changedFields = changedFields.add("sortdate");
            return this;
        }

        public Builder instancetypecode(Integer instancetypecode) {
            this.instancetypecode = instancetypecode;
            this.changedFields = changedFields.add("instancetypecode");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _transactioncurrencyid_value(String _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder processid(String processid) {
            this.processid = processid;
            this.changedFields = changedFields.add("processid");
            return this;
        }

        public Builder scheduledend(OffsetDateTime scheduledend) {
            this.scheduledend = scheduledend;
            this.changedFields = changedFields.add("scheduledend");
            return this;
        }

        public Builder prioritycode(Integer prioritycode) {
            this.prioritycode = prioritycode;
            this.changedFields = changedFields.add("prioritycode");
            return this;
        }

        public Builder _slaid_value(String _slaid_value) {
            this._slaid_value = _slaid_value;
            this.changedFields = changedFields.add("_slaid_value");
            return this;
        }

        public Builder stageid(String stageid) {
            this.stageid = stageid;
            this.changedFields = changedFields.add("stageid");
            return this;
        }

        public Builder actualstart(OffsetDateTime actualstart) {
            this.actualstart = actualstart;
            this.changedFields = changedFields.add("actualstart");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder exchangeweblink(String exchangeweblink) {
            this.exchangeweblink = exchangeweblink;
            this.changedFields = changedFields.add("exchangeweblink");
            return this;
        }

        public Builder scheduleddurationminutes(Integer scheduleddurationminutes) {
            this.scheduleddurationminutes = scheduleddurationminutes;
            this.changedFields = changedFields.add("scheduleddurationminutes");
            return this;
        }

        public Builder senton(OffsetDateTime senton) {
            this.senton = senton;
            this.changedFields = changedFields.add("senton");
            return this;
        }

        public Builder scheduledstart(OffsetDateTime scheduledstart) {
            this.scheduledstart = scheduledstart;
            this.changedFields = changedFields.add("scheduledstart");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Builder postponeactivityprocessinguntil(OffsetDateTime postponeactivityprocessinguntil) {
            this.postponeactivityprocessinguntil = postponeactivityprocessinguntil;
            this.changedFields = changedFields.add("postponeactivityprocessinguntil");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder isregularactivity(Boolean isregularactivity) {
            this.isregularactivity = isregularactivity;
            this.changedFields = changedFields.add("isregularactivity");
            return this;
        }

        public Builder deliveryprioritycode(Integer deliveryprioritycode) {
            this.deliveryprioritycode = deliveryprioritycode;
            this.changedFields = changedFields.add("deliveryprioritycode");
            return this;
        }

        public Builder activityadditionalparams(String activityadditionalparams) {
            this.activityadditionalparams = activityadditionalparams;
            this.changedFields = changedFields.add("activityadditionalparams");
            return this;
        }

        public Builder traversedpath(String traversedpath) {
            this.traversedpath = traversedpath;
            this.changedFields = changedFields.add("traversedpath");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder activitytypecode(String activitytypecode) {
            this.activitytypecode = activitytypecode;
            this.changedFields = changedFields.add("activitytypecode");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _slainvokedid_value(String _slainvokedid_value) {
            this._slainvokedid_value = _slainvokedid_value;
            this.changedFields = changedFields.add("_slainvokedid_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder actualend(OffsetDateTime actualend) {
            this.actualend = actualend;
            this.changedFields = changedFields.add("actualend");
            return this;
        }

        public Builder dayofmonth(Integer dayofmonth) {
            this.dayofmonth = dayofmonth;
            this.changedFields = changedFields.add("dayofmonth");
            return this;
        }

        public Builder patternendtype(Integer patternendtype) {
            this.patternendtype = patternendtype;
            this.changedFields = changedFields.add("patternendtype");
            return this;
        }

        public Builder isalldayevent(Boolean isalldayevent) {
            this.isalldayevent = isalldayevent;
            this.changedFields = changedFields.add("isalldayevent");
            return this;
        }

        public Builder outlookownerapptid(Integer outlookownerapptid) {
            this.outlookownerapptid = outlookownerapptid;
            this.changedFields = changedFields.add("outlookownerapptid");
            return this;
        }

        public Builder lastexpandedinstancedate(OffsetDateTime lastexpandedinstancedate) {
            this.lastexpandedinstancedate = lastexpandedinstancedate;
            this.changedFields = changedFields.add("lastexpandedinstancedate");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder effectivestartdate(OffsetDateTime effectivestartdate) {
            this.effectivestartdate = effectivestartdate;
            this.changedFields = changedFields.add("effectivestartdate");
            return this;
        }

        public Builder _ruleid_value(String _ruleid_value) {
            this._ruleid_value = _ruleid_value;
            this.changedFields = changedFields.add("_ruleid_value");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder patternstartdate(OffsetDateTime patternstartdate) {
            this.patternstartdate = patternstartdate;
            this.changedFields = changedFields.add("patternstartdate");
            return this;
        }

        public Builder nextexpansioninstancedate(OffsetDateTime nextexpansioninstancedate) {
            this.nextexpansioninstancedate = nextexpansioninstancedate;
            this.changedFields = changedFields.add("nextexpansioninstancedate");
            return this;
        }

        public Builder starttime(OffsetDateTime starttime) {
            this.starttime = starttime;
            this.changedFields = changedFields.add("starttime");
            return this;
        }

        public Builder effectiveenddate(OffsetDateTime effectiveenddate) {
            this.effectiveenddate = effectiveenddate;
            this.changedFields = changedFields.add("effectiveenddate");
            return this;
        }

        public Builder isnthmonthly(Boolean isnthmonthly) {
            this.isnthmonthly = isnthmonthly;
            this.changedFields = changedFields.add("isnthmonthly");
            return this;
        }

        public Builder _groupid_value(String _groupid_value) {
            this._groupid_value = _groupid_value;
            this.changedFields = changedFields.add("_groupid_value");
            return this;
        }

        public Builder seriesstatus(Boolean seriesstatus) {
            this.seriesstatus = seriesstatus;
            this.changedFields = changedFields.add("seriesstatus");
            return this;
        }

        public Builder isregenerate(Boolean isregenerate) {
            this.isregenerate = isregenerate;
            this.changedFields = changedFields.add("isregenerate");
            return this;
        }

        public Builder patternenddate(OffsetDateTime patternenddate) {
            this.patternenddate = patternenddate;
            this.changedFields = changedFields.add("patternenddate");
            return this;
        }

        public Builder monthofyear(Integer monthofyear) {
            this.monthofyear = monthofyear;
            this.changedFields = changedFields.add("monthofyear");
            return this;
        }

        public Builder duration(Integer duration) {
            this.duration = duration;
            this.changedFields = changedFields.add("duration");
            return this;
        }

        public Builder isunsafe(Integer isunsafe) {
            this.isunsafe = isunsafe;
            this.changedFields = changedFields.add("isunsafe");
            return this;
        }

        public Builder isnthyearly(Boolean isnthyearly) {
            this.isnthyearly = isnthyearly;
            this.changedFields = changedFields.add("isnthyearly");
            return this;
        }

        public Builder globalobjectid(String globalobjectid) {
            this.globalobjectid = globalobjectid;
            this.changedFields = changedFields.add("globalobjectid");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder daysofweekmask(Integer daysofweekmask) {
            this.daysofweekmask = daysofweekmask;
            this.changedFields = changedFields.add("daysofweekmask");
            return this;
        }

        public Builder deletedexceptionslist(String deletedexceptionslist) {
            this.deletedexceptionslist = deletedexceptionslist;
            this.changedFields = changedFields.add("deletedexceptionslist");
            return this;
        }

        public Builder subcategory(String subcategory) {
            this.subcategory = subcategory;
            this.changedFields = changedFields.add("subcategory");
            return this;
        }

        public Builder recurrencepatterntype(Integer recurrencepatterntype) {
            this.recurrencepatterntype = recurrencepatterntype;
            this.changedFields = changedFields.add("recurrencepatterntype");
            return this;
        }

        public Builder endtime(OffsetDateTime endtime) {
            this.endtime = endtime;
            this.changedFields = changedFields.add("endtime");
            return this;
        }

        public Builder occurrences(Integer occurrences) {
            this.occurrences = occurrences;
            this.changedFields = changedFields.add("occurrences");
            return this;
        }

        public Builder firstdayofweek(Integer firstdayofweek) {
            this.firstdayofweek = firstdayofweek;
            this.changedFields = changedFields.add("firstdayofweek");
            return this;
        }

        public Builder interval(Integer interval) {
            this.interval = interval;
            this.changedFields = changedFields.add("interval");
            return this;
        }

        public Builder subscriptionid(String subscriptionid) {
            this.subscriptionid = subscriptionid;
            this.changedFields = changedFields.add("subscriptionid");
            return this;
        }

        public Builder isweekdaypattern(Boolean isweekdaypattern) {
            this.isweekdaypattern = isweekdaypattern;
            this.changedFields = changedFields.add("isweekdaypattern");
            return this;
        }

        public Builder expansionstatecode(Integer expansionstatecode) {
            this.expansionstatecode = expansionstatecode;
            this.changedFields = changedFields.add("expansionstatecode");
            return this;
        }

        public Builder instance(Integer instance) {
            this.instance = instance;
            this.changedFields = changedFields.add("instance");
            return this;
        }

        public Recurringappointmentmaster build() {
            Recurringappointmentmaster _x = new Recurringappointmentmaster();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.recurringappointmentmaster";
            _x.lastonholdtime = lastonholdtime;
            _x.actualdurationminutes = actualdurationminutes;
            _x._owningteam_value = _owningteam_value;
            _x.exchangeitemid = exchangeitemid;
            _x.ismapiprivate = ismapiprivate;
            _x.createdon = createdon;
            _x.seriesid = seriesid;
            _x.leftvoicemail = leftvoicemail;
            _x.deliverylastattemptedon = deliverylastattemptedon;
            _x.isbilled = isbilled;
            _x.isworkflowcreated = isworkflowcreated;
            _x._sendermailboxid_value = _sendermailboxid_value;
            _x.description = description;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x.onholdtime = onholdtime;
            _x._modifiedby_value = _modifiedby_value;
            _x.community = community;
            _x.activityid = activityid;
            _x.sortdate = sortdate;
            _x.instancetypecode = instancetypecode;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.versionnumber = versionnumber;
            _x.processid = processid;
            _x.scheduledend = scheduledend;
            _x.prioritycode = prioritycode;
            _x._slaid_value = _slaid_value;
            _x.stageid = stageid;
            _x.actualstart = actualstart;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._owninguser_value = _owninguser_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.exchangeweblink = exchangeweblink;
            _x.scheduleddurationminutes = scheduleddurationminutes;
            _x.senton = senton;
            _x.scheduledstart = scheduledstart;
            _x.statecode = statecode;
            _x.subject = subject;
            _x.postponeactivityprocessinguntil = postponeactivityprocessinguntil;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.exchangerate = exchangerate;
            _x.isregularactivity = isregularactivity;
            _x.deliveryprioritycode = deliveryprioritycode;
            _x.activityadditionalparams = activityadditionalparams;
            _x.traversedpath = traversedpath;
            _x._createdby_value = _createdby_value;
            _x.activitytypecode = activitytypecode;
            _x._ownerid_value = _ownerid_value;
            _x.modifiedon = modifiedon;
            _x._slainvokedid_value = _slainvokedid_value;
            _x.statuscode = statuscode;
            _x.actualend = actualend;
            _x.dayofmonth = dayofmonth;
            _x.patternendtype = patternendtype;
            _x.isalldayevent = isalldayevent;
            _x.outlookownerapptid = outlookownerapptid;
            _x.lastexpandedinstancedate = lastexpandedinstancedate;
            _x.overriddencreatedon = overriddencreatedon;
            _x.location = location;
            _x.effectivestartdate = effectivestartdate;
            _x._ruleid_value = _ruleid_value;
            _x.category = category;
            _x.patternstartdate = patternstartdate;
            _x.nextexpansioninstancedate = nextexpansioninstancedate;
            _x.starttime = starttime;
            _x.effectiveenddate = effectiveenddate;
            _x.isnthmonthly = isnthmonthly;
            _x._groupid_value = _groupid_value;
            _x.seriesstatus = seriesstatus;
            _x.isregenerate = isregenerate;
            _x.patternenddate = patternenddate;
            _x.monthofyear = monthofyear;
            _x.duration = duration;
            _x.isunsafe = isunsafe;
            _x.isnthyearly = isnthyearly;
            _x.globalobjectid = globalobjectid;
            _x.importsequencenumber = importsequencenumber;
            _x.daysofweekmask = daysofweekmask;
            _x.deletedexceptionslist = deletedexceptionslist;
            _x.subcategory = subcategory;
            _x.recurrencepatterntype = recurrencepatterntype;
            _x.endtime = endtime;
            _x.occurrences = occurrences;
            _x.firstdayofweek = firstdayofweek;
            _x.interval = interval;
            _x.subscriptionid = subscriptionid;
            _x.isweekdaypattern = isweekdaypattern;
            _x.expansionstatecode = expansionstatecode;
            _x.instance = instance;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && activityid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(activityid.toString()));
        }
    }

    @Property(name="dayofmonth")
    @JsonIgnore
    public Optional<Integer> getDayofmonth() {
        return Optional.ofNullable(dayofmonth);
    }

    public Recurringappointmentmaster withDayofmonth(Integer dayofmonth) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("dayofmonth");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.dayofmonth = dayofmonth;
        return _x;
    }

    @Property(name="patternendtype")
    @JsonIgnore
    public Optional<Integer> getPatternendtype() {
        return Optional.ofNullable(patternendtype);
    }

    public Recurringappointmentmaster withPatternendtype(Integer patternendtype) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("patternendtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.patternendtype = patternendtype;
        return _x;
    }

    @Property(name="isalldayevent")
    @JsonIgnore
    public Optional<Boolean> getIsalldayevent() {
        return Optional.ofNullable(isalldayevent);
    }

    public Recurringappointmentmaster withIsalldayevent(Boolean isalldayevent) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("isalldayevent");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.isalldayevent = isalldayevent;
        return _x;
    }

    @Property(name="outlookownerapptid")
    @JsonIgnore
    public Optional<Integer> getOutlookownerapptid() {
        return Optional.ofNullable(outlookownerapptid);
    }

    public Recurringappointmentmaster withOutlookownerapptid(Integer outlookownerapptid) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("outlookownerapptid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.outlookownerapptid = outlookownerapptid;
        return _x;
    }

    @Property(name="lastexpandedinstancedate")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastexpandedinstancedate() {
        return Optional.ofNullable(lastexpandedinstancedate);
    }

    public Recurringappointmentmaster withLastexpandedinstancedate(OffsetDateTime lastexpandedinstancedate) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("lastexpandedinstancedate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.lastexpandedinstancedate = lastexpandedinstancedate;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Recurringappointmentmaster withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="location")
    @JsonIgnore
    public Optional<String> getLocation() {
        return Optional.ofNullable(location);
    }

    public Recurringappointmentmaster withLocation(String location) {
        Checks.checkIsAscii(location);
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("location");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.location = location;
        return _x;
    }

    @Property(name="effectivestartdate")
    @JsonIgnore
    public Optional<OffsetDateTime> getEffectivestartdate() {
        return Optional.ofNullable(effectivestartdate);
    }

    public Recurringappointmentmaster withEffectivestartdate(OffsetDateTime effectivestartdate) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("effectivestartdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.effectivestartdate = effectivestartdate;
        return _x;
    }

    @Property(name="_ruleid_value")
    @JsonIgnore
    public Optional<String> get_ruleid_value() {
        return Optional.ofNullable(_ruleid_value);
    }

    public Recurringappointmentmaster with_ruleid_value(String _ruleid_value) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("_ruleid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x._ruleid_value = _ruleid_value;
        return _x;
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<String> getCategory() {
        return Optional.ofNullable(category);
    }

    public Recurringappointmentmaster withCategory(String category) {
        Checks.checkIsAscii(category);
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.category = category;
        return _x;
    }

    @Property(name="patternstartdate")
    @JsonIgnore
    public Optional<OffsetDateTime> getPatternstartdate() {
        return Optional.ofNullable(patternstartdate);
    }

    public Recurringappointmentmaster withPatternstartdate(OffsetDateTime patternstartdate) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("patternstartdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.patternstartdate = patternstartdate;
        return _x;
    }

    @Property(name="nextexpansioninstancedate")
    @JsonIgnore
    public Optional<OffsetDateTime> getNextexpansioninstancedate() {
        return Optional.ofNullable(nextexpansioninstancedate);
    }

    public Recurringappointmentmaster withNextexpansioninstancedate(OffsetDateTime nextexpansioninstancedate) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("nextexpansioninstancedate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.nextexpansioninstancedate = nextexpansioninstancedate;
        return _x;
    }

    @Property(name="starttime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStarttime() {
        return Optional.ofNullable(starttime);
    }

    public Recurringappointmentmaster withStarttime(OffsetDateTime starttime) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("starttime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.starttime = starttime;
        return _x;
    }

    @Property(name="effectiveenddate")
    @JsonIgnore
    public Optional<OffsetDateTime> getEffectiveenddate() {
        return Optional.ofNullable(effectiveenddate);
    }

    public Recurringappointmentmaster withEffectiveenddate(OffsetDateTime effectiveenddate) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("effectiveenddate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.effectiveenddate = effectiveenddate;
        return _x;
    }

    @Property(name="isnthmonthly")
    @JsonIgnore
    public Optional<Boolean> getIsnthmonthly() {
        return Optional.ofNullable(isnthmonthly);
    }

    public Recurringappointmentmaster withIsnthmonthly(Boolean isnthmonthly) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("isnthmonthly");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.isnthmonthly = isnthmonthly;
        return _x;
    }

    @Property(name="_groupid_value")
    @JsonIgnore
    public Optional<String> get_groupid_value() {
        return Optional.ofNullable(_groupid_value);
    }

    public Recurringappointmentmaster with_groupid_value(String _groupid_value) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("_groupid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x._groupid_value = _groupid_value;
        return _x;
    }

    @Property(name="seriesstatus")
    @JsonIgnore
    public Optional<Boolean> getSeriesstatus() {
        return Optional.ofNullable(seriesstatus);
    }

    public Recurringappointmentmaster withSeriesstatus(Boolean seriesstatus) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("seriesstatus");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.seriesstatus = seriesstatus;
        return _x;
    }

    @Property(name="isregenerate")
    @JsonIgnore
    public Optional<Boolean> getIsregenerate() {
        return Optional.ofNullable(isregenerate);
    }

    public Recurringappointmentmaster withIsregenerate(Boolean isregenerate) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("isregenerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.isregenerate = isregenerate;
        return _x;
    }

    @Property(name="patternenddate")
    @JsonIgnore
    public Optional<OffsetDateTime> getPatternenddate() {
        return Optional.ofNullable(patternenddate);
    }

    public Recurringappointmentmaster withPatternenddate(OffsetDateTime patternenddate) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("patternenddate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.patternenddate = patternenddate;
        return _x;
    }

    @Property(name="monthofyear")
    @JsonIgnore
    public Optional<Integer> getMonthofyear() {
        return Optional.ofNullable(monthofyear);
    }

    public Recurringappointmentmaster withMonthofyear(Integer monthofyear) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("monthofyear");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.monthofyear = monthofyear;
        return _x;
    }

    @Property(name="duration")
    @JsonIgnore
    public Optional<Integer> getDuration() {
        return Optional.ofNullable(duration);
    }

    public Recurringappointmentmaster withDuration(Integer duration) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("duration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.duration = duration;
        return _x;
    }

    @Property(name="isunsafe")
    @JsonIgnore
    public Optional<Integer> getIsunsafe() {
        return Optional.ofNullable(isunsafe);
    }

    public Recurringappointmentmaster withIsunsafe(Integer isunsafe) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("isunsafe");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.isunsafe = isunsafe;
        return _x;
    }

    @Property(name="isnthyearly")
    @JsonIgnore
    public Optional<Boolean> getIsnthyearly() {
        return Optional.ofNullable(isnthyearly);
    }

    public Recurringappointmentmaster withIsnthyearly(Boolean isnthyearly) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("isnthyearly");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.isnthyearly = isnthyearly;
        return _x;
    }

    @Property(name="globalobjectid")
    @JsonIgnore
    public Optional<String> getGlobalobjectid() {
        return Optional.ofNullable(globalobjectid);
    }

    public Recurringappointmentmaster withGlobalobjectid(String globalobjectid) {
        Checks.checkIsAscii(globalobjectid);
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("globalobjectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.globalobjectid = globalobjectid;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Recurringappointmentmaster withImportsequencenumber(Integer importsequencenumber) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="daysofweekmask")
    @JsonIgnore
    public Optional<Integer> getDaysofweekmask() {
        return Optional.ofNullable(daysofweekmask);
    }

    public Recurringappointmentmaster withDaysofweekmask(Integer daysofweekmask) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("daysofweekmask");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.daysofweekmask = daysofweekmask;
        return _x;
    }

    @Property(name="deletedexceptionslist")
    @JsonIgnore
    public Optional<String> getDeletedexceptionslist() {
        return Optional.ofNullable(deletedexceptionslist);
    }

    public Recurringappointmentmaster withDeletedexceptionslist(String deletedexceptionslist) {
        Checks.checkIsAscii(deletedexceptionslist);
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("deletedexceptionslist");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.deletedexceptionslist = deletedexceptionslist;
        return _x;
    }

    @Property(name="subcategory")
    @JsonIgnore
    public Optional<String> getSubcategory() {
        return Optional.ofNullable(subcategory);
    }

    public Recurringappointmentmaster withSubcategory(String subcategory) {
        Checks.checkIsAscii(subcategory);
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("subcategory");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.subcategory = subcategory;
        return _x;
    }

    @Property(name="recurrencepatterntype")
    @JsonIgnore
    public Optional<Integer> getRecurrencepatterntype() {
        return Optional.ofNullable(recurrencepatterntype);
    }

    public Recurringappointmentmaster withRecurrencepatterntype(Integer recurrencepatterntype) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("recurrencepatterntype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.recurrencepatterntype = recurrencepatterntype;
        return _x;
    }

    @Property(name="endtime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndtime() {
        return Optional.ofNullable(endtime);
    }

    public Recurringappointmentmaster withEndtime(OffsetDateTime endtime) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("endtime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.endtime = endtime;
        return _x;
    }

    @Property(name="occurrences")
    @JsonIgnore
    public Optional<Integer> getOccurrences() {
        return Optional.ofNullable(occurrences);
    }

    public Recurringappointmentmaster withOccurrences(Integer occurrences) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("occurrences");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.occurrences = occurrences;
        return _x;
    }

    @Property(name="firstdayofweek")
    @JsonIgnore
    public Optional<Integer> getFirstdayofweek() {
        return Optional.ofNullable(firstdayofweek);
    }

    public Recurringappointmentmaster withFirstdayofweek(Integer firstdayofweek) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("firstdayofweek");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.firstdayofweek = firstdayofweek;
        return _x;
    }

    @Property(name="interval")
    @JsonIgnore
    public Optional<Integer> getInterval() {
        return Optional.ofNullable(interval);
    }

    public Recurringappointmentmaster withInterval(Integer interval) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("interval");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.interval = interval;
        return _x;
    }

    @Property(name="subscriptionid")
    @JsonIgnore
    public Optional<String> getSubscriptionid() {
        return Optional.ofNullable(subscriptionid);
    }

    public Recurringappointmentmaster withSubscriptionid(String subscriptionid) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("subscriptionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.subscriptionid = subscriptionid;
        return _x;
    }

    @Property(name="isweekdaypattern")
    @JsonIgnore
    public Optional<Boolean> getIsweekdaypattern() {
        return Optional.ofNullable(isweekdaypattern);
    }

    public Recurringappointmentmaster withIsweekdaypattern(Boolean isweekdaypattern) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("isweekdaypattern");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.isweekdaypattern = isweekdaypattern;
        return _x;
    }

    @Property(name="expansionstatecode")
    @JsonIgnore
    public Optional<Integer> getExpansionstatecode() {
        return Optional.ofNullable(expansionstatecode);
    }

    public Recurringappointmentmaster withExpansionstatecode(Integer expansionstatecode) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("expansionstatecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.expansionstatecode = expansionstatecode;
        return _x;
    }

    @Property(name="instance")
    @JsonIgnore
    public Optional<Integer> getInstance() {
        return Optional.ofNullable(instance);
    }

    public Recurringappointmentmaster withInstance(Integer instance) {
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = changedFields.add("instance");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurringappointmentmaster");
        _x.instance = instance;
        return _x;
    }

    public Recurringappointmentmaster withUnmappedField(String name, String value) {
        Recurringappointmentmaster _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="recurringappointmentmaster_PostRegardings")
    @JsonIgnore
    public PostregardingCollectionRequest getRecurringappointmentmaster_PostRegardings() {
        return new PostregardingCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_PostRegardings"), RequestHelper.getValue(unmappedFields, "recurringappointmentmaster_PostRegardings"));
    }

    @NavigationProperty(name="recurringappointmentmaster_PostFollows")
    @JsonIgnore
    public PostfollowCollectionRequest getRecurringappointmentmaster_PostFollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_PostFollows"), RequestHelper.getValue(unmappedFields, "recurringappointmentmaster_PostFollows"));
    }

    @NavigationProperty(name="regardingobjectid_knowledgebaserecord_recurringappointmentmaster")
    @JsonIgnore
    public KnowledgebaserecordRequest getRegardingobjectid_knowledgebaserecord_recurringappointmentmaster() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("regardingobjectid_knowledgebaserecord_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "regardingobjectid_knowledgebaserecord_recurringappointmentmaster"));
    }

    @NavigationProperty(name="RecurringAppointmentMaster_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getRecurringAppointmentMaster_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "RecurringAppointmentMaster_BulkDeleteFailures"));
    }

    @NavigationProperty(name="RecurringAppointmentMaster_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getRecurringAppointmentMaster_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_AsyncOperations"), RequestHelper.getValue(unmappedFields, "RecurringAppointmentMaster_AsyncOperations"));
    }

    @NavigationProperty(name="RecurringAppointmentMaster_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getRecurringAppointmentMaster_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "RecurringAppointmentMaster_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="owninguser_recurringappointmentmaster")
    @JsonIgnore
    public SystemuserRequest getOwninguser_recurringappointmentmaster() {
        return new SystemuserRequest(contextPath.addSegment("owninguser_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "owninguser_recurringappointmentmaster"));
    }

    @NavigationProperty(name="recurringappointmentmaster_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getRecurringappointmentmaster_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "recurringappointmentmaster_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="owningteam_recurringappointmentmaster")
    @JsonIgnore
    public TeamRequest getOwningteam_recurringappointmentmaster() {
        return new TeamRequest(contextPath.addSegment("owningteam_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "owningteam_recurringappointmentmaster"));
    }

    @NavigationProperty(name="activityid_activitypointer")
    @JsonIgnore
    public ActivitypointerRequest getActivityid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("activityid_activitypointer"), RequestHelper.getValue(unmappedFields, "activityid_activitypointer"));
    }

    @NavigationProperty(name="recurringappointmentmaster_activity_parties")
    @JsonIgnore
    public ActivitypartyCollectionRequest getRecurringappointmentmaster_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_activity_parties"), RequestHelper.getValue(unmappedFields, "recurringappointmentmaster_activity_parties"));
    }

    @NavigationProperty(name="RecurringAppointmentMaster_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getRecurringAppointmentMaster_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "RecurringAppointmentMaster_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="owningbusinessunit_recurringappointmentmaster")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit_recurringappointmentmaster() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "owningbusinessunit_recurringappointmentmaster"));
    }

    @NavigationProperty(name="createdonbehalfby_recurringappointmentmaster")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby_recurringappointmentmaster() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "createdonbehalfby_recurringappointmentmaster"));
    }

    @NavigationProperty(name="createdby_recurringappointmentmaster")
    @JsonIgnore
    public SystemuserRequest getCreatedby_recurringappointmentmaster() {
        return new SystemuserRequest(contextPath.addSegment("createdby_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "createdby_recurringappointmentmaster"));
    }

    @NavigationProperty(name="regardingobjectid_knowledgearticle_recurringappointmentmaster")
    @JsonIgnore
    public KnowledgearticleRequest getRegardingobjectid_knowledgearticle_recurringappointmentmaster() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "regardingobjectid_knowledgearticle_recurringappointmentmaster"));
    }

    @NavigationProperty(name="recurringappointmentmaster_appointment")
    @JsonIgnore
    public AppointmentCollectionRequest getRecurringappointmentmaster_appointment() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_appointment"), RequestHelper.getValue(unmappedFields, "recurringappointmentmaster_appointment"));
    }

    @NavigationProperty(name="regardingobjectid_account_recurringappointmentmaster")
    @JsonIgnore
    public AccountRequest getRegardingobjectid_account_recurringappointmentmaster() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "regardingobjectid_account_recurringappointmentmaster"));
    }

    @NavigationProperty(name="RecurringAppointmentMaster_QueueItem")
    @JsonIgnore
    public QueueitemCollectionRequest getRecurringAppointmentMaster_QueueItem() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_QueueItem"), RequestHelper.getValue(unmappedFields, "RecurringAppointmentMaster_QueueItem"));
    }

    @NavigationProperty(name="recurringappointmentmaster_connections1")
    @JsonIgnore
    public ConnectionCollectionRequest getRecurringappointmentmaster_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_connections1"), RequestHelper.getValue(unmappedFields, "recurringappointmentmaster_connections1"));
    }

    @NavigationProperty(name="modifiedonbehalfby_recurringappointmentmaster")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby_recurringappointmentmaster() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby_recurringappointmentmaster"));
    }

    @NavigationProperty(name="transactioncurrencyid_recurringappointmentmaster")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid_recurringappointmentmaster() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid_recurringappointmentmaster"));
    }

    @NavigationProperty(name="recurringappointmentmaster_connections2")
    @JsonIgnore
    public ConnectionCollectionRequest getRecurringappointmentmaster_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_connections2"), RequestHelper.getValue(unmappedFields, "recurringappointmentmaster_connections2"));
    }

    @NavigationProperty(name="RecurringAppointmentMaster_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getRecurringAppointmentMaster_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_SyncErrors"), RequestHelper.getValue(unmappedFields, "RecurringAppointmentMaster_SyncErrors"));
    }

    @NavigationProperty(name="stageid_processstage")
    @JsonIgnore
    public ProcessstageRequest getStageid_processstage() {
        return new ProcessstageRequest(contextPath.addSegment("stageid_processstage"), RequestHelper.getValue(unmappedFields, "stageid_processstage"));
    }

    @NavigationProperty(name="recurringappointmentmaster_actioncard")
    @JsonIgnore
    public ActioncardCollectionRequest getRecurringappointmentmaster_actioncard() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_actioncard"), RequestHelper.getValue(unmappedFields, "recurringappointmentmaster_actioncard"));
    }

    @NavigationProperty(name="regardingobjectid_contact_recurringappointmentmaster")
    @JsonIgnore
    public ContactRequest getRegardingobjectid_contact_recurringappointmentmaster() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "regardingobjectid_contact_recurringappointmentmaster"));
    }

    @NavigationProperty(name="modifiedby_recurringappointmentmaster")
    @JsonIgnore
    public SystemuserRequest getModifiedby_recurringappointmentmaster() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "modifiedby_recurringappointmentmaster"));
    }

    @NavigationProperty(name="activityid_recurrencerule")
    @JsonIgnore
    public RecurrenceruleRequest getActivityid_recurrencerule() {
        return new RecurrenceruleRequest(contextPath.addSegment("activityid_recurrencerule"), RequestHelper.getValue(unmappedFields, "activityid_recurrencerule"));
    }

    @NavigationProperty(name="RecurringAppointmentMaster_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getRecurringAppointmentMaster_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_ProcessSessions"), RequestHelper.getValue(unmappedFields, "RecurringAppointmentMaster_ProcessSessions"));
    }

    @NavigationProperty(name="RecurringAppointmentMaster_Annotation")
    @JsonIgnore
    public AnnotationCollectionRequest getRecurringAppointmentMaster_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_Annotation"), RequestHelper.getValue(unmappedFields, "RecurringAppointmentMaster_Annotation"));
    }

    @NavigationProperty(name="ownerid_recurringappointmentmaster")
    @JsonIgnore
    public PrincipalRequest getOwnerid_recurringappointmentmaster() {
        return new PrincipalRequest(contextPath.addSegment("ownerid_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "ownerid_recurringappointmentmaster"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Recurringappointmentmaster patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Recurringappointmentmaster put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Recurringappointmentmaster _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Recurringappointmentmaster _copy() {
        Recurringappointmentmaster _x = new Recurringappointmentmaster();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.lastonholdtime = lastonholdtime;
        _x.actualdurationminutes = actualdurationminutes;
        _x._owningteam_value = _owningteam_value;
        _x.exchangeitemid = exchangeitemid;
        _x.ismapiprivate = ismapiprivate;
        _x.createdon = createdon;
        _x.seriesid = seriesid;
        _x.leftvoicemail = leftvoicemail;
        _x.deliverylastattemptedon = deliverylastattemptedon;
        _x.isbilled = isbilled;
        _x.isworkflowcreated = isworkflowcreated;
        _x._sendermailboxid_value = _sendermailboxid_value;
        _x.description = description;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x.onholdtime = onholdtime;
        _x._modifiedby_value = _modifiedby_value;
        _x.community = community;
        _x.activityid = activityid;
        _x.sortdate = sortdate;
        _x.instancetypecode = instancetypecode;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.versionnumber = versionnumber;
        _x.processid = processid;
        _x.scheduledend = scheduledend;
        _x.prioritycode = prioritycode;
        _x._slaid_value = _slaid_value;
        _x.stageid = stageid;
        _x.actualstart = actualstart;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._owninguser_value = _owninguser_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.exchangeweblink = exchangeweblink;
        _x.scheduleddurationminutes = scheduleddurationminutes;
        _x.senton = senton;
        _x.scheduledstart = scheduledstart;
        _x.statecode = statecode;
        _x.subject = subject;
        _x.postponeactivityprocessinguntil = postponeactivityprocessinguntil;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.exchangerate = exchangerate;
        _x.isregularactivity = isregularactivity;
        _x.deliveryprioritycode = deliveryprioritycode;
        _x.activityadditionalparams = activityadditionalparams;
        _x.traversedpath = traversedpath;
        _x._createdby_value = _createdby_value;
        _x.activitytypecode = activitytypecode;
        _x._ownerid_value = _ownerid_value;
        _x.modifiedon = modifiedon;
        _x._slainvokedid_value = _slainvokedid_value;
        _x.statuscode = statuscode;
        _x.actualend = actualend;
        _x.dayofmonth = dayofmonth;
        _x.patternendtype = patternendtype;
        _x.isalldayevent = isalldayevent;
        _x.outlookownerapptid = outlookownerapptid;
        _x.lastexpandedinstancedate = lastexpandedinstancedate;
        _x.overriddencreatedon = overriddencreatedon;
        _x.location = location;
        _x.effectivestartdate = effectivestartdate;
        _x._ruleid_value = _ruleid_value;
        _x.category = category;
        _x.patternstartdate = patternstartdate;
        _x.nextexpansioninstancedate = nextexpansioninstancedate;
        _x.starttime = starttime;
        _x.effectiveenddate = effectiveenddate;
        _x.isnthmonthly = isnthmonthly;
        _x._groupid_value = _groupid_value;
        _x.seriesstatus = seriesstatus;
        _x.isregenerate = isregenerate;
        _x.patternenddate = patternenddate;
        _x.monthofyear = monthofyear;
        _x.duration = duration;
        _x.isunsafe = isunsafe;
        _x.isnthyearly = isnthyearly;
        _x.globalobjectid = globalobjectid;
        _x.importsequencenumber = importsequencenumber;
        _x.daysofweekmask = daysofweekmask;
        _x.deletedexceptionslist = deletedexceptionslist;
        _x.subcategory = subcategory;
        _x.recurrencepatterntype = recurrencepatterntype;
        _x.endtime = endtime;
        _x.occurrences = occurrences;
        _x.firstdayofweek = firstdayofweek;
        _x.interval = interval;
        _x.subscriptionid = subscriptionid;
        _x.isweekdaypattern = isweekdaypattern;
        _x.expansionstatecode = expansionstatecode;
        _x.instance = instance;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Recurringappointmentmaster[");
        b.append("lastonholdtime=");
        b.append(this.lastonholdtime);
        b.append(", ");
        b.append("actualdurationminutes=");
        b.append(this.actualdurationminutes);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("exchangeitemid=");
        b.append(this.exchangeitemid);
        b.append(", ");
        b.append("ismapiprivate=");
        b.append(this.ismapiprivate);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("seriesid=");
        b.append(this.seriesid);
        b.append(", ");
        b.append("leftvoicemail=");
        b.append(this.leftvoicemail);
        b.append(", ");
        b.append("deliverylastattemptedon=");
        b.append(this.deliverylastattemptedon);
        b.append(", ");
        b.append("isbilled=");
        b.append(this.isbilled);
        b.append(", ");
        b.append("isworkflowcreated=");
        b.append(this.isworkflowcreated);
        b.append(", ");
        b.append("_sendermailboxid_value=");
        b.append(this._sendermailboxid_value);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("onholdtime=");
        b.append(this.onholdtime);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("community=");
        b.append(this.community);
        b.append(", ");
        b.append("activityid=");
        b.append(this.activityid);
        b.append(", ");
        b.append("sortdate=");
        b.append(this.sortdate);
        b.append(", ");
        b.append("instancetypecode=");
        b.append(this.instancetypecode);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("processid=");
        b.append(this.processid);
        b.append(", ");
        b.append("scheduledend=");
        b.append(this.scheduledend);
        b.append(", ");
        b.append("prioritycode=");
        b.append(this.prioritycode);
        b.append(", ");
        b.append("_slaid_value=");
        b.append(this._slaid_value);
        b.append(", ");
        b.append("stageid=");
        b.append(this.stageid);
        b.append(", ");
        b.append("actualstart=");
        b.append(this.actualstart);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("exchangeweblink=");
        b.append(this.exchangeweblink);
        b.append(", ");
        b.append("scheduleddurationminutes=");
        b.append(this.scheduleddurationminutes);
        b.append(", ");
        b.append("senton=");
        b.append(this.senton);
        b.append(", ");
        b.append("scheduledstart=");
        b.append(this.scheduledstart);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("postponeactivityprocessinguntil=");
        b.append(this.postponeactivityprocessinguntil);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("isregularactivity=");
        b.append(this.isregularactivity);
        b.append(", ");
        b.append("deliveryprioritycode=");
        b.append(this.deliveryprioritycode);
        b.append(", ");
        b.append("activityadditionalparams=");
        b.append(this.activityadditionalparams);
        b.append(", ");
        b.append("traversedpath=");
        b.append(this.traversedpath);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("activitytypecode=");
        b.append(this.activitytypecode);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_slainvokedid_value=");
        b.append(this._slainvokedid_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("actualend=");
        b.append(this.actualend);
        b.append(", ");
        b.append("dayofmonth=");
        b.append(this.dayofmonth);
        b.append(", ");
        b.append("patternendtype=");
        b.append(this.patternendtype);
        b.append(", ");
        b.append("isalldayevent=");
        b.append(this.isalldayevent);
        b.append(", ");
        b.append("outlookownerapptid=");
        b.append(this.outlookownerapptid);
        b.append(", ");
        b.append("lastexpandedinstancedate=");
        b.append(this.lastexpandedinstancedate);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("effectivestartdate=");
        b.append(this.effectivestartdate);
        b.append(", ");
        b.append("_ruleid_value=");
        b.append(this._ruleid_value);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("patternstartdate=");
        b.append(this.patternstartdate);
        b.append(", ");
        b.append("nextexpansioninstancedate=");
        b.append(this.nextexpansioninstancedate);
        b.append(", ");
        b.append("starttime=");
        b.append(this.starttime);
        b.append(", ");
        b.append("effectiveenddate=");
        b.append(this.effectiveenddate);
        b.append(", ");
        b.append("isnthmonthly=");
        b.append(this.isnthmonthly);
        b.append(", ");
        b.append("_groupid_value=");
        b.append(this._groupid_value);
        b.append(", ");
        b.append("seriesstatus=");
        b.append(this.seriesstatus);
        b.append(", ");
        b.append("isregenerate=");
        b.append(this.isregenerate);
        b.append(", ");
        b.append("patternenddate=");
        b.append(this.patternenddate);
        b.append(", ");
        b.append("monthofyear=");
        b.append(this.monthofyear);
        b.append(", ");
        b.append("duration=");
        b.append(this.duration);
        b.append(", ");
        b.append("isunsafe=");
        b.append(this.isunsafe);
        b.append(", ");
        b.append("isnthyearly=");
        b.append(this.isnthyearly);
        b.append(", ");
        b.append("globalobjectid=");
        b.append(this.globalobjectid);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("daysofweekmask=");
        b.append(this.daysofweekmask);
        b.append(", ");
        b.append("deletedexceptionslist=");
        b.append(this.deletedexceptionslist);
        b.append(", ");
        b.append("subcategory=");
        b.append(this.subcategory);
        b.append(", ");
        b.append("recurrencepatterntype=");
        b.append(this.recurrencepatterntype);
        b.append(", ");
        b.append("endtime=");
        b.append(this.endtime);
        b.append(", ");
        b.append("occurrences=");
        b.append(this.occurrences);
        b.append(", ");
        b.append("firstdayofweek=");
        b.append(this.firstdayofweek);
        b.append(", ");
        b.append("interval=");
        b.append(this.interval);
        b.append(", ");
        b.append("subscriptionid=");
        b.append(this.subscriptionid);
        b.append(", ");
        b.append("isweekdaypattern=");
        b.append(this.isweekdaypattern);
        b.append(", ");
        b.append("expansionstatecode=");
        b.append(this.expansionstatecode);
        b.append(", ");
        b.append("instance=");
        b.append(this.instance);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
