package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "msdyn_lookupattributeforsla", 
    "modifiedon", 
    "statuscode", 
    "timezoneruleversionnumber", 
    "_owningteam_value", 
    "overriddencreatedon", 
    "statecode", 
    "versionnumber", 
    "_owningbusinessunit_value", 
    "msdyn_pausestate", 
    "_ownerid_value", 
    "msdyn_organizationid", 
    "_modifiedonbehalfby_value", 
    "_createdonbehalfby_value", 
    "_createdby_value", 
    "importsequencenumber", 
    "msdyn_entitylogicalname", 
    "msdyn_serviceconfigurationid", 
    "createdon", 
    "_owninguser_value", 
    "utcconversiontimezonecode", 
    "msdyn_name", 
    "_modifiedby_value"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_serviceconfiguration extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration";
    }

    @JsonProperty("msdyn_lookupattributeforsla")
    protected String msdyn_lookupattributeforsla;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("msdyn_pausestate")
    protected String msdyn_pausestate;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("msdyn_organizationid")
    protected String msdyn_organizationid;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("msdyn_entitylogicalname")
    protected String msdyn_entitylogicalname;

    @JsonProperty("msdyn_serviceconfigurationid")
    protected String msdyn_serviceconfigurationid;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    protected Msdyn_serviceconfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_serviceconfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String msdyn_lookupattributeforsla;
        private OffsetDateTime modifiedon;
        private Integer statuscode;
        private Integer timezoneruleversionnumber;
        private String _owningteam_value;
        private OffsetDateTime overriddencreatedon;
        private Integer statecode;
        private Long versionnumber;
        private String _owningbusinessunit_value;
        private String msdyn_pausestate;
        private String _ownerid_value;
        private String msdyn_organizationid;
        private String _modifiedonbehalfby_value;
        private String _createdonbehalfby_value;
        private String _createdby_value;
        private Integer importsequencenumber;
        private String msdyn_entitylogicalname;
        private String msdyn_serviceconfigurationid;
        private OffsetDateTime createdon;
        private String _owninguser_value;
        private Integer utcconversiontimezonecode;
        private String msdyn_name;
        private String _modifiedby_value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder msdyn_lookupattributeforsla(String msdyn_lookupattributeforsla) {
            this.msdyn_lookupattributeforsla = msdyn_lookupattributeforsla;
            this.changedFields = changedFields.add("msdyn_lookupattributeforsla");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder msdyn_pausestate(String msdyn_pausestate) {
            this.msdyn_pausestate = msdyn_pausestate;
            this.changedFields = changedFields.add("msdyn_pausestate");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder msdyn_organizationid(String msdyn_organizationid) {
            this.msdyn_organizationid = msdyn_organizationid;
            this.changedFields = changedFields.add("msdyn_organizationid");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder msdyn_entitylogicalname(String msdyn_entitylogicalname) {
            this.msdyn_entitylogicalname = msdyn_entitylogicalname;
            this.changedFields = changedFields.add("msdyn_entitylogicalname");
            return this;
        }

        public Builder msdyn_serviceconfigurationid(String msdyn_serviceconfigurationid) {
            this.msdyn_serviceconfigurationid = msdyn_serviceconfigurationid;
            this.changedFields = changedFields.add("msdyn_serviceconfigurationid");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Msdyn_serviceconfiguration build() {
            Msdyn_serviceconfiguration _x = new Msdyn_serviceconfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration";
            _x.msdyn_lookupattributeforsla = msdyn_lookupattributeforsla;
            _x.modifiedon = modifiedon;
            _x.statuscode = statuscode;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._owningteam_value = _owningteam_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.statecode = statecode;
            _x.versionnumber = versionnumber;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.msdyn_pausestate = msdyn_pausestate;
            _x._ownerid_value = _ownerid_value;
            _x.msdyn_organizationid = msdyn_organizationid;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._createdby_value = _createdby_value;
            _x.importsequencenumber = importsequencenumber;
            _x.msdyn_entitylogicalname = msdyn_entitylogicalname;
            _x.msdyn_serviceconfigurationid = msdyn_serviceconfigurationid;
            _x.createdon = createdon;
            _x._owninguser_value = _owninguser_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.msdyn_name = msdyn_name;
            _x._modifiedby_value = _modifiedby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_serviceconfigurationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_serviceconfigurationid.toString()));
        }
    }

    @Property(name="msdyn_lookupattributeforsla")
    @JsonIgnore
    public Optional<String> getMsdyn_lookupattributeforsla() {
        return Optional.ofNullable(msdyn_lookupattributeforsla);
    }

    public Msdyn_serviceconfiguration withMsdyn_lookupattributeforsla(String msdyn_lookupattributeforsla) {
        Checks.checkIsAscii(msdyn_lookupattributeforsla);
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_lookupattributeforsla");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x.msdyn_lookupattributeforsla = msdyn_lookupattributeforsla;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_serviceconfiguration withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_serviceconfiguration withStatuscode(Integer statuscode) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_serviceconfiguration withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_serviceconfiguration with_owningteam_value(String _owningteam_value) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_serviceconfiguration withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_serviceconfiguration withStatecode(Integer statecode) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_serviceconfiguration withVersionnumber(Long versionnumber) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_serviceconfiguration with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="msdyn_pausestate")
    @JsonIgnore
    public Optional<String> getMsdyn_pausestate() {
        return Optional.ofNullable(msdyn_pausestate);
    }

    public Msdyn_serviceconfiguration withMsdyn_pausestate(String msdyn_pausestate) {
        Checks.checkIsAscii(msdyn_pausestate);
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_pausestate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x.msdyn_pausestate = msdyn_pausestate;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_serviceconfiguration with_ownerid_value(String _ownerid_value) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="msdyn_organizationid")
    @JsonIgnore
    public Optional<String> getMsdyn_organizationid() {
        return Optional.ofNullable(msdyn_organizationid);
    }

    public Msdyn_serviceconfiguration withMsdyn_organizationid(String msdyn_organizationid) {
        Checks.checkIsAscii(msdyn_organizationid);
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_organizationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x.msdyn_organizationid = msdyn_organizationid;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_serviceconfiguration with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_serviceconfiguration with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_serviceconfiguration with_createdby_value(String _createdby_value) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_serviceconfiguration withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="msdyn_entitylogicalname")
    @JsonIgnore
    public Optional<String> getMsdyn_entitylogicalname() {
        return Optional.ofNullable(msdyn_entitylogicalname);
    }

    public Msdyn_serviceconfiguration withMsdyn_entitylogicalname(String msdyn_entitylogicalname) {
        Checks.checkIsAscii(msdyn_entitylogicalname);
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_entitylogicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x.msdyn_entitylogicalname = msdyn_entitylogicalname;
        return _x;
    }

    @Property(name="msdyn_serviceconfigurationid")
    @JsonIgnore
    public Optional<String> getMsdyn_serviceconfigurationid() {
        return Optional.ofNullable(msdyn_serviceconfigurationid);
    }

    public Msdyn_serviceconfiguration withMsdyn_serviceconfigurationid(String msdyn_serviceconfigurationid) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_serviceconfigurationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x.msdyn_serviceconfigurationid = msdyn_serviceconfigurationid;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_serviceconfiguration withCreatedon(OffsetDateTime createdon) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_serviceconfiguration with_owninguser_value(String _owninguser_value) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_serviceconfiguration withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_serviceconfiguration withMsdyn_name(String msdyn_name) {
        Checks.checkIsAscii(msdyn_name);
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_serviceconfiguration with_modifiedby_value(String _modifiedby_value) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_serviceconfiguration");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    public Msdyn_serviceconfiguration withUnmappedField(String name, String value) {
        Msdyn_serviceconfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_serviceconfiguration_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_serviceconfiguration_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_serviceconfiguration_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_serviceconfiguration_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_serviceconfiguration_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_serviceconfiguration_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_serviceconfiguration_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_serviceconfiguration_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_serviceconfiguration_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_serviceconfiguration_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_serviceconfiguration_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_serviceconfiguration_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_serviceconfiguration_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_serviceconfiguration_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_serviceconfiguration_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_serviceconfiguration_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_serviceconfiguration_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_serviceconfiguration_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_serviceconfiguration_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_serviceconfiguration_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_serviceconfiguration_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_serviceconfiguration_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_serviceconfiguration_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_serviceconfiguration_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_serviceconfiguration_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_serviceconfiguration_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_serviceconfiguration_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_serviceconfiguration_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_serviceconfiguration_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_serviceconfiguration_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_serviceconfiguration_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_serviceconfiguration_PrincipalObjectAttributeAccesses"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_serviceconfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_serviceconfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_serviceconfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_serviceconfiguration _copy() {
        Msdyn_serviceconfiguration _x = new Msdyn_serviceconfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.msdyn_lookupattributeforsla = msdyn_lookupattributeforsla;
        _x.modifiedon = modifiedon;
        _x.statuscode = statuscode;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._owningteam_value = _owningteam_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.statecode = statecode;
        _x.versionnumber = versionnumber;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.msdyn_pausestate = msdyn_pausestate;
        _x._ownerid_value = _ownerid_value;
        _x.msdyn_organizationid = msdyn_organizationid;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._createdby_value = _createdby_value;
        _x.importsequencenumber = importsequencenumber;
        _x.msdyn_entitylogicalname = msdyn_entitylogicalname;
        _x.msdyn_serviceconfigurationid = msdyn_serviceconfigurationid;
        _x.createdon = createdon;
        _x._owninguser_value = _owninguser_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.msdyn_name = msdyn_name;
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_serviceconfiguration[");
        b.append("msdyn_lookupattributeforsla=");
        b.append(this.msdyn_lookupattributeforsla);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("msdyn_pausestate=");
        b.append(this.msdyn_pausestate);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("msdyn_organizationid=");
        b.append(this.msdyn_organizationid);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("msdyn_entitylogicalname=");
        b.append(this.msdyn_entitylogicalname);
        b.append(", ");
        b.append("msdyn_serviceconfigurationid=");
        b.append(this.msdyn_serviceconfigurationid);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
