package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_owningbusinessunit_value", 
    "msdyn_entityname", 
    "importsequencenumber", 
    "msdyn_name", 
    "statuscode", 
    "msdyn_message", 
    "msdyn_resultentitylogicalname", 
    "_ownerid_value", 
    "_msdyn_analysisresult_value", 
    "msdyn_canopenentityrecord", 
    "msdyn_resultentityid", 
    "modifiedon", 
    "createdon", 
    "_modifiedonbehalfby_value", 
    "msdyn_resultentityprimarykey", 
    "utcconversiontimezonecode", 
    "_owningteam_value", 
    "_createdby_value", 
    "versionnumber", 
    "timezoneruleversionnumber", 
    "_owninguser_value", 
    "statecode", 
    "overriddencreatedon", 
    "msdyn_analysisresultdetailid", 
    "_modifiedby_value", 
    "_createdonbehalfby_value"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_analysisresultdetail extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail";
    }

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("msdyn_entityname")
    protected String msdyn_entityname;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("msdyn_message")
    protected String msdyn_message;

    @JsonProperty("msdyn_resultentitylogicalname")
    protected String msdyn_resultentitylogicalname;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("_msdyn_analysisresult_value")
    protected String _msdyn_analysisresult_value;

    @JsonProperty("msdyn_canopenentityrecord")
    protected Boolean msdyn_canopenentityrecord;

    @JsonProperty("msdyn_resultentityid")
    protected String msdyn_resultentityid;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("msdyn_resultentityprimarykey")
    protected String msdyn_resultentityprimarykey;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("msdyn_analysisresultdetailid")
    protected String msdyn_analysisresultdetailid;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    protected Msdyn_analysisresultdetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_analysisresultdetail() {
        return new Builder();
    }

    public static final class Builder {
        private String _owningbusinessunit_value;
        private String msdyn_entityname;
        private Integer importsequencenumber;
        private String msdyn_name;
        private Integer statuscode;
        private String msdyn_message;
        private String msdyn_resultentitylogicalname;
        private String _ownerid_value;
        private String _msdyn_analysisresult_value;
        private Boolean msdyn_canopenentityrecord;
        private String msdyn_resultentityid;
        private OffsetDateTime modifiedon;
        private OffsetDateTime createdon;
        private String _modifiedonbehalfby_value;
        private String msdyn_resultentityprimarykey;
        private Integer utcconversiontimezonecode;
        private String _owningteam_value;
        private String _createdby_value;
        private Long versionnumber;
        private Integer timezoneruleversionnumber;
        private String _owninguser_value;
        private Integer statecode;
        private OffsetDateTime overriddencreatedon;
        private String msdyn_analysisresultdetailid;
        private String _modifiedby_value;
        private String _createdonbehalfby_value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder msdyn_entityname(String msdyn_entityname) {
            this.msdyn_entityname = msdyn_entityname;
            this.changedFields = changedFields.add("msdyn_entityname");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder msdyn_message(String msdyn_message) {
            this.msdyn_message = msdyn_message;
            this.changedFields = changedFields.add("msdyn_message");
            return this;
        }

        public Builder msdyn_resultentitylogicalname(String msdyn_resultentitylogicalname) {
            this.msdyn_resultentitylogicalname = msdyn_resultentitylogicalname;
            this.changedFields = changedFields.add("msdyn_resultentitylogicalname");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _msdyn_analysisresult_value(String _msdyn_analysisresult_value) {
            this._msdyn_analysisresult_value = _msdyn_analysisresult_value;
            this.changedFields = changedFields.add("_msdyn_analysisresult_value");
            return this;
        }

        public Builder msdyn_canopenentityrecord(Boolean msdyn_canopenentityrecord) {
            this.msdyn_canopenentityrecord = msdyn_canopenentityrecord;
            this.changedFields = changedFields.add("msdyn_canopenentityrecord");
            return this;
        }

        public Builder msdyn_resultentityid(String msdyn_resultentityid) {
            this.msdyn_resultentityid = msdyn_resultentityid;
            this.changedFields = changedFields.add("msdyn_resultentityid");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder msdyn_resultentityprimarykey(String msdyn_resultentityprimarykey) {
            this.msdyn_resultentityprimarykey = msdyn_resultentityprimarykey;
            this.changedFields = changedFields.add("msdyn_resultentityprimarykey");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder msdyn_analysisresultdetailid(String msdyn_analysisresultdetailid) {
            this.msdyn_analysisresultdetailid = msdyn_analysisresultdetailid;
            this.changedFields = changedFields.add("msdyn_analysisresultdetailid");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Msdyn_analysisresultdetail build() {
            Msdyn_analysisresultdetail _x = new Msdyn_analysisresultdetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail";
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.msdyn_entityname = msdyn_entityname;
            _x.importsequencenumber = importsequencenumber;
            _x.msdyn_name = msdyn_name;
            _x.statuscode = statuscode;
            _x.msdyn_message = msdyn_message;
            _x.msdyn_resultentitylogicalname = msdyn_resultentitylogicalname;
            _x._ownerid_value = _ownerid_value;
            _x._msdyn_analysisresult_value = _msdyn_analysisresult_value;
            _x.msdyn_canopenentityrecord = msdyn_canopenentityrecord;
            _x.msdyn_resultentityid = msdyn_resultentityid;
            _x.modifiedon = modifiedon;
            _x.createdon = createdon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.msdyn_resultentityprimarykey = msdyn_resultentityprimarykey;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._owningteam_value = _owningteam_value;
            _x._createdby_value = _createdby_value;
            _x.versionnumber = versionnumber;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._owninguser_value = _owninguser_value;
            _x.statecode = statecode;
            _x.overriddencreatedon = overriddencreatedon;
            _x.msdyn_analysisresultdetailid = msdyn_analysisresultdetailid;
            _x._modifiedby_value = _modifiedby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_analysisresultdetailid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_analysisresultdetailid.toString()));
        }
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_analysisresultdetail with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="msdyn_entityname")
    @JsonIgnore
    public Optional<String> getMsdyn_entityname() {
        return Optional.ofNullable(msdyn_entityname);
    }

    public Msdyn_analysisresultdetail withMsdyn_entityname(String msdyn_entityname) {
        Checks.checkIsAscii(msdyn_entityname);
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("msdyn_entityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.msdyn_entityname = msdyn_entityname;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_analysisresultdetail withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_analysisresultdetail withMsdyn_name(String msdyn_name) {
        Checks.checkIsAscii(msdyn_name);
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_analysisresultdetail withStatuscode(Integer statuscode) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="msdyn_message")
    @JsonIgnore
    public Optional<String> getMsdyn_message() {
        return Optional.ofNullable(msdyn_message);
    }

    public Msdyn_analysisresultdetail withMsdyn_message(String msdyn_message) {
        Checks.checkIsAscii(msdyn_message);
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("msdyn_message");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.msdyn_message = msdyn_message;
        return _x;
    }

    @Property(name="msdyn_resultentitylogicalname")
    @JsonIgnore
    public Optional<String> getMsdyn_resultentitylogicalname() {
        return Optional.ofNullable(msdyn_resultentitylogicalname);
    }

    public Msdyn_analysisresultdetail withMsdyn_resultentitylogicalname(String msdyn_resultentitylogicalname) {
        Checks.checkIsAscii(msdyn_resultentitylogicalname);
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("msdyn_resultentitylogicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.msdyn_resultentitylogicalname = msdyn_resultentitylogicalname;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_analysisresultdetail with_ownerid_value(String _ownerid_value) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_msdyn_analysisresult_value")
    @JsonIgnore
    public Optional<String> get_msdyn_analysisresult_value() {
        return Optional.ofNullable(_msdyn_analysisresult_value);
    }

    public Msdyn_analysisresultdetail with_msdyn_analysisresult_value(String _msdyn_analysisresult_value) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_analysisresult_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x._msdyn_analysisresult_value = _msdyn_analysisresult_value;
        return _x;
    }

    @Property(name="msdyn_canopenentityrecord")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_canopenentityrecord() {
        return Optional.ofNullable(msdyn_canopenentityrecord);
    }

    public Msdyn_analysisresultdetail withMsdyn_canopenentityrecord(Boolean msdyn_canopenentityrecord) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("msdyn_canopenentityrecord");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.msdyn_canopenentityrecord = msdyn_canopenentityrecord;
        return _x;
    }

    @Property(name="msdyn_resultentityid")
    @JsonIgnore
    public Optional<String> getMsdyn_resultentityid() {
        return Optional.ofNullable(msdyn_resultentityid);
    }

    public Msdyn_analysisresultdetail withMsdyn_resultentityid(String msdyn_resultentityid) {
        Checks.checkIsAscii(msdyn_resultentityid);
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("msdyn_resultentityid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.msdyn_resultentityid = msdyn_resultentityid;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_analysisresultdetail withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_analysisresultdetail withCreatedon(OffsetDateTime createdon) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_analysisresultdetail with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="msdyn_resultentityprimarykey")
    @JsonIgnore
    public Optional<String> getMsdyn_resultentityprimarykey() {
        return Optional.ofNullable(msdyn_resultentityprimarykey);
    }

    public Msdyn_analysisresultdetail withMsdyn_resultentityprimarykey(String msdyn_resultentityprimarykey) {
        Checks.checkIsAscii(msdyn_resultentityprimarykey);
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("msdyn_resultentityprimarykey");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.msdyn_resultentityprimarykey = msdyn_resultentityprimarykey;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_analysisresultdetail withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_analysisresultdetail with_owningteam_value(String _owningteam_value) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_analysisresultdetail with_createdby_value(String _createdby_value) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_analysisresultdetail withVersionnumber(Long versionnumber) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_analysisresultdetail withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_analysisresultdetail with_owninguser_value(String _owninguser_value) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_analysisresultdetail withStatecode(Integer statecode) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_analysisresultdetail withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="msdyn_analysisresultdetailid")
    @JsonIgnore
    public Optional<String> getMsdyn_analysisresultdetailid() {
        return Optional.ofNullable(msdyn_analysisresultdetailid);
    }

    public Msdyn_analysisresultdetail withMsdyn_analysisresultdetailid(String msdyn_analysisresultdetailid) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("msdyn_analysisresultdetailid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x.msdyn_analysisresultdetailid = msdyn_analysisresultdetailid;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_analysisresultdetail with_modifiedby_value(String _modifiedby_value) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_analysisresultdetail with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresultdetail");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    public Msdyn_analysisresultdetail withUnmappedField(String name, String value) {
        Msdyn_analysisresultdetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_analysisresultdetail_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_analysisresultdetail_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresultdetail_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresultdetail_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_analysisresultdetail_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_analysisresultdetail_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresultdetail_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresultdetail_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_analysisresultdetail_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_analysisresultdetail_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresultdetail_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresultdetail_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_analysisresultdetail_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_analysisresultdetail_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresultdetail_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresultdetail_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_analysisresultdetail_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_analysisresultdetail_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresultdetail_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresultdetail_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_analysisresultdetail_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_analysisresultdetail_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresultdetail_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresultdetail_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_analysisresultdetail_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_analysisresultdetail_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresultdetail_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresultdetail_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_analysisresultdetail_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_analysisresultdetail_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresultdetail_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresultdetail_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_AnalysisResult")
    @JsonIgnore
    public Msdyn_analysisresultRequest getMsdyn_AnalysisResult() {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("msdyn_AnalysisResult"), RequestHelper.getValue(unmappedFields, "msdyn_AnalysisResult"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_analysisresultdetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_analysisresultdetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_analysisresultdetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_analysisresultdetail _copy() {
        Msdyn_analysisresultdetail _x = new Msdyn_analysisresultdetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.msdyn_entityname = msdyn_entityname;
        _x.importsequencenumber = importsequencenumber;
        _x.msdyn_name = msdyn_name;
        _x.statuscode = statuscode;
        _x.msdyn_message = msdyn_message;
        _x.msdyn_resultentitylogicalname = msdyn_resultentitylogicalname;
        _x._ownerid_value = _ownerid_value;
        _x._msdyn_analysisresult_value = _msdyn_analysisresult_value;
        _x.msdyn_canopenentityrecord = msdyn_canopenentityrecord;
        _x.msdyn_resultentityid = msdyn_resultentityid;
        _x.modifiedon = modifiedon;
        _x.createdon = createdon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.msdyn_resultentityprimarykey = msdyn_resultentityprimarykey;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._owningteam_value = _owningteam_value;
        _x._createdby_value = _createdby_value;
        _x.versionnumber = versionnumber;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._owninguser_value = _owninguser_value;
        _x.statecode = statecode;
        _x.overriddencreatedon = overriddencreatedon;
        _x.msdyn_analysisresultdetailid = msdyn_analysisresultdetailid;
        _x._modifiedby_value = _modifiedby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_analysisresultdetail[");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("msdyn_entityname=");
        b.append(this.msdyn_entityname);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("msdyn_message=");
        b.append(this.msdyn_message);
        b.append(", ");
        b.append("msdyn_resultentitylogicalname=");
        b.append(this.msdyn_resultentitylogicalname);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_msdyn_analysisresult_value=");
        b.append(this._msdyn_analysisresult_value);
        b.append(", ");
        b.append("msdyn_canopenentityrecord=");
        b.append(this.msdyn_canopenentityrecord);
        b.append(", ");
        b.append("msdyn_resultentityid=");
        b.append(this.msdyn_resultentityid);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("msdyn_resultentityprimarykey=");
        b.append(this.msdyn_resultentityprimarykey);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("msdyn_analysisresultdetailid=");
        b.append(this.msdyn_analysisresultdetailid);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
