package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetfileRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "statecode", 
    "msdyn_aibfileattacheddataid", 
    "_ownerid_value", 
    "_createdby_value", 
    "msdyn_key", 
    "_modifiedby_value", 
    "msdyn_type", 
    "_msdyn_aibdatasetfileid_value", 
    "modifiedon", 
    "_createdonbehalfby_value", 
    "_modifiedonbehalfby_value", 
    "statuscode", 
    "_owningbusinessunit_value", 
    "overriddencreatedon", 
    "utcconversiontimezonecode", 
    "_owningteam_value", 
    "msdyn_data", 
    "timezoneruleversionnumber", 
    "importsequencenumber", 
    "_owninguser_value", 
    "versionnumber", 
    "createdon"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_aibfileattacheddata extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata";
    }

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("msdyn_aibfileattacheddataid")
    protected String msdyn_aibfileattacheddataid;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("msdyn_key")
    protected String msdyn_key;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("msdyn_type")
    protected String msdyn_type;

    @JsonProperty("_msdyn_aibdatasetfileid_value")
    protected String _msdyn_aibdatasetfileid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("msdyn_data")
    protected String msdyn_data;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    protected Msdyn_aibfileattacheddata() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_aibfileattacheddata() {
        return new Builder();
    }

    public static final class Builder {
        private Integer statecode;
        private String msdyn_aibfileattacheddataid;
        private String _ownerid_value;
        private String _createdby_value;
        private String msdyn_key;
        private String _modifiedby_value;
        private String msdyn_type;
        private String _msdyn_aibdatasetfileid_value;
        private OffsetDateTime modifiedon;
        private String _createdonbehalfby_value;
        private String _modifiedonbehalfby_value;
        private Integer statuscode;
        private String _owningbusinessunit_value;
        private OffsetDateTime overriddencreatedon;
        private Integer utcconversiontimezonecode;
        private String _owningteam_value;
        private String msdyn_data;
        private Integer timezoneruleversionnumber;
        private Integer importsequencenumber;
        private String _owninguser_value;
        private Long versionnumber;
        private OffsetDateTime createdon;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder msdyn_aibfileattacheddataid(String msdyn_aibfileattacheddataid) {
            this.msdyn_aibfileattacheddataid = msdyn_aibfileattacheddataid;
            this.changedFields = changedFields.add("msdyn_aibfileattacheddataid");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder msdyn_key(String msdyn_key) {
            this.msdyn_key = msdyn_key;
            this.changedFields = changedFields.add("msdyn_key");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder msdyn_type(String msdyn_type) {
            this.msdyn_type = msdyn_type;
            this.changedFields = changedFields.add("msdyn_type");
            return this;
        }

        public Builder _msdyn_aibdatasetfileid_value(String _msdyn_aibdatasetfileid_value) {
            this._msdyn_aibdatasetfileid_value = _msdyn_aibdatasetfileid_value;
            this.changedFields = changedFields.add("_msdyn_aibdatasetfileid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder msdyn_data(String msdyn_data) {
            this.msdyn_data = msdyn_data;
            this.changedFields = changedFields.add("msdyn_data");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Msdyn_aibfileattacheddata build() {
            Msdyn_aibfileattacheddata _x = new Msdyn_aibfileattacheddata();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata";
            _x.statecode = statecode;
            _x.msdyn_aibfileattacheddataid = msdyn_aibfileattacheddataid;
            _x._ownerid_value = _ownerid_value;
            _x._createdby_value = _createdby_value;
            _x.msdyn_key = msdyn_key;
            _x._modifiedby_value = _modifiedby_value;
            _x.msdyn_type = msdyn_type;
            _x._msdyn_aibdatasetfileid_value = _msdyn_aibdatasetfileid_value;
            _x.modifiedon = modifiedon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.statuscode = statuscode;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._owningteam_value = _owningteam_value;
            _x.msdyn_data = msdyn_data;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.importsequencenumber = importsequencenumber;
            _x._owninguser_value = _owninguser_value;
            _x.versionnumber = versionnumber;
            _x.createdon = createdon;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_aibfileattacheddataid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_aibfileattacheddataid.toString()));
        }
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_aibfileattacheddata withStatecode(Integer statecode) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="msdyn_aibfileattacheddataid")
    @JsonIgnore
    public Optional<String> getMsdyn_aibfileattacheddataid() {
        return Optional.ofNullable(msdyn_aibfileattacheddataid);
    }

    public Msdyn_aibfileattacheddata withMsdyn_aibfileattacheddataid(String msdyn_aibfileattacheddataid) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("msdyn_aibfileattacheddataid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x.msdyn_aibfileattacheddataid = msdyn_aibfileattacheddataid;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_aibfileattacheddata with_ownerid_value(String _ownerid_value) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_aibfileattacheddata with_createdby_value(String _createdby_value) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="msdyn_key")
    @JsonIgnore
    public Optional<String> getMsdyn_key() {
        return Optional.ofNullable(msdyn_key);
    }

    public Msdyn_aibfileattacheddata withMsdyn_key(String msdyn_key) {
        Checks.checkIsAscii(msdyn_key);
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("msdyn_key");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x.msdyn_key = msdyn_key;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_aibfileattacheddata with_modifiedby_value(String _modifiedby_value) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="msdyn_type")
    @JsonIgnore
    public Optional<String> getMsdyn_type() {
        return Optional.ofNullable(msdyn_type);
    }

    public Msdyn_aibfileattacheddata withMsdyn_type(String msdyn_type) {
        Checks.checkIsAscii(msdyn_type);
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("msdyn_type");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x.msdyn_type = msdyn_type;
        return _x;
    }

    @Property(name="_msdyn_aibdatasetfileid_value")
    @JsonIgnore
    public Optional<String> get_msdyn_aibdatasetfileid_value() {
        return Optional.ofNullable(_msdyn_aibdatasetfileid_value);
    }

    public Msdyn_aibfileattacheddata with_msdyn_aibdatasetfileid_value(String _msdyn_aibdatasetfileid_value) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_aibdatasetfileid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x._msdyn_aibdatasetfileid_value = _msdyn_aibdatasetfileid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_aibfileattacheddata withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_aibfileattacheddata with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_aibfileattacheddata with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_aibfileattacheddata withStatuscode(Integer statuscode) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_aibfileattacheddata with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_aibfileattacheddata withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_aibfileattacheddata withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_aibfileattacheddata with_owningteam_value(String _owningteam_value) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="msdyn_data")
    @JsonIgnore
    public Optional<String> getMsdyn_data() {
        return Optional.ofNullable(msdyn_data);
    }

    public Msdyn_aibfileattacheddata withMsdyn_data(String msdyn_data) {
        Checks.checkIsAscii(msdyn_data);
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("msdyn_data");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x.msdyn_data = msdyn_data;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_aibfileattacheddata withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_aibfileattacheddata withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_aibfileattacheddata with_owninguser_value(String _owninguser_value) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_aibfileattacheddata withVersionnumber(Long versionnumber) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_aibfileattacheddata withCreatedon(OffsetDateTime createdon) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibfileattacheddata");
        _x.createdon = createdon;
        return _x;
    }

    public Msdyn_aibfileattacheddata withUnmappedField(String name, String value) {
        Msdyn_aibfileattacheddata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_aibfileattacheddata_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_aibfileattacheddata_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_aibfileattacheddata_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_aibfileattacheddata_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_aibfileattacheddata_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_aibfileattacheddata_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_aibfileattacheddata_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_aibfileattacheddata_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_aibfileattacheddata_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_aibfileattacheddata_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_aibfileattacheddata_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_aibfileattacheddata_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_aibfileattacheddata_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_aibfileattacheddata_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_aibfileattacheddata_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_aibfileattacheddata_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_aibfileattacheddata_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_aibfileattacheddata_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_aibfileattacheddata_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_aibfileattacheddata_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_aibfileattacheddata_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_aibfileattacheddata_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_aibfileattacheddata_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_aibfileattacheddata_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_aibfileattacheddata_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_aibfileattacheddata_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_aibfileattacheddata_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_aibfileattacheddata_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_aibfileattacheddata_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_aibfileattacheddata_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_aibfileattacheddata_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_aibfileattacheddata_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_AIBDatasetFileId")
    @JsonIgnore
    public Msdyn_aibdatasetfileRequest getMsdyn_AIBDatasetFileId() {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("msdyn_AIBDatasetFileId"), RequestHelper.getValue(unmappedFields, "msdyn_AIBDatasetFileId"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aibfileattacheddata patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aibfileattacheddata put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aibfileattacheddata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_aibfileattacheddata _copy() {
        Msdyn_aibfileattacheddata _x = new Msdyn_aibfileattacheddata();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.statecode = statecode;
        _x.msdyn_aibfileattacheddataid = msdyn_aibfileattacheddataid;
        _x._ownerid_value = _ownerid_value;
        _x._createdby_value = _createdby_value;
        _x.msdyn_key = msdyn_key;
        _x._modifiedby_value = _modifiedby_value;
        _x.msdyn_type = msdyn_type;
        _x._msdyn_aibdatasetfileid_value = _msdyn_aibdatasetfileid_value;
        _x.modifiedon = modifiedon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.statuscode = statuscode;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._owningteam_value = _owningteam_value;
        _x.msdyn_data = msdyn_data;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.importsequencenumber = importsequencenumber;
        _x._owninguser_value = _owninguser_value;
        _x.versionnumber = versionnumber;
        _x.createdon = createdon;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_aibfileattacheddata[");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("msdyn_aibfileattacheddataid=");
        b.append(this.msdyn_aibfileattacheddataid);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("msdyn_key=");
        b.append(this.msdyn_key);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("msdyn_type=");
        b.append(this.msdyn_type);
        b.append(", ");
        b.append("_msdyn_aibdatasetfileid_value=");
        b.append(this._msdyn_aibdatasetfileid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("msdyn_data=");
        b.append(this.msdyn_data);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
