package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.complex.GetDistinctValuesImportFileResponse;
import microsoft.dynamics.crm.complex.GetHeaderColumnsImportFileResponse;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportdataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportlogCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.ImportRequest;
import microsoft.dynamics.crm.entity.request.ImportmapRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_createdby_value", 
    "_importmapid_value", 
    "partialfailurecount", 
    "usesystemmap", 
    "successcount", 
    "_ownerid_value", 
    "_owningbusinessunit_value", 
    "headerrow", 
    "name", 
    "targetentityname", 
    "importfileid", 
    "_recordsownerid_value", 
    "_owningteam_value", 
    "relatedentitycolumns", 
    "additionalheaderrow", 
    "parsedtablecolumnsnumber", 
    "upsertmodecode", 
    "entitykeyid", 
    "_modifiedonbehalfby_value", 
    "createdon", 
    "failurecount", 
    "_modifiedby_value", 
    "timezoneruleversionnumber", 
    "parsedtablename", 
    "isfirstrowheader", 
    "datadelimitercode", 
    "processcode", 
    "modifiedon", 
    "fielddelimitercode", 
    "content", 
    "progresscounter", 
    "statecode", 
    "_createdonbehalfby_value", 
    "totalcount", 
    "statuscode", 
    "sourceentityname", 
    "parsedtablecolumnprefix", 
    "enableduplicatedetection", 
    "completedon", 
    "processingstatus", 
    "filetypecode", 
    "_importid_value", 
    "_owninguser_value", 
    "utcconversiontimezonecode", 
    "source", 
    "size"})
@JsonInclude(Include.NON_NULL)
public class Importfile extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.importfile";
    }

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_importmapid_value")
    protected String _importmapid_value;

    @JsonProperty("partialfailurecount")
    protected Integer partialfailurecount;

    @JsonProperty("usesystemmap")
    protected Boolean usesystemmap;

    @JsonProperty("successcount")
    protected Integer successcount;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("headerrow")
    protected String headerrow;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("targetentityname")
    protected String targetentityname;

    @JsonProperty("importfileid")
    protected String importfileid;

    @JsonProperty("_recordsownerid_value")
    protected String _recordsownerid_value;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("relatedentitycolumns")
    protected String relatedentitycolumns;

    @JsonProperty("additionalheaderrow")
    protected String additionalheaderrow;

    @JsonProperty("parsedtablecolumnsnumber")
    protected Integer parsedtablecolumnsnumber;

    @JsonProperty("upsertmodecode")
    protected Integer upsertmodecode;

    @JsonProperty("entitykeyid")
    protected String entitykeyid;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("failurecount")
    protected Integer failurecount;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("parsedtablename")
    protected String parsedtablename;

    @JsonProperty("isfirstrowheader")
    protected Boolean isfirstrowheader;

    @JsonProperty("datadelimitercode")
    protected Integer datadelimitercode;

    @JsonProperty("processcode")
    protected Integer processcode;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("fielddelimitercode")
    protected Integer fielddelimitercode;

    @JsonProperty("content")
    protected String content;

    @JsonProperty("progresscounter")
    protected Integer progresscounter;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("totalcount")
    protected Integer totalcount;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("sourceentityname")
    protected String sourceentityname;

    @JsonProperty("parsedtablecolumnprefix")
    protected String parsedtablecolumnprefix;

    @JsonProperty("enableduplicatedetection")
    protected Boolean enableduplicatedetection;

    @JsonProperty("completedon")
    protected OffsetDateTime completedon;

    @JsonProperty("processingstatus")
    protected Integer processingstatus;

    @JsonProperty("filetypecode")
    protected Integer filetypecode;

    @JsonProperty("_importid_value")
    protected String _importid_value;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("source")
    protected String source;

    @JsonProperty("size")
    protected String size;

    protected Importfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderImportfile() {
        return new Builder();
    }

    public static final class Builder {
        private String _createdby_value;
        private String _importmapid_value;
        private Integer partialfailurecount;
        private Boolean usesystemmap;
        private Integer successcount;
        private String _ownerid_value;
        private String _owningbusinessunit_value;
        private String headerrow;
        private String name;
        private String targetentityname;
        private String importfileid;
        private String _recordsownerid_value;
        private String _owningteam_value;
        private String relatedentitycolumns;
        private String additionalheaderrow;
        private Integer parsedtablecolumnsnumber;
        private Integer upsertmodecode;
        private String entitykeyid;
        private String _modifiedonbehalfby_value;
        private OffsetDateTime createdon;
        private Integer failurecount;
        private String _modifiedby_value;
        private Integer timezoneruleversionnumber;
        private String parsedtablename;
        private Boolean isfirstrowheader;
        private Integer datadelimitercode;
        private Integer processcode;
        private OffsetDateTime modifiedon;
        private Integer fielddelimitercode;
        private String content;
        private Integer progresscounter;
        private Integer statecode;
        private String _createdonbehalfby_value;
        private Integer totalcount;
        private Integer statuscode;
        private String sourceentityname;
        private String parsedtablecolumnprefix;
        private Boolean enableduplicatedetection;
        private OffsetDateTime completedon;
        private Integer processingstatus;
        private Integer filetypecode;
        private String _importid_value;
        private String _owninguser_value;
        private Integer utcconversiontimezonecode;
        private String source;
        private String size;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _importmapid_value(String _importmapid_value) {
            this._importmapid_value = _importmapid_value;
            this.changedFields = changedFields.add("_importmapid_value");
            return this;
        }

        public Builder partialfailurecount(Integer partialfailurecount) {
            this.partialfailurecount = partialfailurecount;
            this.changedFields = changedFields.add("partialfailurecount");
            return this;
        }

        public Builder usesystemmap(Boolean usesystemmap) {
            this.usesystemmap = usesystemmap;
            this.changedFields = changedFields.add("usesystemmap");
            return this;
        }

        public Builder successcount(Integer successcount) {
            this.successcount = successcount;
            this.changedFields = changedFields.add("successcount");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder headerrow(String headerrow) {
            this.headerrow = headerrow;
            this.changedFields = changedFields.add("headerrow");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder targetentityname(String targetentityname) {
            this.targetentityname = targetentityname;
            this.changedFields = changedFields.add("targetentityname");
            return this;
        }

        public Builder importfileid(String importfileid) {
            this.importfileid = importfileid;
            this.changedFields = changedFields.add("importfileid");
            return this;
        }

        public Builder _recordsownerid_value(String _recordsownerid_value) {
            this._recordsownerid_value = _recordsownerid_value;
            this.changedFields = changedFields.add("_recordsownerid_value");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder relatedentitycolumns(String relatedentitycolumns) {
            this.relatedentitycolumns = relatedentitycolumns;
            this.changedFields = changedFields.add("relatedentitycolumns");
            return this;
        }

        public Builder additionalheaderrow(String additionalheaderrow) {
            this.additionalheaderrow = additionalheaderrow;
            this.changedFields = changedFields.add("additionalheaderrow");
            return this;
        }

        public Builder parsedtablecolumnsnumber(Integer parsedtablecolumnsnumber) {
            this.parsedtablecolumnsnumber = parsedtablecolumnsnumber;
            this.changedFields = changedFields.add("parsedtablecolumnsnumber");
            return this;
        }

        public Builder upsertmodecode(Integer upsertmodecode) {
            this.upsertmodecode = upsertmodecode;
            this.changedFields = changedFields.add("upsertmodecode");
            return this;
        }

        public Builder entitykeyid(String entitykeyid) {
            this.entitykeyid = entitykeyid;
            this.changedFields = changedFields.add("entitykeyid");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder failurecount(Integer failurecount) {
            this.failurecount = failurecount;
            this.changedFields = changedFields.add("failurecount");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder parsedtablename(String parsedtablename) {
            this.parsedtablename = parsedtablename;
            this.changedFields = changedFields.add("parsedtablename");
            return this;
        }

        public Builder isfirstrowheader(Boolean isfirstrowheader) {
            this.isfirstrowheader = isfirstrowheader;
            this.changedFields = changedFields.add("isfirstrowheader");
            return this;
        }

        public Builder datadelimitercode(Integer datadelimitercode) {
            this.datadelimitercode = datadelimitercode;
            this.changedFields = changedFields.add("datadelimitercode");
            return this;
        }

        public Builder processcode(Integer processcode) {
            this.processcode = processcode;
            this.changedFields = changedFields.add("processcode");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder fielddelimitercode(Integer fielddelimitercode) {
            this.fielddelimitercode = fielddelimitercode;
            this.changedFields = changedFields.add("fielddelimitercode");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder progresscounter(Integer progresscounter) {
            this.progresscounter = progresscounter;
            this.changedFields = changedFields.add("progresscounter");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder totalcount(Integer totalcount) {
            this.totalcount = totalcount;
            this.changedFields = changedFields.add("totalcount");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder sourceentityname(String sourceentityname) {
            this.sourceentityname = sourceentityname;
            this.changedFields = changedFields.add("sourceentityname");
            return this;
        }

        public Builder parsedtablecolumnprefix(String parsedtablecolumnprefix) {
            this.parsedtablecolumnprefix = parsedtablecolumnprefix;
            this.changedFields = changedFields.add("parsedtablecolumnprefix");
            return this;
        }

        public Builder enableduplicatedetection(Boolean enableduplicatedetection) {
            this.enableduplicatedetection = enableduplicatedetection;
            this.changedFields = changedFields.add("enableduplicatedetection");
            return this;
        }

        public Builder completedon(OffsetDateTime completedon) {
            this.completedon = completedon;
            this.changedFields = changedFields.add("completedon");
            return this;
        }

        public Builder processingstatus(Integer processingstatus) {
            this.processingstatus = processingstatus;
            this.changedFields = changedFields.add("processingstatus");
            return this;
        }

        public Builder filetypecode(Integer filetypecode) {
            this.filetypecode = filetypecode;
            this.changedFields = changedFields.add("filetypecode");
            return this;
        }

        public Builder _importid_value(String _importid_value) {
            this._importid_value = _importid_value;
            this.changedFields = changedFields.add("_importid_value");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder size(String size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public Importfile build() {
            Importfile _x = new Importfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.importfile";
            _x._createdby_value = _createdby_value;
            _x._importmapid_value = _importmapid_value;
            _x.partialfailurecount = partialfailurecount;
            _x.usesystemmap = usesystemmap;
            _x.successcount = successcount;
            _x._ownerid_value = _ownerid_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.headerrow = headerrow;
            _x.name = name;
            _x.targetentityname = targetentityname;
            _x.importfileid = importfileid;
            _x._recordsownerid_value = _recordsownerid_value;
            _x._owningteam_value = _owningteam_value;
            _x.relatedentitycolumns = relatedentitycolumns;
            _x.additionalheaderrow = additionalheaderrow;
            _x.parsedtablecolumnsnumber = parsedtablecolumnsnumber;
            _x.upsertmodecode = upsertmodecode;
            _x.entitykeyid = entitykeyid;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.createdon = createdon;
            _x.failurecount = failurecount;
            _x._modifiedby_value = _modifiedby_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.parsedtablename = parsedtablename;
            _x.isfirstrowheader = isfirstrowheader;
            _x.datadelimitercode = datadelimitercode;
            _x.processcode = processcode;
            _x.modifiedon = modifiedon;
            _x.fielddelimitercode = fielddelimitercode;
            _x.content = content;
            _x.progresscounter = progresscounter;
            _x.statecode = statecode;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.totalcount = totalcount;
            _x.statuscode = statuscode;
            _x.sourceentityname = sourceentityname;
            _x.parsedtablecolumnprefix = parsedtablecolumnprefix;
            _x.enableduplicatedetection = enableduplicatedetection;
            _x.completedon = completedon;
            _x.processingstatus = processingstatus;
            _x.filetypecode = filetypecode;
            _x._importid_value = _importid_value;
            _x._owninguser_value = _owninguser_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.source = source;
            _x.size = size;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && importfileid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(importfileid.toString()));
        }
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Importfile with_createdby_value(String _createdby_value) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_importmapid_value")
    @JsonIgnore
    public Optional<String> get_importmapid_value() {
        return Optional.ofNullable(_importmapid_value);
    }

    public Importfile with_importmapid_value(String _importmapid_value) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("_importmapid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x._importmapid_value = _importmapid_value;
        return _x;
    }

    @Property(name="partialfailurecount")
    @JsonIgnore
    public Optional<Integer> getPartialfailurecount() {
        return Optional.ofNullable(partialfailurecount);
    }

    public Importfile withPartialfailurecount(Integer partialfailurecount) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("partialfailurecount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.partialfailurecount = partialfailurecount;
        return _x;
    }

    @Property(name="usesystemmap")
    @JsonIgnore
    public Optional<Boolean> getUsesystemmap() {
        return Optional.ofNullable(usesystemmap);
    }

    public Importfile withUsesystemmap(Boolean usesystemmap) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("usesystemmap");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.usesystemmap = usesystemmap;
        return _x;
    }

    @Property(name="successcount")
    @JsonIgnore
    public Optional<Integer> getSuccesscount() {
        return Optional.ofNullable(successcount);
    }

    public Importfile withSuccesscount(Integer successcount) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("successcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.successcount = successcount;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Importfile with_ownerid_value(String _ownerid_value) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Importfile with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="headerrow")
    @JsonIgnore
    public Optional<String> getHeaderrow() {
        return Optional.ofNullable(headerrow);
    }

    public Importfile withHeaderrow(String headerrow) {
        Checks.checkIsAscii(headerrow);
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("headerrow");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.headerrow = headerrow;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Importfile withName(String name) {
        Checks.checkIsAscii(name);
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.name = name;
        return _x;
    }

    @Property(name="targetentityname")
    @JsonIgnore
    public Optional<String> getTargetentityname() {
        return Optional.ofNullable(targetentityname);
    }

    public Importfile withTargetentityname(String targetentityname) {
        Checks.checkIsAscii(targetentityname);
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("targetentityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.targetentityname = targetentityname;
        return _x;
    }

    @Property(name="importfileid")
    @JsonIgnore
    public Optional<String> getImportfileid() {
        return Optional.ofNullable(importfileid);
    }

    public Importfile withImportfileid(String importfileid) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("importfileid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.importfileid = importfileid;
        return _x;
    }

    @Property(name="_recordsownerid_value")
    @JsonIgnore
    public Optional<String> get_recordsownerid_value() {
        return Optional.ofNullable(_recordsownerid_value);
    }

    public Importfile with_recordsownerid_value(String _recordsownerid_value) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("_recordsownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x._recordsownerid_value = _recordsownerid_value;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Importfile with_owningteam_value(String _owningteam_value) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="relatedentitycolumns")
    @JsonIgnore
    public Optional<String> getRelatedentitycolumns() {
        return Optional.ofNullable(relatedentitycolumns);
    }

    public Importfile withRelatedentitycolumns(String relatedentitycolumns) {
        Checks.checkIsAscii(relatedentitycolumns);
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("relatedentitycolumns");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.relatedentitycolumns = relatedentitycolumns;
        return _x;
    }

    @Property(name="additionalheaderrow")
    @JsonIgnore
    public Optional<String> getAdditionalheaderrow() {
        return Optional.ofNullable(additionalheaderrow);
    }

    public Importfile withAdditionalheaderrow(String additionalheaderrow) {
        Checks.checkIsAscii(additionalheaderrow);
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("additionalheaderrow");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.additionalheaderrow = additionalheaderrow;
        return _x;
    }

    @Property(name="parsedtablecolumnsnumber")
    @JsonIgnore
    public Optional<Integer> getParsedtablecolumnsnumber() {
        return Optional.ofNullable(parsedtablecolumnsnumber);
    }

    public Importfile withParsedtablecolumnsnumber(Integer parsedtablecolumnsnumber) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("parsedtablecolumnsnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.parsedtablecolumnsnumber = parsedtablecolumnsnumber;
        return _x;
    }

    @Property(name="upsertmodecode")
    @JsonIgnore
    public Optional<Integer> getUpsertmodecode() {
        return Optional.ofNullable(upsertmodecode);
    }

    public Importfile withUpsertmodecode(Integer upsertmodecode) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("upsertmodecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.upsertmodecode = upsertmodecode;
        return _x;
    }

    @Property(name="entitykeyid")
    @JsonIgnore
    public Optional<String> getEntitykeyid() {
        return Optional.ofNullable(entitykeyid);
    }

    public Importfile withEntitykeyid(String entitykeyid) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("entitykeyid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.entitykeyid = entitykeyid;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Importfile with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Importfile withCreatedon(OffsetDateTime createdon) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="failurecount")
    @JsonIgnore
    public Optional<Integer> getFailurecount() {
        return Optional.ofNullable(failurecount);
    }

    public Importfile withFailurecount(Integer failurecount) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("failurecount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.failurecount = failurecount;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Importfile with_modifiedby_value(String _modifiedby_value) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Importfile withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="parsedtablename")
    @JsonIgnore
    public Optional<String> getParsedtablename() {
        return Optional.ofNullable(parsedtablename);
    }

    public Importfile withParsedtablename(String parsedtablename) {
        Checks.checkIsAscii(parsedtablename);
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("parsedtablename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.parsedtablename = parsedtablename;
        return _x;
    }

    @Property(name="isfirstrowheader")
    @JsonIgnore
    public Optional<Boolean> getIsfirstrowheader() {
        return Optional.ofNullable(isfirstrowheader);
    }

    public Importfile withIsfirstrowheader(Boolean isfirstrowheader) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("isfirstrowheader");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.isfirstrowheader = isfirstrowheader;
        return _x;
    }

    @Property(name="datadelimitercode")
    @JsonIgnore
    public Optional<Integer> getDatadelimitercode() {
        return Optional.ofNullable(datadelimitercode);
    }

    public Importfile withDatadelimitercode(Integer datadelimitercode) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("datadelimitercode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.datadelimitercode = datadelimitercode;
        return _x;
    }

    @Property(name="processcode")
    @JsonIgnore
    public Optional<Integer> getProcesscode() {
        return Optional.ofNullable(processcode);
    }

    public Importfile withProcesscode(Integer processcode) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("processcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.processcode = processcode;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Importfile withModifiedon(OffsetDateTime modifiedon) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="fielddelimitercode")
    @JsonIgnore
    public Optional<Integer> getFielddelimitercode() {
        return Optional.ofNullable(fielddelimitercode);
    }

    public Importfile withFielddelimitercode(Integer fielddelimitercode) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("fielddelimitercode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.fielddelimitercode = fielddelimitercode;
        return _x;
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<String> getContent() {
        return Optional.ofNullable(content);
    }

    public Importfile withContent(String content) {
        Checks.checkIsAscii(content);
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.content = content;
        return _x;
    }

    @Property(name="progresscounter")
    @JsonIgnore
    public Optional<Integer> getProgresscounter() {
        return Optional.ofNullable(progresscounter);
    }

    public Importfile withProgresscounter(Integer progresscounter) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("progresscounter");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.progresscounter = progresscounter;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Importfile withStatecode(Integer statecode) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Importfile with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="totalcount")
    @JsonIgnore
    public Optional<Integer> getTotalcount() {
        return Optional.ofNullable(totalcount);
    }

    public Importfile withTotalcount(Integer totalcount) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("totalcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.totalcount = totalcount;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Importfile withStatuscode(Integer statuscode) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="sourceentityname")
    @JsonIgnore
    public Optional<String> getSourceentityname() {
        return Optional.ofNullable(sourceentityname);
    }

    public Importfile withSourceentityname(String sourceentityname) {
        Checks.checkIsAscii(sourceentityname);
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("sourceentityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.sourceentityname = sourceentityname;
        return _x;
    }

    @Property(name="parsedtablecolumnprefix")
    @JsonIgnore
    public Optional<String> getParsedtablecolumnprefix() {
        return Optional.ofNullable(parsedtablecolumnprefix);
    }

    public Importfile withParsedtablecolumnprefix(String parsedtablecolumnprefix) {
        Checks.checkIsAscii(parsedtablecolumnprefix);
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("parsedtablecolumnprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.parsedtablecolumnprefix = parsedtablecolumnprefix;
        return _x;
    }

    @Property(name="enableduplicatedetection")
    @JsonIgnore
    public Optional<Boolean> getEnableduplicatedetection() {
        return Optional.ofNullable(enableduplicatedetection);
    }

    public Importfile withEnableduplicatedetection(Boolean enableduplicatedetection) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("enableduplicatedetection");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.enableduplicatedetection = enableduplicatedetection;
        return _x;
    }

    @Property(name="completedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedon() {
        return Optional.ofNullable(completedon);
    }

    public Importfile withCompletedon(OffsetDateTime completedon) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("completedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.completedon = completedon;
        return _x;
    }

    @Property(name="processingstatus")
    @JsonIgnore
    public Optional<Integer> getProcessingstatus() {
        return Optional.ofNullable(processingstatus);
    }

    public Importfile withProcessingstatus(Integer processingstatus) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("processingstatus");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.processingstatus = processingstatus;
        return _x;
    }

    @Property(name="filetypecode")
    @JsonIgnore
    public Optional<Integer> getFiletypecode() {
        return Optional.ofNullable(filetypecode);
    }

    public Importfile withFiletypecode(Integer filetypecode) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("filetypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.filetypecode = filetypecode;
        return _x;
    }

    @Property(name="_importid_value")
    @JsonIgnore
    public Optional<String> get_importid_value() {
        return Optional.ofNullable(_importid_value);
    }

    public Importfile with_importid_value(String _importid_value) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("_importid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x._importid_value = _importid_value;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Importfile with_owninguser_value(String _owninguser_value) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Importfile withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<String> getSource() {
        return Optional.ofNullable(source);
    }

    public Importfile withSource(String source) {
        Checks.checkIsAscii(source);
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("source");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.source = source;
        return _x;
    }

    @Property(name="size")
    @JsonIgnore
    public Optional<String> getSize() {
        return Optional.ofNullable(size);
    }

    public Importfile withSize(String size) {
        Checks.checkIsAscii(size);
        Importfile _x = _copy();
        _x.changedFields = changedFields.add("size");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importfile");
        _x.size = size;
        return _x;
    }

    public Importfile withUnmappedField(String name, String value) {
        Importfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="ImportFile_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getImportFile_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("ImportFile_AsyncOperations"), RequestHelper.getValue(unmappedFields, "ImportFile_AsyncOperations"));
    }

    @NavigationProperty(name="ImportFile_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getImportFile_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("ImportFile_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "ImportFile_BulkDeleteFailures"));
    }

    @NavigationProperty(name="recordsownerid_team")
    @JsonIgnore
    public TeamRequest getRecordsownerid_team() {
        return new TeamRequest(contextPath.addSegment("recordsownerid_team"), RequestHelper.getValue(unmappedFields, "recordsownerid_team"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ImportFile_ImportData")
    @JsonIgnore
    public ImportdataCollectionRequest getImportFile_ImportData() {
        return new ImportdataCollectionRequest(
                        contextPath.addSegment("ImportFile_ImportData"), RequestHelper.getValue(unmappedFields, "ImportFile_ImportData"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="importid")
    @JsonIgnore
    public ImportRequest getImportid() {
        return new ImportRequest(contextPath.addSegment("importid"), RequestHelper.getValue(unmappedFields, "importid"));
    }

    @NavigationProperty(name="recordsownerid_systemuser")
    @JsonIgnore
    public SystemuserRequest getRecordsownerid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("recordsownerid_systemuser"), RequestHelper.getValue(unmappedFields, "recordsownerid_systemuser"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="ImportLog_ImportFile")
    @JsonIgnore
    public ImportlogCollectionRequest getImportLog_ImportFile() {
        return new ImportlogCollectionRequest(
                        contextPath.addSegment("ImportLog_ImportFile"), RequestHelper.getValue(unmappedFields, "ImportLog_ImportFile"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="importmapid")
    @JsonIgnore
    public ImportmapRequest getImportmapid() {
        return new ImportmapRequest(contextPath.addSegment("importmapid"), RequestHelper.getValue(unmappedFields, "importmapid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Importfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Importfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Importfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Importfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Importfile _copy() {
        Importfile _x = new Importfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._createdby_value = _createdby_value;
        _x._importmapid_value = _importmapid_value;
        _x.partialfailurecount = partialfailurecount;
        _x.usesystemmap = usesystemmap;
        _x.successcount = successcount;
        _x._ownerid_value = _ownerid_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.headerrow = headerrow;
        _x.name = name;
        _x.targetentityname = targetentityname;
        _x.importfileid = importfileid;
        _x._recordsownerid_value = _recordsownerid_value;
        _x._owningteam_value = _owningteam_value;
        _x.relatedentitycolumns = relatedentitycolumns;
        _x.additionalheaderrow = additionalheaderrow;
        _x.parsedtablecolumnsnumber = parsedtablecolumnsnumber;
        _x.upsertmodecode = upsertmodecode;
        _x.entitykeyid = entitykeyid;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.createdon = createdon;
        _x.failurecount = failurecount;
        _x._modifiedby_value = _modifiedby_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.parsedtablename = parsedtablename;
        _x.isfirstrowheader = isfirstrowheader;
        _x.datadelimitercode = datadelimitercode;
        _x.processcode = processcode;
        _x.modifiedon = modifiedon;
        _x.fielddelimitercode = fielddelimitercode;
        _x.content = content;
        _x.progresscounter = progresscounter;
        _x.statecode = statecode;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.totalcount = totalcount;
        _x.statuscode = statuscode;
        _x.sourceentityname = sourceentityname;
        _x.parsedtablecolumnprefix = parsedtablecolumnprefix;
        _x.enableduplicatedetection = enableduplicatedetection;
        _x.completedon = completedon;
        _x.processingstatus = processingstatus;
        _x.filetypecode = filetypecode;
        _x._importid_value = _importid_value;
        _x._owninguser_value = _owninguser_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.source = source;
        _x.size = size;
        return _x;
    }

    @Function(name = "GetDistinctValuesImportFile")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GetDistinctValuesImportFileResponse> getDistinctValuesImportFile(Integer columnNumber, Integer pageNumber, Integer recordsPerPage) {
        Preconditions.checkNotNull(columnNumber, "columnNumber cannot be null");
        Preconditions.checkNotNull(pageNumber, "pageNumber cannot be null");
        Preconditions.checkNotNull(recordsPerPage, "recordsPerPage cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("columnNumber", "Edm.Int32", columnNumber)
            .put("pageNumber", "Edm.Int32", pageNumber)
            .put("recordsPerPage", "Edm.Int32", recordsPerPage)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<GetDistinctValuesImportFileResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetDistinctValuesImportFile"), GetDistinctValuesImportFileResponse.class, _parameters);
    }

    @Function(name = "GetHeaderColumnsImportFile")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GetHeaderColumnsImportFileResponse> getHeaderColumnsImportFile() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<GetHeaderColumnsImportFileResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetHeaderColumnsImportFile"), GetHeaderColumnsImportFileResponse.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Importfile[");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_importmapid_value=");
        b.append(this._importmapid_value);
        b.append(", ");
        b.append("partialfailurecount=");
        b.append(this.partialfailurecount);
        b.append(", ");
        b.append("usesystemmap=");
        b.append(this.usesystemmap);
        b.append(", ");
        b.append("successcount=");
        b.append(this.successcount);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("headerrow=");
        b.append(this.headerrow);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("targetentityname=");
        b.append(this.targetentityname);
        b.append(", ");
        b.append("importfileid=");
        b.append(this.importfileid);
        b.append(", ");
        b.append("_recordsownerid_value=");
        b.append(this._recordsownerid_value);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("relatedentitycolumns=");
        b.append(this.relatedentitycolumns);
        b.append(", ");
        b.append("additionalheaderrow=");
        b.append(this.additionalheaderrow);
        b.append(", ");
        b.append("parsedtablecolumnsnumber=");
        b.append(this.parsedtablecolumnsnumber);
        b.append(", ");
        b.append("upsertmodecode=");
        b.append(this.upsertmodecode);
        b.append(", ");
        b.append("entitykeyid=");
        b.append(this.entitykeyid);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("failurecount=");
        b.append(this.failurecount);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("parsedtablename=");
        b.append(this.parsedtablename);
        b.append(", ");
        b.append("isfirstrowheader=");
        b.append(this.isfirstrowheader);
        b.append(", ");
        b.append("datadelimitercode=");
        b.append(this.datadelimitercode);
        b.append(", ");
        b.append("processcode=");
        b.append(this.processcode);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("fielddelimitercode=");
        b.append(this.fielddelimitercode);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("progresscounter=");
        b.append(this.progresscounter);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("totalcount=");
        b.append(this.totalcount);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("sourceentityname=");
        b.append(this.sourceentityname);
        b.append(", ");
        b.append("parsedtablecolumnprefix=");
        b.append(this.parsedtablecolumnprefix);
        b.append(", ");
        b.append("enableduplicatedetection=");
        b.append(this.enableduplicatedetection);
        b.append(", ");
        b.append("completedon=");
        b.append(this.completedon);
        b.append(", ");
        b.append("processingstatus=");
        b.append(this.processingstatus);
        b.append(", ");
        b.append("filetypecode=");
        b.append(this.filetypecode);
        b.append(", ");
        b.append("_importid_value=");
        b.append(this._importid_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
