package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.DatalakeworkspaceRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "tenantid", 
    "_createdby_value", 
    "canread", 
    "modifiedon", 
    "timezoneruleversionnumber", 
    "datalakeworkspacepermission_uniquename", 
    "overwritetime", 
    "_createdonbehalfby_value", 
    "statuscode", 
    "solutionid", 
    "whitelistedappid", 
    "componentidunique", 
    "canwrite", 
    "datalakeworkspacepermissionid", 
    "overriddencreatedon", 
    "_workspaceid_value", 
    "importsequencenumber", 
    "ismanaged", 
    "_modifiedonbehalfby_value", 
    "statecode", 
    "name", 
    "componentstate", 
    "utcconversiontimezonecode", 
    "_organizationid_value", 
    "canexecute", 
    "versionnumber", 
    "iscustomizable", 
    "_modifiedby_value", 
    "createdon", 
    "appid"})
@JsonInclude(Include.NON_NULL)
public class Datalakeworkspacepermission extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.datalakeworkspacepermission";
    }

    @JsonProperty("tenantid")
    protected String tenantid;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("canread")
    protected Boolean canread;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("datalakeworkspacepermission_uniquename")
    protected String datalakeworkspacepermission_uniquename;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("whitelistedappid")
    protected String whitelistedappid;

    @JsonProperty("componentidunique")
    protected String componentidunique;

    @JsonProperty("canwrite")
    protected Boolean canwrite;

    @JsonProperty("datalakeworkspacepermissionid")
    protected String datalakeworkspacepermissionid;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_workspaceid_value")
    protected String _workspaceid_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("canexecute")
    protected Boolean canexecute;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("appid")
    protected String appid;

    protected Datalakeworkspacepermission() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDatalakeworkspacepermission() {
        return new Builder();
    }

    public static final class Builder {
        private String tenantid;
        private String _createdby_value;
        private Boolean canread;
        private OffsetDateTime modifiedon;
        private Integer timezoneruleversionnumber;
        private String datalakeworkspacepermission_uniquename;
        private OffsetDateTime overwritetime;
        private String _createdonbehalfby_value;
        private Integer statuscode;
        private String solutionid;
        private String whitelistedappid;
        private String componentidunique;
        private Boolean canwrite;
        private String datalakeworkspacepermissionid;
        private OffsetDateTime overriddencreatedon;
        private String _workspaceid_value;
        private Integer importsequencenumber;
        private Boolean ismanaged;
        private String _modifiedonbehalfby_value;
        private Integer statecode;
        private String name;
        private Integer componentstate;
        private Integer utcconversiontimezonecode;
        private String _organizationid_value;
        private Boolean canexecute;
        private Long versionnumber;
        private BooleanManagedProperty iscustomizable;
        private String _modifiedby_value;
        private OffsetDateTime createdon;
        private String appid;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder tenantid(String tenantid) {
            this.tenantid = tenantid;
            this.changedFields = changedFields.add("tenantid");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder canread(Boolean canread) {
            this.canread = canread;
            this.changedFields = changedFields.add("canread");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder datalakeworkspacepermission_uniquename(String datalakeworkspacepermission_uniquename) {
            this.datalakeworkspacepermission_uniquename = datalakeworkspacepermission_uniquename;
            this.changedFields = changedFields.add("datalakeworkspacepermission_uniquename");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder whitelistedappid(String whitelistedappid) {
            this.whitelistedappid = whitelistedappid;
            this.changedFields = changedFields.add("whitelistedappid");
            return this;
        }

        public Builder componentidunique(String componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder canwrite(Boolean canwrite) {
            this.canwrite = canwrite;
            this.changedFields = changedFields.add("canwrite");
            return this;
        }

        public Builder datalakeworkspacepermissionid(String datalakeworkspacepermissionid) {
            this.datalakeworkspacepermissionid = datalakeworkspacepermissionid;
            this.changedFields = changedFields.add("datalakeworkspacepermissionid");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _workspaceid_value(String _workspaceid_value) {
            this._workspaceid_value = _workspaceid_value;
            this.changedFields = changedFields.add("_workspaceid_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder canexecute(Boolean canexecute) {
            this.canexecute = canexecute;
            this.changedFields = changedFields.add("canexecute");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder appid(String appid) {
            this.appid = appid;
            this.changedFields = changedFields.add("appid");
            return this;
        }

        public Datalakeworkspacepermission build() {
            Datalakeworkspacepermission _x = new Datalakeworkspacepermission();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.datalakeworkspacepermission";
            _x.tenantid = tenantid;
            _x._createdby_value = _createdby_value;
            _x.canread = canread;
            _x.modifiedon = modifiedon;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.datalakeworkspacepermission_uniquename = datalakeworkspacepermission_uniquename;
            _x.overwritetime = overwritetime;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.statuscode = statuscode;
            _x.solutionid = solutionid;
            _x.whitelistedappid = whitelistedappid;
            _x.componentidunique = componentidunique;
            _x.canwrite = canwrite;
            _x.datalakeworkspacepermissionid = datalakeworkspacepermissionid;
            _x.overriddencreatedon = overriddencreatedon;
            _x._workspaceid_value = _workspaceid_value;
            _x.importsequencenumber = importsequencenumber;
            _x.ismanaged = ismanaged;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.statecode = statecode;
            _x.name = name;
            _x.componentstate = componentstate;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._organizationid_value = _organizationid_value;
            _x.canexecute = canexecute;
            _x.versionnumber = versionnumber;
            _x.iscustomizable = iscustomizable;
            _x._modifiedby_value = _modifiedby_value;
            _x.createdon = createdon;
            _x.appid = appid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && datalakeworkspacepermissionid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(datalakeworkspacepermissionid.toString()));
        }
    }

    @Property(name="tenantid")
    @JsonIgnore
    public Optional<String> getTenantid() {
        return Optional.ofNullable(tenantid);
    }

    public Datalakeworkspacepermission withTenantid(String tenantid) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("tenantid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.tenantid = tenantid;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Datalakeworkspacepermission with_createdby_value(String _createdby_value) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="canread")
    @JsonIgnore
    public Optional<Boolean> getCanread() {
        return Optional.ofNullable(canread);
    }

    public Datalakeworkspacepermission withCanread(Boolean canread) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("canread");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.canread = canread;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Datalakeworkspacepermission withModifiedon(OffsetDateTime modifiedon) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Datalakeworkspacepermission withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="datalakeworkspacepermission_uniquename")
    @JsonIgnore
    public Optional<String> getDatalakeworkspacepermission_uniquename() {
        return Optional.ofNullable(datalakeworkspacepermission_uniquename);
    }

    public Datalakeworkspacepermission withDatalakeworkspacepermission_uniquename(String datalakeworkspacepermission_uniquename) {
        Checks.checkIsAscii(datalakeworkspacepermission_uniquename);
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("datalakeworkspacepermission_uniquename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.datalakeworkspacepermission_uniquename = datalakeworkspacepermission_uniquename;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Datalakeworkspacepermission withOverwritetime(OffsetDateTime overwritetime) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Datalakeworkspacepermission with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Datalakeworkspacepermission withStatuscode(Integer statuscode) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Datalakeworkspacepermission withSolutionid(String solutionid) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="whitelistedappid")
    @JsonIgnore
    public Optional<String> getWhitelistedappid() {
        return Optional.ofNullable(whitelistedappid);
    }

    public Datalakeworkspacepermission withWhitelistedappid(String whitelistedappid) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("whitelistedappid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.whitelistedappid = whitelistedappid;
        return _x;
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<String> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Datalakeworkspacepermission withComponentidunique(String componentidunique) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="canwrite")
    @JsonIgnore
    public Optional<Boolean> getCanwrite() {
        return Optional.ofNullable(canwrite);
    }

    public Datalakeworkspacepermission withCanwrite(Boolean canwrite) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("canwrite");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.canwrite = canwrite;
        return _x;
    }

    @Property(name="datalakeworkspacepermissionid")
    @JsonIgnore
    public Optional<String> getDatalakeworkspacepermissionid() {
        return Optional.ofNullable(datalakeworkspacepermissionid);
    }

    public Datalakeworkspacepermission withDatalakeworkspacepermissionid(String datalakeworkspacepermissionid) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("datalakeworkspacepermissionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.datalakeworkspacepermissionid = datalakeworkspacepermissionid;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Datalakeworkspacepermission withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_workspaceid_value")
    @JsonIgnore
    public Optional<String> get_workspaceid_value() {
        return Optional.ofNullable(_workspaceid_value);
    }

    public Datalakeworkspacepermission with_workspaceid_value(String _workspaceid_value) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("_workspaceid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x._workspaceid_value = _workspaceid_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Datalakeworkspacepermission withImportsequencenumber(Integer importsequencenumber) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Datalakeworkspacepermission withIsmanaged(Boolean ismanaged) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Datalakeworkspacepermission with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Datalakeworkspacepermission withStatecode(Integer statecode) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Datalakeworkspacepermission withName(String name) {
        Checks.checkIsAscii(name);
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.name = name;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Datalakeworkspacepermission withComponentstate(Integer componentstate) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Datalakeworkspacepermission withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Datalakeworkspacepermission with_organizationid_value(String _organizationid_value) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="canexecute")
    @JsonIgnore
    public Optional<Boolean> getCanexecute() {
        return Optional.ofNullable(canexecute);
    }

    public Datalakeworkspacepermission withCanexecute(Boolean canexecute) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("canexecute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.canexecute = canexecute;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Datalakeworkspacepermission withVersionnumber(Long versionnumber) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Datalakeworkspacepermission withIscustomizable(BooleanManagedProperty iscustomizable) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Datalakeworkspacepermission with_modifiedby_value(String _modifiedby_value) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Datalakeworkspacepermission withCreatedon(OffsetDateTime createdon) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="appid")
    @JsonIgnore
    public Optional<String> getAppid() {
        return Optional.ofNullable(appid);
    }

    public Datalakeworkspacepermission withAppid(String appid) {
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = changedFields.add("appid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspacepermission");
        _x.appid = appid;
        return _x;
    }

    public Datalakeworkspacepermission withUnmappedField(String name, String value) {
        Datalakeworkspacepermission _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="datalakeworkspacepermission_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getDatalakeworkspacepermission_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_SyncErrors"), RequestHelper.getValue(unmappedFields, "datalakeworkspacepermission_SyncErrors"));
    }

    @NavigationProperty(name="datalakeworkspacepermission_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getDatalakeworkspacepermission_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "datalakeworkspacepermission_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="datalakeworkspacepermission_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getDatalakeworkspacepermission_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "datalakeworkspacepermission_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="datalakeworkspacepermission_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getDatalakeworkspacepermission_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_AsyncOperations"), RequestHelper.getValue(unmappedFields, "datalakeworkspacepermission_AsyncOperations"));
    }

    @NavigationProperty(name="datalakeworkspacepermission_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getDatalakeworkspacepermission_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "datalakeworkspacepermission_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="datalakeworkspacepermission_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getDatalakeworkspacepermission_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_ProcessSession"), RequestHelper.getValue(unmappedFields, "datalakeworkspacepermission_ProcessSession"));
    }

    @NavigationProperty(name="datalakeworkspacepermission_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getDatalakeworkspacepermission_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "datalakeworkspacepermission_BulkDeleteFailures"));
    }

    @NavigationProperty(name="datalakeworkspacepermission_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getDatalakeworkspacepermission_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "datalakeworkspacepermission_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="workspaceid")
    @JsonIgnore
    public DatalakeworkspaceRequest getWorkspaceid() {
        return new DatalakeworkspaceRequest(contextPath.addSegment("workspaceid"), RequestHelper.getValue(unmappedFields, "workspaceid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Datalakeworkspacepermission patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Datalakeworkspacepermission put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Datalakeworkspacepermission _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Datalakeworkspacepermission _copy() {
        Datalakeworkspacepermission _x = new Datalakeworkspacepermission();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.tenantid = tenantid;
        _x._createdby_value = _createdby_value;
        _x.canread = canread;
        _x.modifiedon = modifiedon;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.datalakeworkspacepermission_uniquename = datalakeworkspacepermission_uniquename;
        _x.overwritetime = overwritetime;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.statuscode = statuscode;
        _x.solutionid = solutionid;
        _x.whitelistedappid = whitelistedappid;
        _x.componentidunique = componentidunique;
        _x.canwrite = canwrite;
        _x.datalakeworkspacepermissionid = datalakeworkspacepermissionid;
        _x.overriddencreatedon = overriddencreatedon;
        _x._workspaceid_value = _workspaceid_value;
        _x.importsequencenumber = importsequencenumber;
        _x.ismanaged = ismanaged;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.statecode = statecode;
        _x.name = name;
        _x.componentstate = componentstate;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._organizationid_value = _organizationid_value;
        _x.canexecute = canexecute;
        _x.versionnumber = versionnumber;
        _x.iscustomizable = iscustomizable;
        _x._modifiedby_value = _modifiedby_value;
        _x.createdon = createdon;
        _x.appid = appid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Datalakeworkspacepermission[");
        b.append("tenantid=");
        b.append(this.tenantid);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("canread=");
        b.append(this.canread);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("datalakeworkspacepermission_uniquename=");
        b.append(this.datalakeworkspacepermission_uniquename);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("whitelistedappid=");
        b.append(this.whitelistedappid);
        b.append(", ");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("canwrite=");
        b.append(this.canwrite);
        b.append(", ");
        b.append("datalakeworkspacepermissionid=");
        b.append(this.datalakeworkspacepermissionid);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_workspaceid_value=");
        b.append(this._workspaceid_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("canexecute=");
        b.append(this.canexecute);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("appid=");
        b.append(this.appid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
