package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Messages"})
@JsonInclude(Include.NON_NULL)
public class ValidateFetchXmlExpressionResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Messages")
    protected List<ValidatorIssue> messages;

    @JsonProperty("Messages@nextLink")
    protected String messagesNextLink;

    protected ValidateFetchXmlExpressionResult() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ValidateFetchXmlExpressionResult";
    }

    @Property(name="Messages")
    @JsonIgnore
    public CollectionPage<ValidatorIssue> getMessages() {
        return new CollectionPage<ValidatorIssue>(contextPath, ValidatorIssue.class, this.messages, Optional.ofNullable(messagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Messages")
    @JsonIgnore
    public CollectionPage<ValidatorIssue> getMessages(HttpRequestOptions options) {
        return new CollectionPage<ValidatorIssue>(contextPath, ValidatorIssue.class, this.messages, Optional.ofNullable(messagesNextLink), Collections.emptyList(), options);
    }

    public ValidateFetchXmlExpressionResult withUnmappedField(String name, String value) {
        ValidateFetchXmlExpressionResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ValidatorIssue> messages;
        private String messagesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder messages(List<ValidatorIssue> messages) {
            this.messages = messages;
            this.changedFields = changedFields.add("Messages");
            return this;
        }

        public Builder messages(ValidatorIssue... messages) {
            return messages(Arrays.asList(messages));
        }

        public Builder messagesNextLink(String messagesNextLink) {
            this.messagesNextLink = messagesNextLink;
            this.changedFields = changedFields.add("Messages");
            return this;
        }

        public ValidateFetchXmlExpressionResult build() {
            ValidateFetchXmlExpressionResult _x = new ValidateFetchXmlExpressionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ValidateFetchXmlExpressionResult";
            _x.messages = messages;
            _x.messagesNextLink = messagesNextLink;
            return _x;
        }
    }

    private ValidateFetchXmlExpressionResult _copy() {
        ValidateFetchXmlExpressionResult _x = new ValidateFetchXmlExpressionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.messages = messages;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ValidateFetchXmlExpressionResult[");
        b.append("Messages=");
        b.append(this.messages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
