package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "RolePrivileges"})
@JsonInclude(Include.NON_NULL)
public class RetrieveUsersPrivilegesThroughTeamsResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("RolePrivileges")
    protected List<RolePrivilege> rolePrivileges;

    @JsonProperty("RolePrivileges@nextLink")
    protected String rolePrivilegesNextLink;

    protected RetrieveUsersPrivilegesThroughTeamsResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrieveUsersPrivilegesThroughTeamsResponse";
    }

    @Property(name="RolePrivileges")
    @JsonIgnore
    public CollectionPage<RolePrivilege> getRolePrivileges() {
        return new CollectionPage<RolePrivilege>(contextPath, RolePrivilege.class, this.rolePrivileges, Optional.ofNullable(rolePrivilegesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="RolePrivileges")
    @JsonIgnore
    public CollectionPage<RolePrivilege> getRolePrivileges(HttpRequestOptions options) {
        return new CollectionPage<RolePrivilege>(contextPath, RolePrivilege.class, this.rolePrivileges, Optional.ofNullable(rolePrivilegesNextLink), Collections.emptyList(), options);
    }

    public RetrieveUsersPrivilegesThroughTeamsResponse withUnmappedField(String name, String value) {
        RetrieveUsersPrivilegesThroughTeamsResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<RolePrivilege> rolePrivileges;
        private String rolePrivilegesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder rolePrivileges(List<RolePrivilege> rolePrivileges) {
            this.rolePrivileges = rolePrivileges;
            this.changedFields = changedFields.add("RolePrivileges");
            return this;
        }

        public Builder rolePrivileges(RolePrivilege... rolePrivileges) {
            return rolePrivileges(Arrays.asList(rolePrivileges));
        }

        public Builder rolePrivilegesNextLink(String rolePrivilegesNextLink) {
            this.rolePrivilegesNextLink = rolePrivilegesNextLink;
            this.changedFields = changedFields.add("RolePrivileges");
            return this;
        }

        public RetrieveUsersPrivilegesThroughTeamsResponse build() {
            RetrieveUsersPrivilegesThroughTeamsResponse _x = new RetrieveUsersPrivilegesThroughTeamsResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrieveUsersPrivilegesThroughTeamsResponse";
            _x.rolePrivileges = rolePrivileges;
            _x.rolePrivilegesNextLink = rolePrivilegesNextLink;
            return _x;
        }
    }

    private RetrieveUsersPrivilegesThroughTeamsResponse _copy() {
        RetrieveUsersPrivilegesThroughTeamsResponse _x = new RetrieveUsersPrivilegesThroughTeamsResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.rolePrivileges = rolePrivileges;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrieveUsersPrivilegesThroughTeamsResponse[");
        b.append("RolePrivileges=");
        b.append(this.rolePrivileges);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
