package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "AttributePrivileges"})
@JsonInclude(Include.NON_NULL)
public class RetrievePrincipalAttributePrivilegesResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AttributePrivileges")
    protected List<AttributePrivilege> attributePrivileges;

    @JsonProperty("AttributePrivileges@nextLink")
    protected String attributePrivilegesNextLink;

    protected RetrievePrincipalAttributePrivilegesResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrievePrincipalAttributePrivilegesResponse";
    }

    @Property(name="AttributePrivileges")
    @JsonIgnore
    public CollectionPage<AttributePrivilege> getAttributePrivileges() {
        return new CollectionPage<AttributePrivilege>(contextPath, AttributePrivilege.class, this.attributePrivileges, Optional.ofNullable(attributePrivilegesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="AttributePrivileges")
    @JsonIgnore
    public CollectionPage<AttributePrivilege> getAttributePrivileges(HttpRequestOptions options) {
        return new CollectionPage<AttributePrivilege>(contextPath, AttributePrivilege.class, this.attributePrivileges, Optional.ofNullable(attributePrivilegesNextLink), Collections.emptyList(), options);
    }

    public RetrievePrincipalAttributePrivilegesResponse withUnmappedField(String name, String value) {
        RetrievePrincipalAttributePrivilegesResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AttributePrivilege> attributePrivileges;
        private String attributePrivilegesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder attributePrivileges(List<AttributePrivilege> attributePrivileges) {
            this.attributePrivileges = attributePrivileges;
            this.changedFields = changedFields.add("AttributePrivileges");
            return this;
        }

        public Builder attributePrivileges(AttributePrivilege... attributePrivileges) {
            return attributePrivileges(Arrays.asList(attributePrivileges));
        }

        public Builder attributePrivilegesNextLink(String attributePrivilegesNextLink) {
            this.attributePrivilegesNextLink = attributePrivilegesNextLink;
            this.changedFields = changedFields.add("AttributePrivileges");
            return this;
        }

        public RetrievePrincipalAttributePrivilegesResponse build() {
            RetrievePrincipalAttributePrivilegesResponse _x = new RetrievePrincipalAttributePrivilegesResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrievePrincipalAttributePrivilegesResponse";
            _x.attributePrivileges = attributePrivileges;
            _x.attributePrivilegesNextLink = attributePrivilegesNextLink;
            return _x;
        }
    }

    private RetrievePrincipalAttributePrivilegesResponse _copy() {
        RetrievePrincipalAttributePrivilegesResponse _x = new RetrievePrincipalAttributePrivilegesResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.attributePrivileges = attributePrivileges;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrievePrincipalAttributePrivilegesResponse[");
        b.append("AttributePrivileges=");
        b.append(this.attributePrivileges);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
