package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "AllowMainFormDialogForCreate", 
    "AllowMainFormDialogForEdit"})
@JsonInclude(Include.NON_NULL)
public class EntityClientSetting implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AllowMainFormDialogForCreate")
    protected Boolean allowMainFormDialogForCreate;

    @JsonProperty("AllowMainFormDialogForEdit")
    protected Boolean allowMainFormDialogForEdit;

    protected EntityClientSetting() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.EntityClientSetting";
    }

    @Property(name="AllowMainFormDialogForCreate")
    @JsonIgnore
    public Optional<Boolean> getAllowMainFormDialogForCreate() {
        return Optional.ofNullable(allowMainFormDialogForCreate);
    }

    public EntityClientSetting withAllowMainFormDialogForCreate(Boolean allowMainFormDialogForCreate) {
        EntityClientSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityClientSetting");
        _x.allowMainFormDialogForCreate = allowMainFormDialogForCreate;
        return _x;
    }

    @Property(name="AllowMainFormDialogForEdit")
    @JsonIgnore
    public Optional<Boolean> getAllowMainFormDialogForEdit() {
        return Optional.ofNullable(allowMainFormDialogForEdit);
    }

    public EntityClientSetting withAllowMainFormDialogForEdit(Boolean allowMainFormDialogForEdit) {
        EntityClientSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityClientSetting");
        _x.allowMainFormDialogForEdit = allowMainFormDialogForEdit;
        return _x;
    }

    public EntityClientSetting withUnmappedField(String name, String value) {
        EntityClientSetting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowMainFormDialogForCreate;
        private Boolean allowMainFormDialogForEdit;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder allowMainFormDialogForCreate(Boolean allowMainFormDialogForCreate) {
            this.allowMainFormDialogForCreate = allowMainFormDialogForCreate;
            this.changedFields = changedFields.add("AllowMainFormDialogForCreate");
            return this;
        }

        public Builder allowMainFormDialogForEdit(Boolean allowMainFormDialogForEdit) {
            this.allowMainFormDialogForEdit = allowMainFormDialogForEdit;
            this.changedFields = changedFields.add("AllowMainFormDialogForEdit");
            return this;
        }

        public EntityClientSetting build() {
            EntityClientSetting _x = new EntityClientSetting();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.EntityClientSetting";
            _x.allowMainFormDialogForCreate = allowMainFormDialogForCreate;
            _x.allowMainFormDialogForEdit = allowMainFormDialogForEdit;
            return _x;
        }
    }

    private EntityClientSetting _copy() {
        EntityClientSetting _x = new EntityClientSetting();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowMainFormDialogForCreate = allowMainFormDialogForCreate;
        _x.allowMainFormDialogForEdit = allowMainFormDialogForEdit;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityClientSetting[");
        b.append("AllowMainFormDialogForCreate=");
        b.append(this.allowMainFormDialogForCreate);
        b.append(", ");
        b.append("AllowMainFormDialogForEdit=");
        b.append(this.allowMainFormDialogForEdit);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
