package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.enums.ConditionOperator;

@JsonPropertyOrder({
    "@odata.type", 
    "EntityName", 
    "CompareColumns", 
    "AttributeName", 
    "Operator", 
    "Values"})
@JsonInclude(Include.NON_NULL)
public class ConditionExpression implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("EntityName")
    protected String entityName;

    @JsonProperty("CompareColumns")
    protected Boolean compareColumns;

    @JsonProperty("AttributeName")
    protected String attributeName;

    @JsonProperty("Operator")
    protected ConditionOperator operator;

    @JsonProperty("Values")
    protected List<Object> values;

    @JsonProperty("Values@nextLink")
    protected String valuesNextLink;

    protected ConditionExpression() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ConditionExpression";
    }

    @Property(name="EntityName")
    @JsonIgnore
    public Optional<String> getEntityName() {
        return Optional.ofNullable(entityName);
    }

    public ConditionExpression withEntityName(String entityName) {
        Checks.checkIsAscii(entityName);
        ConditionExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ConditionExpression");
        _x.entityName = entityName;
        return _x;
    }

    @Property(name="CompareColumns")
    @JsonIgnore
    public Optional<Boolean> getCompareColumns() {
        return Optional.ofNullable(compareColumns);
    }

    public ConditionExpression withCompareColumns(Boolean compareColumns) {
        ConditionExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ConditionExpression");
        _x.compareColumns = compareColumns;
        return _x;
    }

    @Property(name="AttributeName")
    @JsonIgnore
    public Optional<String> getAttributeName() {
        return Optional.ofNullable(attributeName);
    }

    public ConditionExpression withAttributeName(String attributeName) {
        Checks.checkIsAscii(attributeName);
        ConditionExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ConditionExpression");
        _x.attributeName = attributeName;
        return _x;
    }

    @Property(name="Operator")
    @JsonIgnore
    public Optional<ConditionOperator> getOperator() {
        return Optional.ofNullable(operator);
    }

    public ConditionExpression withOperator(ConditionOperator operator) {
        ConditionExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ConditionExpression");
        _x.operator = operator;
        return _x;
    }

    @Property(name="Values")
    @JsonIgnore
    public CollectionPage<Object> getValues() {
        return new CollectionPage<Object>(contextPath, Object.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Values")
    @JsonIgnore
    public CollectionPage<Object> getValues(HttpRequestOptions options) {
        return new CollectionPage<Object>(contextPath, Object.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), options);
    }

    public ConditionExpression withUnmappedField(String name, String value) {
        ConditionExpression _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, java.lang.Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String entityName;
        private Boolean compareColumns;
        private String attributeName;
        private ConditionOperator operator;
        private List<Object> values;
        private String valuesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.changedFields = changedFields.add("EntityName");
            return this;
        }

        public Builder compareColumns(Boolean compareColumns) {
            this.compareColumns = compareColumns;
            this.changedFields = changedFields.add("CompareColumns");
            return this;
        }

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            this.changedFields = changedFields.add("AttributeName");
            return this;
        }

        public Builder operator(ConditionOperator operator) {
            this.operator = operator;
            this.changedFields = changedFields.add("Operator");
            return this;
        }

        public Builder values(List<Object> values) {
            this.values = values;
            this.changedFields = changedFields.add("Values");
            return this;
        }

        public Builder values(Object... values) {
            return values(Arrays.asList(values));
        }

        public Builder valuesNextLink(String valuesNextLink) {
            this.valuesNextLink = valuesNextLink;
            this.changedFields = changedFields.add("Values");
            return this;
        }

        public ConditionExpression build() {
            ConditionExpression _x = new ConditionExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ConditionExpression";
            _x.entityName = entityName;
            _x.compareColumns = compareColumns;
            _x.attributeName = attributeName;
            _x.operator = operator;
            _x.values = values;
            _x.valuesNextLink = valuesNextLink;
            return _x;
        }
    }

    private ConditionExpression _copy() {
        ConditionExpression _x = new ConditionExpression();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.entityName = entityName;
        _x.compareColumns = compareColumns;
        _x.attributeName = attributeName;
        _x.operator = operator;
        _x.values = values;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionExpression[");
        b.append("EntityName=");
        b.append(this.entityName);
        b.append(", ");
        b.append("CompareColumns=");
        b.append(this.compareColumns);
        b.append(", ");
        b.append("AttributeName=");
        b.append(this.attributeName);
        b.append(", ");
        b.append("Operator=");
        b.append(this.operator);
        b.append(", ");
        b.append("Values=");
        b.append(this.values);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
