package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "FileSizeInBytes", 
    "ActivityMimeAttachmentId"})
@JsonInclude(Include.NON_NULL)
public class CommitAttachmentBlocksUploadResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("FileSizeInBytes")
    protected Integer fileSizeInBytes;

    @JsonProperty("ActivityMimeAttachmentId")
    protected String activityMimeAttachmentId;

    protected CommitAttachmentBlocksUploadResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.CommitAttachmentBlocksUploadResponse";
    }

    @Property(name="FileSizeInBytes")
    @JsonIgnore
    public Optional<Integer> getFileSizeInBytes() {
        return Optional.ofNullable(fileSizeInBytes);
    }

    public CommitAttachmentBlocksUploadResponse withFileSizeInBytes(Integer fileSizeInBytes) {
        CommitAttachmentBlocksUploadResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CommitAttachmentBlocksUploadResponse");
        _x.fileSizeInBytes = fileSizeInBytes;
        return _x;
    }

    @Property(name="ActivityMimeAttachmentId")
    @JsonIgnore
    public Optional<String> getActivityMimeAttachmentId() {
        return Optional.ofNullable(activityMimeAttachmentId);
    }

    public CommitAttachmentBlocksUploadResponse withActivityMimeAttachmentId(String activityMimeAttachmentId) {
        CommitAttachmentBlocksUploadResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CommitAttachmentBlocksUploadResponse");
        _x.activityMimeAttachmentId = activityMimeAttachmentId;
        return _x;
    }

    public CommitAttachmentBlocksUploadResponse withUnmappedField(String name, String value) {
        CommitAttachmentBlocksUploadResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer fileSizeInBytes;
        private String activityMimeAttachmentId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder fileSizeInBytes(Integer fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
            this.changedFields = changedFields.add("FileSizeInBytes");
            return this;
        }

        public Builder activityMimeAttachmentId(String activityMimeAttachmentId) {
            this.activityMimeAttachmentId = activityMimeAttachmentId;
            this.changedFields = changedFields.add("ActivityMimeAttachmentId");
            return this;
        }

        public CommitAttachmentBlocksUploadResponse build() {
            CommitAttachmentBlocksUploadResponse _x = new CommitAttachmentBlocksUploadResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.CommitAttachmentBlocksUploadResponse";
            _x.fileSizeInBytes = fileSizeInBytes;
            _x.activityMimeAttachmentId = activityMimeAttachmentId;
            return _x;
        }
    }

    private CommitAttachmentBlocksUploadResponse _copy() {
        CommitAttachmentBlocksUploadResponse _x = new CommitAttachmentBlocksUploadResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.fileSizeInBytes = fileSizeInBytes;
        _x.activityMimeAttachmentId = activityMimeAttachmentId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CommitAttachmentBlocksUploadResponse[");
        b.append("FileSizeInBytes=");
        b.append(this.fileSizeInBytes);
        b.append(", ");
        b.append("ActivityMimeAttachmentId=");
        b.append(this.activityMimeAttachmentId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
