package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.dynamics.crm.enums.CascadeType;

@JsonPropertyOrder({
    "@odata.type", 
    "Assign", 
    "Delete", 
    "Merge", 
    "Reparent", 
    "Share", 
    "Unshare", 
    "RollupView"})
@JsonInclude(Include.NON_NULL)
public class CascadeConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Assign")
    protected CascadeType assign;

    @JsonProperty("Delete")
    protected CascadeType delete;

    @JsonProperty("Merge")
    protected CascadeType merge;

    @JsonProperty("Reparent")
    protected CascadeType reparent;

    @JsonProperty("Share")
    protected CascadeType share;

    @JsonProperty("Unshare")
    protected CascadeType unshare;

    @JsonProperty("RollupView")
    protected CascadeType rollupView;

    protected CascadeConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.CascadeConfiguration";
    }

    @Property(name="Assign")
    @JsonIgnore
    public Optional<CascadeType> getAssign() {
        return Optional.ofNullable(assign);
    }

    public CascadeConfiguration withAssign(CascadeType assign) {
        CascadeConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CascadeConfiguration");
        _x.assign = assign;
        return _x;
    }

    @Property(name="Delete")
    @JsonIgnore
    public Optional<CascadeType> getDelete() {
        return Optional.ofNullable(delete);
    }

    public CascadeConfiguration withDelete(CascadeType delete) {
        CascadeConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CascadeConfiguration");
        _x.delete = delete;
        return _x;
    }

    @Property(name="Merge")
    @JsonIgnore
    public Optional<CascadeType> getMerge() {
        return Optional.ofNullable(merge);
    }

    public CascadeConfiguration withMerge(CascadeType merge) {
        CascadeConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CascadeConfiguration");
        _x.merge = merge;
        return _x;
    }

    @Property(name="Reparent")
    @JsonIgnore
    public Optional<CascadeType> getReparent() {
        return Optional.ofNullable(reparent);
    }

    public CascadeConfiguration withReparent(CascadeType reparent) {
        CascadeConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CascadeConfiguration");
        _x.reparent = reparent;
        return _x;
    }

    @Property(name="Share")
    @JsonIgnore
    public Optional<CascadeType> getShare() {
        return Optional.ofNullable(share);
    }

    public CascadeConfiguration withShare(CascadeType share) {
        CascadeConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CascadeConfiguration");
        _x.share = share;
        return _x;
    }

    @Property(name="Unshare")
    @JsonIgnore
    public Optional<CascadeType> getUnshare() {
        return Optional.ofNullable(unshare);
    }

    public CascadeConfiguration withUnshare(CascadeType unshare) {
        CascadeConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CascadeConfiguration");
        _x.unshare = unshare;
        return _x;
    }

    @Property(name="RollupView")
    @JsonIgnore
    public Optional<CascadeType> getRollupView() {
        return Optional.ofNullable(rollupView);
    }

    public CascadeConfiguration withRollupView(CascadeType rollupView) {
        CascadeConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CascadeConfiguration");
        _x.rollupView = rollupView;
        return _x;
    }

    public CascadeConfiguration withUnmappedField(String name, String value) {
        CascadeConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CascadeType assign;
        private CascadeType delete;
        private CascadeType merge;
        private CascadeType reparent;
        private CascadeType share;
        private CascadeType unshare;
        private CascadeType rollupView;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder assign(CascadeType assign) {
            this.assign = assign;
            this.changedFields = changedFields.add("Assign");
            return this;
        }

        public Builder delete(CascadeType delete) {
            this.delete = delete;
            this.changedFields = changedFields.add("Delete");
            return this;
        }

        public Builder merge(CascadeType merge) {
            this.merge = merge;
            this.changedFields = changedFields.add("Merge");
            return this;
        }

        public Builder reparent(CascadeType reparent) {
            this.reparent = reparent;
            this.changedFields = changedFields.add("Reparent");
            return this;
        }

        public Builder share(CascadeType share) {
            this.share = share;
            this.changedFields = changedFields.add("Share");
            return this;
        }

        public Builder unshare(CascadeType unshare) {
            this.unshare = unshare;
            this.changedFields = changedFields.add("Unshare");
            return this;
        }

        public Builder rollupView(CascadeType rollupView) {
            this.rollupView = rollupView;
            this.changedFields = changedFields.add("RollupView");
            return this;
        }

        public CascadeConfiguration build() {
            CascadeConfiguration _x = new CascadeConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.CascadeConfiguration";
            _x.assign = assign;
            _x.delete = delete;
            _x.merge = merge;
            _x.reparent = reparent;
            _x.share = share;
            _x.unshare = unshare;
            _x.rollupView = rollupView;
            return _x;
        }
    }

    private CascadeConfiguration _copy() {
        CascadeConfiguration _x = new CascadeConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.assign = assign;
        _x.delete = delete;
        _x.merge = merge;
        _x.reparent = reparent;
        _x.share = share;
        _x.unshare = unshare;
        _x.rollupView = rollupView;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CascadeConfiguration[");
        b.append("Assign=");
        b.append(this.assign);
        b.append(", ");
        b.append("Delete=");
        b.append(this.delete);
        b.append(", ");
        b.append("Merge=");
        b.append(this.merge);
        b.append(", ");
        b.append("Reparent=");
        b.append(this.reparent);
        b.append(", ");
        b.append("Share=");
        b.append(this.share);
        b.append(", ");
        b.append("Unshare=");
        b.append(this.unshare);
        b.append(", ");
        b.append("RollupView=");
        b.append(this.rollupView);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
