/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import microsoft.dynamics.crm.complex.TraceInfo;

@JsonPropertyOrder(value={"@odata.type", "ValidationSuccess", "TraceInfo", "ActivityId"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ValidationResult
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="ValidationSuccess")
    protected Boolean validationSuccess;
    @JsonProperty(value="TraceInfo")
    protected TraceInfo traceInfo;
    @JsonProperty(value="ActivityId")
    protected String activityId;

    protected ValidationResult() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ValidationResult";
    }

    @Property(name="ValidationSuccess")
    @JsonIgnore
    public Optional<Boolean> getValidationSuccess() {
        return Optional.ofNullable(this.validationSuccess);
    }

    public ValidationResult withValidationSuccess(Boolean validationSuccess) {
        ValidationResult _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ValidationResult");
        _x.validationSuccess = validationSuccess;
        return _x;
    }

    @Property(name="TraceInfo")
    @JsonIgnore
    public Optional<TraceInfo> getTraceInfo() {
        return Optional.ofNullable(this.traceInfo);
    }

    public ValidationResult withTraceInfo(TraceInfo traceInfo) {
        ValidationResult _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ValidationResult");
        _x.traceInfo = traceInfo;
        return _x;
    }

    @Property(name="ActivityId")
    @JsonIgnore
    public Optional<String> getActivityId() {
        return Optional.ofNullable(this.activityId);
    }

    public ValidationResult withActivityId(String activityId) {
        ValidationResult _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ValidationResult");
        _x.activityId = activityId;
        return _x;
    }

    public ValidationResult withUnmappedField(String name, String value) {
        ValidationResult _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ValidationResult _copy() {
        ValidationResult _x = new ValidationResult();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.validationSuccess = this.validationSuccess;
        _x.traceInfo = this.traceInfo;
        _x.activityId = this.activityId;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ValidationResult[");
        b.append("ValidationSuccess=");
        b.append(this.validationSuccess);
        b.append(", ");
        b.append("TraceInfo=");
        b.append(this.traceInfo);
        b.append(", ");
        b.append("ActivityId=");
        b.append(this.activityId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private Boolean validationSuccess;
        private TraceInfo traceInfo;
        private String activityId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder validationSuccess(Boolean validationSuccess) {
            this.validationSuccess = validationSuccess;
            this.changedFields = this.changedFields.add("ValidationSuccess");
            return this;
        }

        public Builder traceInfo(TraceInfo traceInfo) {
            this.traceInfo = traceInfo;
            this.changedFields = this.changedFields.add("TraceInfo");
            return this;
        }

        public Builder activityId(String activityId) {
            this.activityId = activityId;
            this.changedFields = this.changedFields.add("ActivityId");
            return this;
        }

        public ValidationResult build() {
            ValidationResult _x = new ValidationResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ValidationResult";
            _x.validationSuccess = this.validationSuccess;
            _x.traceInfo = this.traceInfo;
            _x.activityId = this.activityId;
            return _x;
        }
    }
}

