/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "MessagePropertyName", "Attributes", "EntityAlias", "ImageType"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SdkMessageProcessingStepImageRegistration
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="MessagePropertyName")
    protected String messagePropertyName;
    @JsonProperty(value="Attributes")
    protected List<String> attributes;
    @JsonProperty(value="Attributes@nextLink")
    protected String attributesNextLink;
    @JsonProperty(value="EntityAlias")
    protected String entityAlias;
    @JsonProperty(value="ImageType")
    protected Integer imageType;

    protected SdkMessageProcessingStepImageRegistration() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.SdkMessageProcessingStepImageRegistration";
    }

    @Property(name="MessagePropertyName")
    @JsonIgnore
    public Optional<String> getMessagePropertyName() {
        return Optional.ofNullable(this.messagePropertyName);
    }

    public SdkMessageProcessingStepImageRegistration withMessagePropertyName(String messagePropertyName) {
        Checks.checkIsAscii((String)messagePropertyName);
        SdkMessageProcessingStepImageRegistration _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.SdkMessageProcessingStepImageRegistration");
        _x.messagePropertyName = messagePropertyName;
        return _x;
    }

    @Property(name="Attributes")
    @JsonIgnore
    public CollectionPage<String> getAttributes() {
        return new CollectionPage(this.contextPath, String.class, this.attributes, Optional.ofNullable(this.attributesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Attributes")
    @JsonIgnore
    public CollectionPage<String> getAttributes(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, String.class, this.attributes, Optional.ofNullable(this.attributesNextLink), Collections.emptyList(), options);
    }

    @Property(name="EntityAlias")
    @JsonIgnore
    public Optional<String> getEntityAlias() {
        return Optional.ofNullable(this.entityAlias);
    }

    public SdkMessageProcessingStepImageRegistration withEntityAlias(String entityAlias) {
        Checks.checkIsAscii((String)entityAlias);
        SdkMessageProcessingStepImageRegistration _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.SdkMessageProcessingStepImageRegistration");
        _x.entityAlias = entityAlias;
        return _x;
    }

    @Property(name="ImageType")
    @JsonIgnore
    public Optional<Integer> getImageType() {
        return Optional.ofNullable(this.imageType);
    }

    public SdkMessageProcessingStepImageRegistration withImageType(Integer imageType) {
        SdkMessageProcessingStepImageRegistration _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.SdkMessageProcessingStepImageRegistration");
        _x.imageType = imageType;
        return _x;
    }

    public SdkMessageProcessingStepImageRegistration withUnmappedField(String name, String value) {
        SdkMessageProcessingStepImageRegistration _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private SdkMessageProcessingStepImageRegistration _copy() {
        SdkMessageProcessingStepImageRegistration _x = new SdkMessageProcessingStepImageRegistration();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.messagePropertyName = this.messagePropertyName;
        _x.attributes = this.attributes;
        _x.entityAlias = this.entityAlias;
        _x.imageType = this.imageType;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SdkMessageProcessingStepImageRegistration[");
        b.append("MessagePropertyName=");
        b.append(this.messagePropertyName);
        b.append(", ");
        b.append("Attributes=");
        b.append(this.attributes);
        b.append(", ");
        b.append("EntityAlias=");
        b.append(this.entityAlias);
        b.append(", ");
        b.append("ImageType=");
        b.append(this.imageType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String messagePropertyName;
        private List<String> attributes;
        private String attributesNextLink;
        private String entityAlias;
        private Integer imageType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder messagePropertyName(String messagePropertyName) {
            this.messagePropertyName = messagePropertyName;
            this.changedFields = this.changedFields.add("MessagePropertyName");
            return this;
        }

        public Builder attributes(List<String> attributes) {
            this.attributes = attributes;
            this.changedFields = this.changedFields.add("Attributes");
            return this;
        }

        public Builder attributes(String ... attributes) {
            return this.attributes(Arrays.asList(attributes));
        }

        public Builder attributesNextLink(String attributesNextLink) {
            this.attributesNextLink = attributesNextLink;
            this.changedFields = this.changedFields.add("Attributes");
            return this;
        }

        public Builder entityAlias(String entityAlias) {
            this.entityAlias = entityAlias;
            this.changedFields = this.changedFields.add("EntityAlias");
            return this;
        }

        public Builder imageType(Integer imageType) {
            this.imageType = imageType;
            this.changedFields = this.changedFields.add("ImageType");
            return this;
        }

        public SdkMessageProcessingStepImageRegistration build() {
            SdkMessageProcessingStepImageRegistration _x = new SdkMessageProcessingStepImageRegistration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.SdkMessageProcessingStepImageRegistration";
            _x.messagePropertyName = this.messagePropertyName;
            _x.attributes = this.attributes;
            _x.attributesNextLink = this.attributesNextLink;
            _x.entityAlias = this.entityAlias;
            _x.imageType = this.imageType;
            return _x;
        }
    }
}

