/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "ResourceId", "ResourceSpecId"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RequiredResource
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="ResourceId")
    protected String resourceId;
    @JsonProperty(value="ResourceSpecId")
    protected String resourceSpecId;

    protected RequiredResource() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RequiredResource";
    }

    @Property(name="ResourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(this.resourceId);
    }

    public RequiredResource withResourceId(String resourceId) {
        RequiredResource _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.RequiredResource");
        _x.resourceId = resourceId;
        return _x;
    }

    @Property(name="ResourceSpecId")
    @JsonIgnore
    public Optional<String> getResourceSpecId() {
        return Optional.ofNullable(this.resourceSpecId);
    }

    public RequiredResource withResourceSpecId(String resourceSpecId) {
        RequiredResource _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.RequiredResource");
        _x.resourceSpecId = resourceSpecId;
        return _x;
    }

    public RequiredResource withUnmappedField(String name, String value) {
        RequiredResource _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private RequiredResource _copy() {
        RequiredResource _x = new RequiredResource();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.resourceId = this.resourceId;
        _x.resourceSpecId = this.resourceSpecId;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RequiredResource[");
        b.append("ResourceId=");
        b.append(this.resourceId);
        b.append(", ");
        b.append("ResourceSpecId=");
        b.append(this.resourceSpecId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String resourceId;
        private String resourceSpecId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = this.changedFields.add("ResourceId");
            return this;
        }

        public Builder resourceSpecId(String resourceSpecId) {
            this.resourceSpecId = resourceSpecId;
            this.changedFields = this.changedFields.add("ResourceSpecId");
            return this;
        }

        public RequiredResource build() {
            RequiredResource _x = new RequiredResource();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RequiredResource";
            _x.resourceId = this.resourceId;
            _x.resourceSpecId = this.resourceSpecId;
            return _x;
        }
    }
}

