/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import microsoft.dynamics.crm.complex.LookupEntityMetadata;
import microsoft.dynamics.crm.complex.LookupView;

@JsonPropertyOrder(value={"@odata.type", "Entity", "View"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LookupMetadata
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Entity")
    protected LookupEntityMetadata entity;
    @JsonProperty(value="View")
    protected LookupView view;

    protected LookupMetadata() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LookupMetadata";
    }

    @Property(name="Entity")
    @JsonIgnore
    public Optional<LookupEntityMetadata> getEntity() {
        return Optional.ofNullable(this.entity);
    }

    public LookupMetadata withEntity(LookupEntityMetadata entity) {
        LookupMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupMetadata");
        _x.entity = entity;
        return _x;
    }

    @Property(name="View")
    @JsonIgnore
    public Optional<LookupView> getView() {
        return Optional.ofNullable(this.view);
    }

    public LookupMetadata withView(LookupView view) {
        LookupMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupMetadata");
        _x.view = view;
        return _x;
    }

    public LookupMetadata withUnmappedField(String name, String value) {
        LookupMetadata _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private LookupMetadata _copy() {
        LookupMetadata _x = new LookupMetadata();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.entity = this.entity;
        _x.view = this.view;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LookupMetadata[");
        b.append("Entity=");
        b.append(this.entity);
        b.append(", ");
        b.append("View=");
        b.append(this.view);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private LookupEntityMetadata entity;
        private LookupView view;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder entity(LookupEntityMetadata entity) {
            this.entity = entity;
            this.changedFields = this.changedFields.add("Entity");
            return this;
        }

        public Builder view(LookupView view) {
            this.view = view;
            this.changedFields = this.changedFields.add("View");
            return this;
        }

        public LookupMetadata build() {
            LookupMetadata _x = new LookupMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LookupMetadata";
            _x.entity = this.entity;
            _x.view = this.view;
            return _x;
        }
    }
}

