/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import microsoft.dynamics.crm.complex.PagingInfo;

@JsonPropertyOrder(value={"@odata.type", "EntityLogicalName", "ViewId", "CustomFilter", "RelationshipName", "FetchXml", "LayoutJson", "PagingInfo"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LookupEntityInfo
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="EntityLogicalName")
    protected String entityLogicalName;
    @JsonProperty(value="ViewId")
    protected String viewId;
    @JsonProperty(value="CustomFilter")
    protected String customFilter;
    @JsonProperty(value="RelationshipName")
    protected String relationshipName;
    @JsonProperty(value="FetchXml")
    protected String fetchXml;
    @JsonProperty(value="LayoutJson")
    protected String layoutJson;
    @JsonProperty(value="PagingInfo")
    protected PagingInfo pagingInfo;

    protected LookupEntityInfo() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LookupEntityInfo";
    }

    @Property(name="EntityLogicalName")
    @JsonIgnore
    public Optional<String> getEntityLogicalName() {
        return Optional.ofNullable(this.entityLogicalName);
    }

    public LookupEntityInfo withEntityLogicalName(String entityLogicalName) {
        Checks.checkIsAscii((String)entityLogicalName);
        LookupEntityInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupEntityInfo");
        _x.entityLogicalName = entityLogicalName;
        return _x;
    }

    @Property(name="ViewId")
    @JsonIgnore
    public Optional<String> getViewId() {
        return Optional.ofNullable(this.viewId);
    }

    public LookupEntityInfo withViewId(String viewId) {
        LookupEntityInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupEntityInfo");
        _x.viewId = viewId;
        return _x;
    }

    @Property(name="CustomFilter")
    @JsonIgnore
    public Optional<String> getCustomFilter() {
        return Optional.ofNullable(this.customFilter);
    }

    public LookupEntityInfo withCustomFilter(String customFilter) {
        Checks.checkIsAscii((String)customFilter);
        LookupEntityInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupEntityInfo");
        _x.customFilter = customFilter;
        return _x;
    }

    @Property(name="RelationshipName")
    @JsonIgnore
    public Optional<String> getRelationshipName() {
        return Optional.ofNullable(this.relationshipName);
    }

    public LookupEntityInfo withRelationshipName(String relationshipName) {
        Checks.checkIsAscii((String)relationshipName);
        LookupEntityInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupEntityInfo");
        _x.relationshipName = relationshipName;
        return _x;
    }

    @Property(name="FetchXml")
    @JsonIgnore
    public Optional<String> getFetchXml() {
        return Optional.ofNullable(this.fetchXml);
    }

    public LookupEntityInfo withFetchXml(String fetchXml) {
        Checks.checkIsAscii((String)fetchXml);
        LookupEntityInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupEntityInfo");
        _x.fetchXml = fetchXml;
        return _x;
    }

    @Property(name="LayoutJson")
    @JsonIgnore
    public Optional<String> getLayoutJson() {
        return Optional.ofNullable(this.layoutJson);
    }

    public LookupEntityInfo withLayoutJson(String layoutJson) {
        Checks.checkIsAscii((String)layoutJson);
        LookupEntityInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupEntityInfo");
        _x.layoutJson = layoutJson;
        return _x;
    }

    @Property(name="PagingInfo")
    @JsonIgnore
    public Optional<PagingInfo> getPagingInfo() {
        return Optional.ofNullable(this.pagingInfo);
    }

    public LookupEntityInfo withPagingInfo(PagingInfo pagingInfo) {
        LookupEntityInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupEntityInfo");
        _x.pagingInfo = pagingInfo;
        return _x;
    }

    public LookupEntityInfo withUnmappedField(String name, String value) {
        LookupEntityInfo _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private LookupEntityInfo _copy() {
        LookupEntityInfo _x = new LookupEntityInfo();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.entityLogicalName = this.entityLogicalName;
        _x.viewId = this.viewId;
        _x.customFilter = this.customFilter;
        _x.relationshipName = this.relationshipName;
        _x.fetchXml = this.fetchXml;
        _x.layoutJson = this.layoutJson;
        _x.pagingInfo = this.pagingInfo;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LookupEntityInfo[");
        b.append("EntityLogicalName=");
        b.append(this.entityLogicalName);
        b.append(", ");
        b.append("ViewId=");
        b.append(this.viewId);
        b.append(", ");
        b.append("CustomFilter=");
        b.append(this.customFilter);
        b.append(", ");
        b.append("RelationshipName=");
        b.append(this.relationshipName);
        b.append(", ");
        b.append("FetchXml=");
        b.append(this.fetchXml);
        b.append(", ");
        b.append("LayoutJson=");
        b.append(this.layoutJson);
        b.append(", ");
        b.append("PagingInfo=");
        b.append(this.pagingInfo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String entityLogicalName;
        private String viewId;
        private String customFilter;
        private String relationshipName;
        private String fetchXml;
        private String layoutJson;
        private PagingInfo pagingInfo;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder entityLogicalName(String entityLogicalName) {
            this.entityLogicalName = entityLogicalName;
            this.changedFields = this.changedFields.add("EntityLogicalName");
            return this;
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            this.changedFields = this.changedFields.add("ViewId");
            return this;
        }

        public Builder customFilter(String customFilter) {
            this.customFilter = customFilter;
            this.changedFields = this.changedFields.add("CustomFilter");
            return this;
        }

        public Builder relationshipName(String relationshipName) {
            this.relationshipName = relationshipName;
            this.changedFields = this.changedFields.add("RelationshipName");
            return this;
        }

        public Builder fetchXml(String fetchXml) {
            this.fetchXml = fetchXml;
            this.changedFields = this.changedFields.add("FetchXml");
            return this;
        }

        public Builder layoutJson(String layoutJson) {
            this.layoutJson = layoutJson;
            this.changedFields = this.changedFields.add("LayoutJson");
            return this;
        }

        public Builder pagingInfo(PagingInfo pagingInfo) {
            this.pagingInfo = pagingInfo;
            this.changedFields = this.changedFields.add("PagingInfo");
            return this;
        }

        public LookupEntityInfo build() {
            LookupEntityInfo _x = new LookupEntityInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LookupEntityInfo";
            _x.entityLogicalName = this.entityLogicalName;
            _x.viewId = this.viewId;
            _x.customFilter = this.customFilter;
            _x.relationshipName = this.relationshipName;
            _x.fetchXml = this.fetchXml;
            _x.layoutJson = this.layoutJson;
            _x.pagingInfo = this.pagingInfo;
            return _x;
        }
    }
}

