/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.ComplexEntityMetadata;
import microsoft.dynamics.crm.complex.EntityClientSetting;

@JsonPropertyOrder(value={"@odata.type", "EntityMetadata", "AttributeNames", "EntityClientSetting"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ClientEntityMetadata
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="EntityMetadata")
    protected ComplexEntityMetadata entityMetadata;
    @JsonProperty(value="AttributeNames")
    protected List<String> attributeNames;
    @JsonProperty(value="AttributeNames@nextLink")
    protected String attributeNamesNextLink;
    @JsonProperty(value="EntityClientSetting")
    protected EntityClientSetting entityClientSetting;

    protected ClientEntityMetadata() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ClientEntityMetadata";
    }

    @Property(name="EntityMetadata")
    @JsonIgnore
    public Optional<ComplexEntityMetadata> getEntityMetadata() {
        return Optional.ofNullable(this.entityMetadata);
    }

    public ClientEntityMetadata withEntityMetadata(ComplexEntityMetadata entityMetadata) {
        ClientEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ClientEntityMetadata");
        _x.entityMetadata = entityMetadata;
        return _x;
    }

    @Property(name="AttributeNames")
    @JsonIgnore
    public CollectionPage<String> getAttributeNames() {
        return new CollectionPage(this.contextPath, String.class, this.attributeNames, Optional.ofNullable(this.attributeNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="AttributeNames")
    @JsonIgnore
    public CollectionPage<String> getAttributeNames(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, String.class, this.attributeNames, Optional.ofNullable(this.attributeNamesNextLink), Collections.emptyList(), options);
    }

    @Property(name="EntityClientSetting")
    @JsonIgnore
    public Optional<EntityClientSetting> getEntityClientSetting() {
        return Optional.ofNullable(this.entityClientSetting);
    }

    public ClientEntityMetadata withEntityClientSetting(EntityClientSetting entityClientSetting) {
        ClientEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ClientEntityMetadata");
        _x.entityClientSetting = entityClientSetting;
        return _x;
    }

    public ClientEntityMetadata withUnmappedField(String name, String value) {
        ClientEntityMetadata _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ClientEntityMetadata _copy() {
        ClientEntityMetadata _x = new ClientEntityMetadata();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.entityMetadata = this.entityMetadata;
        _x.attributeNames = this.attributeNames;
        _x.entityClientSetting = this.entityClientSetting;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ClientEntityMetadata[");
        b.append("EntityMetadata=");
        b.append(this.entityMetadata);
        b.append(", ");
        b.append("AttributeNames=");
        b.append(this.attributeNames);
        b.append(", ");
        b.append("EntityClientSetting=");
        b.append(this.entityClientSetting);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private ComplexEntityMetadata entityMetadata;
        private List<String> attributeNames;
        private String attributeNamesNextLink;
        private EntityClientSetting entityClientSetting;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder entityMetadata(ComplexEntityMetadata entityMetadata) {
            this.entityMetadata = entityMetadata;
            this.changedFields = this.changedFields.add("EntityMetadata");
            return this;
        }

        public Builder attributeNames(List<String> attributeNames) {
            this.attributeNames = attributeNames;
            this.changedFields = this.changedFields.add("AttributeNames");
            return this;
        }

        public Builder attributeNames(String ... attributeNames) {
            return this.attributeNames(Arrays.asList(attributeNames));
        }

        public Builder attributeNamesNextLink(String attributeNamesNextLink) {
            this.attributeNamesNextLink = attributeNamesNextLink;
            this.changedFields = this.changedFields.add("AttributeNames");
            return this;
        }

        public Builder entityClientSetting(EntityClientSetting entityClientSetting) {
            this.entityClientSetting = entityClientSetting;
            this.changedFields = this.changedFields.add("EntityClientSetting");
            return this;
        }

        public ClientEntityMetadata build() {
            ClientEntityMetadata _x = new ClientEntityMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ClientEntityMetadata";
            _x.entityMetadata = this.entityMetadata;
            _x.attributeNames = this.attributeNames;
            _x.attributeNamesNextLink = this.attributeNamesNextLink;
            _x.entityClientSetting = this.entityClientSetting;
            return _x;
        }
    }
}

