/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.BusinessNotificationParameter;
import microsoft.dynamics.crm.enums.BusinessNotificationSeverity;

@JsonPropertyOrder(value={"@odata.type", "Severity", "Message", "Parameters"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BusinessNotification
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Severity")
    protected BusinessNotificationSeverity severity;
    @JsonProperty(value="Message")
    protected String message;
    @JsonProperty(value="Parameters")
    protected List<BusinessNotificationParameter> parameters;
    @JsonProperty(value="Parameters@nextLink")
    protected String parametersNextLink;

    protected BusinessNotification() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.BusinessNotification";
    }

    @Property(name="Severity")
    @JsonIgnore
    public Optional<BusinessNotificationSeverity> getSeverity() {
        return Optional.ofNullable(this.severity);
    }

    public BusinessNotification withSeverity(BusinessNotificationSeverity severity) {
        BusinessNotification _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.BusinessNotification");
        _x.severity = severity;
        return _x;
    }

    @Property(name="Message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public BusinessNotification withMessage(String message) {
        Checks.checkIsAscii((String)message);
        BusinessNotification _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.BusinessNotification");
        _x.message = message;
        return _x;
    }

    @Property(name="Parameters")
    @JsonIgnore
    public CollectionPage<BusinessNotificationParameter> getParameters() {
        return new CollectionPage(this.contextPath, BusinessNotificationParameter.class, this.parameters, Optional.ofNullable(this.parametersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Parameters")
    @JsonIgnore
    public CollectionPage<BusinessNotificationParameter> getParameters(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, BusinessNotificationParameter.class, this.parameters, Optional.ofNullable(this.parametersNextLink), Collections.emptyList(), options);
    }

    public BusinessNotification withUnmappedField(String name, String value) {
        BusinessNotification _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private BusinessNotification _copy() {
        BusinessNotification _x = new BusinessNotification();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.severity = this.severity;
        _x.message = this.message;
        _x.parameters = this.parameters;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BusinessNotification[");
        b.append("Severity=");
        b.append((Object)this.severity);
        b.append(", ");
        b.append("Message=");
        b.append(this.message);
        b.append(", ");
        b.append("Parameters=");
        b.append(this.parameters);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private BusinessNotificationSeverity severity;
        private String message;
        private List<BusinessNotificationParameter> parameters;
        private String parametersNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder severity(BusinessNotificationSeverity severity) {
            this.severity = severity;
            this.changedFields = this.changedFields.add("Severity");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = this.changedFields.add("Message");
            return this;
        }

        public Builder parameters(List<BusinessNotificationParameter> parameters) {
            this.parameters = parameters;
            this.changedFields = this.changedFields.add("Parameters");
            return this;
        }

        public Builder parameters(BusinessNotificationParameter ... parameters) {
            return this.parameters(Arrays.asList(parameters));
        }

        public Builder parametersNextLink(String parametersNextLink) {
            this.parametersNextLink = parametersNextLink;
            this.changedFields = this.changedFields.add("Parameters");
            return this;
        }

        public BusinessNotification build() {
            BusinessNotification _x = new BusinessNotification();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.BusinessNotification";
            _x.severity = this.severity;
            _x.message = this.message;
            _x.parameters = this.parameters;
            _x.parametersNextLink = this.parametersNextLink;
            return _x;
        }
    }
}

