/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "Appointments", "ResourceId"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AppointmentsToIgnore
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Appointments")
    protected List<String> appointments;
    @JsonProperty(value="Appointments@nextLink")
    protected String appointmentsNextLink;
    @JsonProperty(value="ResourceId")
    protected String resourceId;

    protected AppointmentsToIgnore() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppointmentsToIgnore";
    }

    @Property(name="Appointments")
    @JsonIgnore
    public CollectionPage<String> getAppointments() {
        return new CollectionPage(this.contextPath, String.class, this.appointments, Optional.ofNullable(this.appointmentsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Appointments")
    @JsonIgnore
    public CollectionPage<String> getAppointments(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, String.class, this.appointments, Optional.ofNullable(this.appointmentsNextLink), Collections.emptyList(), options);
    }

    @Property(name="ResourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(this.resourceId);
    }

    public AppointmentsToIgnore withResourceId(String resourceId) {
        AppointmentsToIgnore _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppointmentsToIgnore");
        _x.resourceId = resourceId;
        return _x;
    }

    public AppointmentsToIgnore withUnmappedField(String name, String value) {
        AppointmentsToIgnore _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private AppointmentsToIgnore _copy() {
        AppointmentsToIgnore _x = new AppointmentsToIgnore();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.appointments = this.appointments;
        _x.resourceId = this.resourceId;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppointmentsToIgnore[");
        b.append("Appointments=");
        b.append(this.appointments);
        b.append(", ");
        b.append("ResourceId=");
        b.append(this.resourceId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private List<String> appointments;
        private String appointmentsNextLink;
        private String resourceId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder appointments(List<String> appointments) {
            this.appointments = appointments;
            this.changedFields = this.changedFields.add("Appointments");
            return this;
        }

        public Builder appointments(String ... appointments) {
            return this.appointments(Arrays.asList(appointments));
        }

        public Builder appointmentsNextLink(String appointmentsNextLink) {
            this.appointmentsNextLink = appointmentsNextLink;
            this.changedFields = this.changedFields.add("Appointments");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = this.changedFields.add("ResourceId");
            return this;
        }

        public AppointmentsToIgnore build() {
            AppointmentsToIgnore _x = new AppointmentsToIgnore();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppointmentsToIgnore";
            _x.appointments = this.appointments;
            _x.appointmentsNextLink = this.appointmentsNextLink;
            _x.resourceId = this.resourceId;
            return _x;
        }
    }
}

