package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ManagedPropertyEvaluationPriority implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Low")
    LOW("Low", "1"),

    @JsonProperty("Normal")
    NORMAL("Normal", "2"),

    @JsonProperty("High")
    HIGH("High", "3"),

    @JsonProperty("Essential")
    ESSENTIAL("Essential", "4");

    private final String name;
    private final String value;

    private ManagedPropertyEvaluationPriority(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
