package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ConditionOperator implements Enum {

    @JsonProperty("Equal")
    EQUAL("Equal", "0"),

    @JsonProperty("NotEqual")
    NOT_EQUAL("NotEqual", "1"),

    @JsonProperty("GreaterThan")
    GREATER_THAN("GreaterThan", "2"),

    @JsonProperty("LessThan")
    LESS_THAN("LessThan", "3"),

    @JsonProperty("GreaterEqual")
    GREATER_EQUAL("GreaterEqual", "4"),

    @JsonProperty("LessEqual")
    LESS_EQUAL("LessEqual", "5"),

    @JsonProperty("Like")
    LIKE("Like", "6"),

    @JsonProperty("NotLike")
    NOT_LIKE("NotLike", "7"),

    @JsonProperty("In")
    IN("In", "8"),

    @JsonProperty("NotIn")
    NOT_IN("NotIn", "9"),

    @JsonProperty("Between")
    BETWEEN("Between", "10"),

    @JsonProperty("NotBetween")
    NOT_BETWEEN("NotBetween", "11"),

    @JsonProperty("Null")
    NULL("Null", "12"),

    @JsonProperty("NotNull")
    NOT_NULL("NotNull", "13"),

    @JsonProperty("Yesterday")
    YESTERDAY("Yesterday", "14"),

    @JsonProperty("Today")
    TODAY("Today", "15"),

    @JsonProperty("Tomorrow")
    TOMORROW("Tomorrow", "16"),

    @JsonProperty("Last7Days")
    LAST7DAYS("Last7Days", "17"),

    @JsonProperty("Next7Days")
    NEXT7DAYS("Next7Days", "18"),

    @JsonProperty("LastWeek")
    LAST_WEEK("LastWeek", "19"),

    @JsonProperty("ThisWeek")
    THIS_WEEK("ThisWeek", "20"),

    @JsonProperty("NextWeek")
    NEXT_WEEK("NextWeek", "21"),

    @JsonProperty("LastMonth")
    LAST_MONTH("LastMonth", "22"),

    @JsonProperty("ThisMonth")
    THIS_MONTH("ThisMonth", "23"),

    @JsonProperty("NextMonth")
    NEXT_MONTH("NextMonth", "24"),

    @JsonProperty("On")
    ON("On", "25"),

    @JsonProperty("OnOrBefore")
    ON_OR_BEFORE("OnOrBefore", "26"),

    @JsonProperty("OnOrAfter")
    ON_OR_AFTER("OnOrAfter", "27"),

    @JsonProperty("LastYear")
    LAST_YEAR("LastYear", "28"),

    @JsonProperty("ThisYear")
    THIS_YEAR("ThisYear", "29"),

    @JsonProperty("NextYear")
    NEXT_YEAR("NextYear", "30"),

    @JsonProperty("LastXHours")
    LAST_XHOURS("LastXHours", "31"),

    @JsonProperty("NextXHours")
    NEXT_XHOURS("NextXHours", "32"),

    @JsonProperty("LastXDays")
    LAST_XDAYS("LastXDays", "33"),

    @JsonProperty("NextXDays")
    NEXT_XDAYS("NextXDays", "34"),

    @JsonProperty("LastXWeeks")
    LAST_XWEEKS("LastXWeeks", "35"),

    @JsonProperty("NextXWeeks")
    NEXT_XWEEKS("NextXWeeks", "36"),

    @JsonProperty("LastXMonths")
    LAST_XMONTHS("LastXMonths", "37"),

    @JsonProperty("NextXMonths")
    NEXT_XMONTHS("NextXMonths", "38"),

    @JsonProperty("LastXYears")
    LAST_XYEARS("LastXYears", "39"),

    @JsonProperty("NextXYears")
    NEXT_XYEARS("NextXYears", "40"),

    @JsonProperty("EqualUserId")
    EQUAL_USER_ID("EqualUserId", "41"),

    @JsonProperty("NotEqualUserId")
    NOT_EQUAL_USER_ID("NotEqualUserId", "42"),

    @JsonProperty("EqualBusinessId")
    EQUAL_BUSINESS_ID("EqualBusinessId", "43"),

    @JsonProperty("NotEqualBusinessId")
    NOT_EQUAL_BUSINESS_ID("NotEqualBusinessId", "44"),

    @JsonProperty("ChildOf")
    CHILD_OF("ChildOf", "45"),

    @JsonProperty("Mask")
    MASK("Mask", "46"),

    @JsonProperty("NotMask")
    NOT_MASK("NotMask", "47"),

    @JsonProperty("MasksSelect")
    MASKS_SELECT("MasksSelect", "48"),

    @JsonProperty("Contains")
    CONTAINS("Contains", "49"),

    @JsonProperty("DoesNotContain")
    DOES_NOT_CONTAIN("DoesNotContain", "50"),

    @JsonProperty("EqualUserLanguage")
    EQUAL_USER_LANGUAGE("EqualUserLanguage", "51"),

    @JsonProperty("NotOn")
    NOT_ON("NotOn", "52"),

    @JsonProperty("OlderThanXMonths")
    OLDER_THAN_XMONTHS("OlderThanXMonths", "53"),

    @JsonProperty("BeginsWith")
    BEGINS_WITH("BeginsWith", "54"),

    @JsonProperty("DoesNotBeginWith")
    DOES_NOT_BEGIN_WITH("DoesNotBeginWith", "55"),

    @JsonProperty("EndsWith")
    ENDS_WITH("EndsWith", "56"),

    @JsonProperty("DoesNotEndWith")
    DOES_NOT_END_WITH("DoesNotEndWith", "57"),

    @JsonProperty("ThisFiscalYear")
    THIS_FISCAL_YEAR("ThisFiscalYear", "58"),

    @JsonProperty("ThisFiscalPeriod")
    THIS_FISCAL_PERIOD("ThisFiscalPeriod", "59"),

    @JsonProperty("NextFiscalYear")
    NEXT_FISCAL_YEAR("NextFiscalYear", "60"),

    @JsonProperty("NextFiscalPeriod")
    NEXT_FISCAL_PERIOD("NextFiscalPeriod", "61"),

    @JsonProperty("LastFiscalYear")
    LAST_FISCAL_YEAR("LastFiscalYear", "62"),

    @JsonProperty("LastFiscalPeriod")
    LAST_FISCAL_PERIOD("LastFiscalPeriod", "63"),

    @JsonProperty("LastXFiscalYears")
    LAST_XFISCAL_YEARS("LastXFiscalYears", "64"),

    @JsonProperty("LastXFiscalPeriods")
    LAST_XFISCAL_PERIODS("LastXFiscalPeriods", "65"),

    @JsonProperty("NextXFiscalYears")
    NEXT_XFISCAL_YEARS("NextXFiscalYears", "66"),

    @JsonProperty("NextXFiscalPeriods")
    NEXT_XFISCAL_PERIODS("NextXFiscalPeriods", "67"),

    @JsonProperty("InFiscalYear")
    IN_FISCAL_YEAR("InFiscalYear", "68"),

    @JsonProperty("InFiscalPeriod")
    IN_FISCAL_PERIOD("InFiscalPeriod", "69"),

    @JsonProperty("InFiscalPeriodAndYear")
    IN_FISCAL_PERIOD_AND_YEAR("InFiscalPeriodAndYear", "70"),

    @JsonProperty("InOrBeforeFiscalPeriodAndYear")
    IN_OR_BEFORE_FISCAL_PERIOD_AND_YEAR("InOrBeforeFiscalPeriodAndYear", "71"),

    @JsonProperty("InOrAfterFiscalPeriodAndYear")
    IN_OR_AFTER_FISCAL_PERIOD_AND_YEAR("InOrAfterFiscalPeriodAndYear", "72"),

    @JsonProperty("EqualUserTeams")
    EQUAL_USER_TEAMS("EqualUserTeams", "73"),

    @JsonProperty("EqualUserOrUserTeams")
    EQUAL_USER_OR_USER_TEAMS("EqualUserOrUserTeams", "74"),

    @JsonProperty("Under")
    UNDER("Under", "75"),

    @JsonProperty("NotUnder")
    NOT_UNDER("NotUnder", "76"),

    @JsonProperty("UnderOrEqual")
    UNDER_OR_EQUAL("UnderOrEqual", "77"),

    @JsonProperty("Above")
    ABOVE("Above", "78"),

    @JsonProperty("AboveOrEqual")
    ABOVE_OR_EQUAL("AboveOrEqual", "79"),

    @JsonProperty("EqualUserOrUserHierarchy")
    EQUAL_USER_OR_USER_HIERARCHY("EqualUserOrUserHierarchy", "80"),

    @JsonProperty("EqualUserOrUserHierarchyAndTeams")
    EQUAL_USER_OR_USER_HIERARCHY_AND_TEAMS("EqualUserOrUserHierarchyAndTeams", "81"),

    @JsonProperty("OlderThanXYears")
    OLDER_THAN_XYEARS("OlderThanXYears", "82"),

    @JsonProperty("OlderThanXWeeks")
    OLDER_THAN_XWEEKS("OlderThanXWeeks", "83"),

    @JsonProperty("OlderThanXDays")
    OLDER_THAN_XDAYS("OlderThanXDays", "84"),

    @JsonProperty("OlderThanXHours")
    OLDER_THAN_XHOURS("OlderThanXHours", "85"),

    @JsonProperty("OlderThanXMinutes")
    OLDER_THAN_XMINUTES("OlderThanXMinutes", "86"),

    @JsonProperty("ContainValues")
    CONTAIN_VALUES("ContainValues", "87"),

    @JsonProperty("DoesNotContainValues")
    DOES_NOT_CONTAIN_VALUES("DoesNotContainValues", "88");

    private final String name;
    private final String value;

    private ConditionOperator(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
