package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AttributeRequiredLevel implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("SystemRequired")
    SYSTEM_REQUIRED("SystemRequired", "1"),

    @JsonProperty("ApplicationRequired")
    APPLICATION_REQUIRED("ApplicationRequired", "2"),

    @JsonProperty("Recommended")
    RECOMMENDED("Recommended", "3");

    private final String name;
    private final String value;

    private AttributeRequiredLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
