package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Slaitem;
import microsoft.dynamics.crm.entity.collection.request.SlakpiinstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class SlaitemRequest extends EntityRequest<Slaitem> {

    public SlaitemRequest(ContextPath contextPath, Optional<Object> value) {
        super(Slaitem.class, contextPath, value);
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public WorkflowRequest workflowid() {
        return new WorkflowRequest(contextPath.addSegment("workflowid"), Optional.empty());
    }

    public SyncerrorCollectionRequest sLAItem_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SLAItem_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest sLAItem_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SLAItem_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SlaRequest slaid() {
        return new SlaRequest(contextPath.addSegment("slaid"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public CalendarRequest businesshoursid() {
        return new CalendarRequest(contextPath.addSegment("businesshoursid"), Optional.empty());
    }

    public Msdyn_slakpiRequest msdyn_SLAKPIID() {
        return new Msdyn_slakpiRequest(contextPath.addSegment("msdyn_SLAKPIID"), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest msdyn_slaitem_slakpiinstance() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("msdyn_slaitem_slakpiinstance"), Optional.empty());
    }

    public SlakpiinstanceRequest msdyn_slaitem_slakpiinstance(String slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("msdyn_slaitem_slakpiinstance").addKeys(new NameValue(slakpiinstanceid.toString())), Optional.empty());
    }

}
