package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.complex.DownloadReportDefinitionResponse;
import microsoft.dynamics.crm.complex.GetReportHistoryLimitResponse;
import microsoft.dynamics.crm.entity.Report;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ReportCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ReportcategoryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class ReportRequest extends EntityRequest<Report> {

    public ReportRequest(ContextPath contextPath, Optional<Object> value) {
        super(Report.class, contextPath, value);
    }

    public AsyncoperationCollectionRequest report_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Report_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest report_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Report_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public ReportcategoryCollectionRequest report_reportcategories() {
        return new ReportcategoryCollectionRequest(
                        contextPath.addSegment("report_reportcategories"), Optional.empty());
    }

    public ReportcategoryRequest report_reportcategories(String reportcategoryid) {
        return new ReportcategoryRequest(contextPath.addSegment("report_reportcategories").addKeys(new NameValue(reportcategoryid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public ProcesssessionCollectionRequest report_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Report_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest report_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Report_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SyncerrorCollectionRequest report_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Report_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest report_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Report_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public ReportRequest parentreportid() {
        return new ReportRequest(contextPath.addSegment("parentreportid"), Optional.empty());
    }

    public ReportCollectionRequest report_parent_report() {
        return new ReportCollectionRequest(
                        contextPath.addSegment("report_parent_report"), Optional.empty());
    }

    public ReportRequest report_parent_report(String reportid) {
        return new ReportRequest(contextPath.addSegment("report_parent_report").addKeys(new NameValue(reportid.toString())), Optional.empty());
    }

    @Function(name = "DownloadReportDefinition")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DownloadReportDefinitionResponse> downloadReportDefinition() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<DownloadReportDefinitionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DownloadReportDefinition"), DownloadReportDefinitionResponse.class, _parameters);
    }

    @Function(name = "GetReportHistoryLimit")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GetReportHistoryLimitResponse> getReportHistoryLimit() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<GetReportHistoryLimitResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetReportHistoryLimit"), GetReportHistoryLimitResponse.class, _parameters);
    }

}
