package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.EnumAttributeMetadata;

@JsonIgnoreType
public class EnumAttributeMetadataRequest extends EntityRequest<EnumAttributeMetadata> {

    public EnumAttributeMetadataRequest(ContextPath contextPath, Optional<Object> value) {
        super(EnumAttributeMetadata.class, contextPath, value);
    }

    public OptionSetMetadataRequest optionSet() {
        return new OptionSetMetadataRequest(contextPath.addSegment("OptionSet"), Optional.empty());
    }

    public OptionSetMetadataRequest globalOptionSet() {
        return new OptionSetMetadataRequest(contextPath.addSegment("GlobalOptionSet"), Optional.empty());
    }

}
