package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Feedback;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.FeedbackRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class FeedbackCollectionRequest extends CollectionPageEntityRequest<Feedback, FeedbackRequest>{

    protected ContextPath contextPath;

    public FeedbackCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Feedback.class, cp -> new FeedbackRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PrincipalobjectattributeaccessCollectionRequest feedback_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("feedback_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest feedback_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("feedback_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public FeedbackCollectionRequest feedback_feedback() {
        return new FeedbackCollectionRequest(contextPath.addSegment("feedback_feedback"), Optional.empty());
    }

    public FeedbackRequest feedback_feedback(String feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("feedback_feedback").addKeys(new NameValue(feedbackid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest feedback_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Feedback_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest feedback_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Feedback_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest feedback_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("feedback_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest feedback_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("feedback_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest feedback_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("feedback_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest feedback_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("feedback_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

}
