package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "createdon", 
    "_createdonbehalfby_value", 
    "componentstate", 
    "webwizardidunique", 
    "_organizationid_value", 
    "wizardpageheight", 
    "modifiedon", 
    "versionnumber", 
    "isstaticpagesequence", 
    "ismanaged", 
    "_modifiedby_value", 
    "_modifiedonbehalfby_value", 
    "accessprivileges", 
    "titleresourcestring", 
    "wizardpagewidth", 
    "overwritetime", 
    "webwizardid", 
    "introducedversion", 
    "_createdby_value", 
    "startpagesequencenumber", 
    "solutionid"})
@JsonInclude(Include.NON_NULL)
public class Webwizard extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.webwizard";
    }

    @JsonProperty("name")
    protected String name;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("webwizardidunique")
    protected String webwizardidunique;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("wizardpageheight")
    protected Integer wizardpageheight;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("isstaticpagesequence")
    protected Boolean isstaticpagesequence;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("accessprivileges")
    protected String accessprivileges;

    @JsonProperty("titleresourcestring")
    protected String titleresourcestring;

    @JsonProperty("wizardpagewidth")
    protected Integer wizardpagewidth;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("webwizardid")
    protected String webwizardid;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("startpagesequencenumber")
    protected Integer startpagesequencenumber;

    @JsonProperty("solutionid")
    protected String solutionid;

    protected Webwizard() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWebwizard() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private OffsetDateTime createdon;
        private String _createdonbehalfby_value;
        private Integer componentstate;
        private String webwizardidunique;
        private String _organizationid_value;
        private Integer wizardpageheight;
        private OffsetDateTime modifiedon;
        private Long versionnumber;
        private Boolean isstaticpagesequence;
        private Boolean ismanaged;
        private String _modifiedby_value;
        private String _modifiedonbehalfby_value;
        private String accessprivileges;
        private String titleresourcestring;
        private Integer wizardpagewidth;
        private OffsetDateTime overwritetime;
        private String webwizardid;
        private String introducedversion;
        private String _createdby_value;
        private Integer startpagesequencenumber;
        private String solutionid;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder webwizardidunique(String webwizardidunique) {
            this.webwizardidunique = webwizardidunique;
            this.changedFields = changedFields.add("webwizardidunique");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder wizardpageheight(Integer wizardpageheight) {
            this.wizardpageheight = wizardpageheight;
            this.changedFields = changedFields.add("wizardpageheight");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder isstaticpagesequence(Boolean isstaticpagesequence) {
            this.isstaticpagesequence = isstaticpagesequence;
            this.changedFields = changedFields.add("isstaticpagesequence");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder accessprivileges(String accessprivileges) {
            this.accessprivileges = accessprivileges;
            this.changedFields = changedFields.add("accessprivileges");
            return this;
        }

        public Builder titleresourcestring(String titleresourcestring) {
            this.titleresourcestring = titleresourcestring;
            this.changedFields = changedFields.add("titleresourcestring");
            return this;
        }

        public Builder wizardpagewidth(Integer wizardpagewidth) {
            this.wizardpagewidth = wizardpagewidth;
            this.changedFields = changedFields.add("wizardpagewidth");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder webwizardid(String webwizardid) {
            this.webwizardid = webwizardid;
            this.changedFields = changedFields.add("webwizardid");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder startpagesequencenumber(Integer startpagesequencenumber) {
            this.startpagesequencenumber = startpagesequencenumber;
            this.changedFields = changedFields.add("startpagesequencenumber");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Webwizard build() {
            Webwizard _x = new Webwizard();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.webwizard";
            _x.name = name;
            _x.createdon = createdon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.componentstate = componentstate;
            _x.webwizardidunique = webwizardidunique;
            _x._organizationid_value = _organizationid_value;
            _x.wizardpageheight = wizardpageheight;
            _x.modifiedon = modifiedon;
            _x.versionnumber = versionnumber;
            _x.isstaticpagesequence = isstaticpagesequence;
            _x.ismanaged = ismanaged;
            _x._modifiedby_value = _modifiedby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.accessprivileges = accessprivileges;
            _x.titleresourcestring = titleresourcestring;
            _x.wizardpagewidth = wizardpagewidth;
            _x.overwritetime = overwritetime;
            _x.webwizardid = webwizardid;
            _x.introducedversion = introducedversion;
            _x._createdby_value = _createdby_value;
            _x.startpagesequencenumber = startpagesequencenumber;
            _x.solutionid = solutionid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && webwizardid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(webwizardid.toString()));
        }
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Webwizard withName(String name) {
        Checks.checkIsAscii(name);
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.name = name;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Webwizard withCreatedon(OffsetDateTime createdon) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Webwizard with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Webwizard withComponentstate(Integer componentstate) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="webwizardidunique")
    @JsonIgnore
    public Optional<String> getWebwizardidunique() {
        return Optional.ofNullable(webwizardidunique);
    }

    public Webwizard withWebwizardidunique(String webwizardidunique) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("webwizardidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.webwizardidunique = webwizardidunique;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Webwizard with_organizationid_value(String _organizationid_value) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="wizardpageheight")
    @JsonIgnore
    public Optional<Integer> getWizardpageheight() {
        return Optional.ofNullable(wizardpageheight);
    }

    public Webwizard withWizardpageheight(Integer wizardpageheight) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("wizardpageheight");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.wizardpageheight = wizardpageheight;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Webwizard withModifiedon(OffsetDateTime modifiedon) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Webwizard withVersionnumber(Long versionnumber) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="isstaticpagesequence")
    @JsonIgnore
    public Optional<Boolean> getIsstaticpagesequence() {
        return Optional.ofNullable(isstaticpagesequence);
    }

    public Webwizard withIsstaticpagesequence(Boolean isstaticpagesequence) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("isstaticpagesequence");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.isstaticpagesequence = isstaticpagesequence;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Webwizard withIsmanaged(Boolean ismanaged) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Webwizard with_modifiedby_value(String _modifiedby_value) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Webwizard with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="accessprivileges")
    @JsonIgnore
    public Optional<String> getAccessprivileges() {
        return Optional.ofNullable(accessprivileges);
    }

    public Webwizard withAccessprivileges(String accessprivileges) {
        Checks.checkIsAscii(accessprivileges);
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("accessprivileges");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.accessprivileges = accessprivileges;
        return _x;
    }

    @Property(name="titleresourcestring")
    @JsonIgnore
    public Optional<String> getTitleresourcestring() {
        return Optional.ofNullable(titleresourcestring);
    }

    public Webwizard withTitleresourcestring(String titleresourcestring) {
        Checks.checkIsAscii(titleresourcestring);
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("titleresourcestring");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.titleresourcestring = titleresourcestring;
        return _x;
    }

    @Property(name="wizardpagewidth")
    @JsonIgnore
    public Optional<Integer> getWizardpagewidth() {
        return Optional.ofNullable(wizardpagewidth);
    }

    public Webwizard withWizardpagewidth(Integer wizardpagewidth) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("wizardpagewidth");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.wizardpagewidth = wizardpagewidth;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Webwizard withOverwritetime(OffsetDateTime overwritetime) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="webwizardid")
    @JsonIgnore
    public Optional<String> getWebwizardid() {
        return Optional.ofNullable(webwizardid);
    }

    public Webwizard withWebwizardid(String webwizardid) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("webwizardid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.webwizardid = webwizardid;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Webwizard withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Webwizard with_createdby_value(String _createdby_value) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="startpagesequencenumber")
    @JsonIgnore
    public Optional<Integer> getStartpagesequencenumber() {
        return Optional.ofNullable(startpagesequencenumber);
    }

    public Webwizard withStartpagesequencenumber(Integer startpagesequencenumber) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("startpagesequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.startpagesequencenumber = startpagesequencenumber;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Webwizard withSolutionid(String solutionid) {
        Webwizard _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webwizard");
        _x.solutionid = solutionid;
        return _x;
    }

    public Webwizard withUnmappedField(String name, String value) {
        Webwizard _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Webwizard patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Webwizard _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Webwizard put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Webwizard _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Webwizard _copy() {
        Webwizard _x = new Webwizard();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x.createdon = createdon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.componentstate = componentstate;
        _x.webwizardidunique = webwizardidunique;
        _x._organizationid_value = _organizationid_value;
        _x.wizardpageheight = wizardpageheight;
        _x.modifiedon = modifiedon;
        _x.versionnumber = versionnumber;
        _x.isstaticpagesequence = isstaticpagesequence;
        _x.ismanaged = ismanaged;
        _x._modifiedby_value = _modifiedby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.accessprivileges = accessprivileges;
        _x.titleresourcestring = titleresourcestring;
        _x.wizardpagewidth = wizardpagewidth;
        _x.overwritetime = overwritetime;
        _x.webwizardid = webwizardid;
        _x.introducedversion = introducedversion;
        _x._createdby_value = _createdby_value;
        _x.startpagesequencenumber = startpagesequencenumber;
        _x.solutionid = solutionid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Webwizard[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("webwizardidunique=");
        b.append(this.webwizardidunique);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("wizardpageheight=");
        b.append(this.wizardpageheight);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("isstaticpagesequence=");
        b.append(this.isstaticpagesequence);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("accessprivileges=");
        b.append(this.accessprivileges);
        b.append(", ");
        b.append("titleresourcestring=");
        b.append(this.titleresourcestring);
        b.append(", ");
        b.append("wizardpagewidth=");
        b.append(this.wizardpagewidth);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("webwizardid=");
        b.append(this.webwizardid);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("startpagesequencenumber=");
        b.append(this.startpagesequencenumber);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
