package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "systemuserid", 
    "licenseid", 
    "systemuserlicenseid"})
@JsonInclude(Include.NON_NULL)
public class Systemuserlicenses extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.systemuserlicenses";
    }

    @JsonProperty("systemuserid")
    protected String systemuserid;

    @JsonProperty("licenseid")
    protected String licenseid;

    @JsonProperty("systemuserlicenseid")
    protected String systemuserlicenseid;

    protected Systemuserlicenses() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSystemuserlicenses() {
        return new Builder();
    }

    public static final class Builder {
        private String systemuserid;
        private String licenseid;
        private String systemuserlicenseid;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder systemuserid(String systemuserid) {
            this.systemuserid = systemuserid;
            this.changedFields = changedFields.add("systemuserid");
            return this;
        }

        public Builder licenseid(String licenseid) {
            this.licenseid = licenseid;
            this.changedFields = changedFields.add("licenseid");
            return this;
        }

        public Builder systemuserlicenseid(String systemuserlicenseid) {
            this.systemuserlicenseid = systemuserlicenseid;
            this.changedFields = changedFields.add("systemuserlicenseid");
            return this;
        }

        public Systemuserlicenses build() {
            Systemuserlicenses _x = new Systemuserlicenses();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.systemuserlicenses";
            _x.systemuserid = systemuserid;
            _x.licenseid = licenseid;
            _x.systemuserlicenseid = systemuserlicenseid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && systemuserlicenseid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(systemuserlicenseid.toString()));
        }
    }

    @Property(name="systemuserid")
    @JsonIgnore
    public Optional<String> getSystemuserid() {
        return Optional.ofNullable(systemuserid);
    }

    public Systemuserlicenses withSystemuserid(String systemuserid) {
        Systemuserlicenses _x = _copy();
        _x.changedFields = changedFields.add("systemuserid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.systemuserlicenses");
        _x.systemuserid = systemuserid;
        return _x;
    }

    @Property(name="licenseid")
    @JsonIgnore
    public Optional<String> getLicenseid() {
        return Optional.ofNullable(licenseid);
    }

    public Systemuserlicenses withLicenseid(String licenseid) {
        Systemuserlicenses _x = _copy();
        _x.changedFields = changedFields.add("licenseid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.systemuserlicenses");
        _x.licenseid = licenseid;
        return _x;
    }

    @Property(name="systemuserlicenseid")
    @JsonIgnore
    public Optional<String> getSystemuserlicenseid() {
        return Optional.ofNullable(systemuserlicenseid);
    }

    public Systemuserlicenses withSystemuserlicenseid(String systemuserlicenseid) {
        Systemuserlicenses _x = _copy();
        _x.changedFields = changedFields.add("systemuserlicenseid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.systemuserlicenses");
        _x.systemuserlicenseid = systemuserlicenseid;
        return _x;
    }

    public Systemuserlicenses withUnmappedField(String name, String value) {
        Systemuserlicenses _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Systemuserlicenses patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Systemuserlicenses _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Systemuserlicenses put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Systemuserlicenses _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Systemuserlicenses _copy() {
        Systemuserlicenses _x = new Systemuserlicenses();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.systemuserid = systemuserid;
        _x.licenseid = licenseid;
        _x.systemuserlicenseid = systemuserlicenseid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Systemuserlicenses[");
        b.append("systemuserid=");
        b.append(this.systemuserid);
        b.append(", ");
        b.append("licenseid=");
        b.append(this.licenseid);
        b.append(", ");
        b.append("systemuserlicenseid=");
        b.append(this.systemuserlicenseid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
