package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.WebresourceRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "presentationdescription", 
    "overwritetime", 
    "canbedeleted", 
    "_createdby_value", 
    "type", 
    "modifiedon", 
    "_modifiedby_value", 
    "savedqueryvisualizationidunique", 
    "description", 
    "introducedversion", 
    "charttype", 
    "componentstate", 
    "datadescription", 
    "primaryentitytypecode", 
    "ismanaged", 
    "_organizationid_value", 
    "_modifiedonbehalfby_value", 
    "versionnumber", 
    "savedqueryvisualizationid", 
    "_webresourceid_value", 
    "createdon", 
    "name", 
    "isdefault", 
    "iscustomizable", 
    "_createdonbehalfby_value", 
    "solutionid"})
@JsonInclude(Include.NON_NULL)
public class Savedqueryvisualization extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.savedqueryvisualization";
    }

    @JsonProperty("presentationdescription")
    protected String presentationdescription;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("canbedeleted")
    protected BooleanManagedProperty canbedeleted;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("type")
    protected Integer type;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("savedqueryvisualizationidunique")
    protected String savedqueryvisualizationidunique;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("charttype")
    protected Integer charttype;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("datadescription")
    protected String datadescription;

    @JsonProperty("primaryentitytypecode")
    protected String primaryentitytypecode;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("savedqueryvisualizationid")
    protected String savedqueryvisualizationid;

    @JsonProperty("_webresourceid_value")
    protected String _webresourceid_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("isdefault")
    protected Boolean isdefault;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("solutionid")
    protected String solutionid;

    protected Savedqueryvisualization() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSavedqueryvisualization() {
        return new Builder();
    }

    public static final class Builder {
        private String presentationdescription;
        private OffsetDateTime overwritetime;
        private BooleanManagedProperty canbedeleted;
        private String _createdby_value;
        private Integer type;
        private OffsetDateTime modifiedon;
        private String _modifiedby_value;
        private String savedqueryvisualizationidunique;
        private String description;
        private String introducedversion;
        private Integer charttype;
        private Integer componentstate;
        private String datadescription;
        private String primaryentitytypecode;
        private Boolean ismanaged;
        private String _organizationid_value;
        private String _modifiedonbehalfby_value;
        private Long versionnumber;
        private String savedqueryvisualizationid;
        private String _webresourceid_value;
        private OffsetDateTime createdon;
        private String name;
        private Boolean isdefault;
        private BooleanManagedProperty iscustomizable;
        private String _createdonbehalfby_value;
        private String solutionid;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder presentationdescription(String presentationdescription) {
            this.presentationdescription = presentationdescription;
            this.changedFields = changedFields.add("presentationdescription");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder canbedeleted(BooleanManagedProperty canbedeleted) {
            this.canbedeleted = canbedeleted;
            this.changedFields = changedFields.add("canbedeleted");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder type(Integer type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder savedqueryvisualizationidunique(String savedqueryvisualizationidunique) {
            this.savedqueryvisualizationidunique = savedqueryvisualizationidunique;
            this.changedFields = changedFields.add("savedqueryvisualizationidunique");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder charttype(Integer charttype) {
            this.charttype = charttype;
            this.changedFields = changedFields.add("charttype");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder datadescription(String datadescription) {
            this.datadescription = datadescription;
            this.changedFields = changedFields.add("datadescription");
            return this;
        }

        public Builder primaryentitytypecode(String primaryentitytypecode) {
            this.primaryentitytypecode = primaryentitytypecode;
            this.changedFields = changedFields.add("primaryentitytypecode");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder savedqueryvisualizationid(String savedqueryvisualizationid) {
            this.savedqueryvisualizationid = savedqueryvisualizationid;
            this.changedFields = changedFields.add("savedqueryvisualizationid");
            return this;
        }

        public Builder _webresourceid_value(String _webresourceid_value) {
            this._webresourceid_value = _webresourceid_value;
            this.changedFields = changedFields.add("_webresourceid_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder isdefault(Boolean isdefault) {
            this.isdefault = isdefault;
            this.changedFields = changedFields.add("isdefault");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Savedqueryvisualization build() {
            Savedqueryvisualization _x = new Savedqueryvisualization();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.savedqueryvisualization";
            _x.presentationdescription = presentationdescription;
            _x.overwritetime = overwritetime;
            _x.canbedeleted = canbedeleted;
            _x._createdby_value = _createdby_value;
            _x.type = type;
            _x.modifiedon = modifiedon;
            _x._modifiedby_value = _modifiedby_value;
            _x.savedqueryvisualizationidunique = savedqueryvisualizationidunique;
            _x.description = description;
            _x.introducedversion = introducedversion;
            _x.charttype = charttype;
            _x.componentstate = componentstate;
            _x.datadescription = datadescription;
            _x.primaryentitytypecode = primaryentitytypecode;
            _x.ismanaged = ismanaged;
            _x._organizationid_value = _organizationid_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.versionnumber = versionnumber;
            _x.savedqueryvisualizationid = savedqueryvisualizationid;
            _x._webresourceid_value = _webresourceid_value;
            _x.createdon = createdon;
            _x.name = name;
            _x.isdefault = isdefault;
            _x.iscustomizable = iscustomizable;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.solutionid = solutionid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && savedqueryvisualizationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(savedqueryvisualizationid.toString()));
        }
    }

    @Property(name="presentationdescription")
    @JsonIgnore
    public Optional<String> getPresentationdescription() {
        return Optional.ofNullable(presentationdescription);
    }

    public Savedqueryvisualization withPresentationdescription(String presentationdescription) {
        Checks.checkIsAscii(presentationdescription);
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("presentationdescription");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.presentationdescription = presentationdescription;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Savedqueryvisualization withOverwritetime(OffsetDateTime overwritetime) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="canbedeleted")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanbedeleted() {
        return Optional.ofNullable(canbedeleted);
    }

    public Savedqueryvisualization withCanbedeleted(BooleanManagedProperty canbedeleted) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("canbedeleted");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.canbedeleted = canbedeleted;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Savedqueryvisualization with_createdby_value(String _createdby_value) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<Integer> getType() {
        return Optional.ofNullable(type);
    }

    public Savedqueryvisualization withType(Integer type) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.type = type;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Savedqueryvisualization withModifiedon(OffsetDateTime modifiedon) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Savedqueryvisualization with_modifiedby_value(String _modifiedby_value) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="savedqueryvisualizationidunique")
    @JsonIgnore
    public Optional<String> getSavedqueryvisualizationidunique() {
        return Optional.ofNullable(savedqueryvisualizationidunique);
    }

    public Savedqueryvisualization withSavedqueryvisualizationidunique(String savedqueryvisualizationidunique) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("savedqueryvisualizationidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.savedqueryvisualizationidunique = savedqueryvisualizationidunique;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Savedqueryvisualization withDescription(String description) {
        Checks.checkIsAscii(description);
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.description = description;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Savedqueryvisualization withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="charttype")
    @JsonIgnore
    public Optional<Integer> getCharttype() {
        return Optional.ofNullable(charttype);
    }

    public Savedqueryvisualization withCharttype(Integer charttype) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("charttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.charttype = charttype;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Savedqueryvisualization withComponentstate(Integer componentstate) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="datadescription")
    @JsonIgnore
    public Optional<String> getDatadescription() {
        return Optional.ofNullable(datadescription);
    }

    public Savedqueryvisualization withDatadescription(String datadescription) {
        Checks.checkIsAscii(datadescription);
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("datadescription");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.datadescription = datadescription;
        return _x;
    }

    @Property(name="primaryentitytypecode")
    @JsonIgnore
    public Optional<String> getPrimaryentitytypecode() {
        return Optional.ofNullable(primaryentitytypecode);
    }

    public Savedqueryvisualization withPrimaryentitytypecode(String primaryentitytypecode) {
        Checks.checkIsAscii(primaryentitytypecode);
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("primaryentitytypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.primaryentitytypecode = primaryentitytypecode;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Savedqueryvisualization withIsmanaged(Boolean ismanaged) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Savedqueryvisualization with_organizationid_value(String _organizationid_value) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Savedqueryvisualization with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Savedqueryvisualization withVersionnumber(Long versionnumber) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="savedqueryvisualizationid")
    @JsonIgnore
    public Optional<String> getSavedqueryvisualizationid() {
        return Optional.ofNullable(savedqueryvisualizationid);
    }

    public Savedqueryvisualization withSavedqueryvisualizationid(String savedqueryvisualizationid) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("savedqueryvisualizationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.savedqueryvisualizationid = savedqueryvisualizationid;
        return _x;
    }

    @Property(name="_webresourceid_value")
    @JsonIgnore
    public Optional<String> get_webresourceid_value() {
        return Optional.ofNullable(_webresourceid_value);
    }

    public Savedqueryvisualization with_webresourceid_value(String _webresourceid_value) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("_webresourceid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x._webresourceid_value = _webresourceid_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Savedqueryvisualization withCreatedon(OffsetDateTime createdon) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Savedqueryvisualization withName(String name) {
        Checks.checkIsAscii(name);
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.name = name;
        return _x;
    }

    @Property(name="isdefault")
    @JsonIgnore
    public Optional<Boolean> getIsdefault() {
        return Optional.ofNullable(isdefault);
    }

    public Savedqueryvisualization withIsdefault(Boolean isdefault) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("isdefault");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.isdefault = isdefault;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Savedqueryvisualization withIscustomizable(BooleanManagedProperty iscustomizable) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Savedqueryvisualization with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Savedqueryvisualization withSolutionid(String solutionid) {
        Savedqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedqueryvisualization");
        _x.solutionid = solutionid;
        return _x;
    }

    public Savedqueryvisualization withUnmappedField(String name, String value) {
        Savedqueryvisualization _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="SavedQueryVisualization_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getSavedQueryVisualization_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SavedQueryVisualization_SyncErrors"), RequestHelper.getValue(unmappedFields, "SavedQueryVisualization_SyncErrors"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="webresourceid")
    @JsonIgnore
    public WebresourceRequest getWebresourceid() {
        return new WebresourceRequest(contextPath.addSegment("webresourceid"), RequestHelper.getValue(unmappedFields, "webresourceid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Savedqueryvisualization patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Savedqueryvisualization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Savedqueryvisualization put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Savedqueryvisualization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Savedqueryvisualization _copy() {
        Savedqueryvisualization _x = new Savedqueryvisualization();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.presentationdescription = presentationdescription;
        _x.overwritetime = overwritetime;
        _x.canbedeleted = canbedeleted;
        _x._createdby_value = _createdby_value;
        _x.type = type;
        _x.modifiedon = modifiedon;
        _x._modifiedby_value = _modifiedby_value;
        _x.savedqueryvisualizationidunique = savedqueryvisualizationidunique;
        _x.description = description;
        _x.introducedversion = introducedversion;
        _x.charttype = charttype;
        _x.componentstate = componentstate;
        _x.datadescription = datadescription;
        _x.primaryentitytypecode = primaryentitytypecode;
        _x.ismanaged = ismanaged;
        _x._organizationid_value = _organizationid_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.versionnumber = versionnumber;
        _x.savedqueryvisualizationid = savedqueryvisualizationid;
        _x._webresourceid_value = _webresourceid_value;
        _x.createdon = createdon;
        _x.name = name;
        _x.isdefault = isdefault;
        _x.iscustomizable = iscustomizable;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.solutionid = solutionid;
        return _x;
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Savedqueryvisualization> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Savedqueryvisualization>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Savedqueryvisualization.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Savedqueryvisualization[");
        b.append("presentationdescription=");
        b.append(this.presentationdescription);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("canbedeleted=");
        b.append(this.canbedeleted);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("savedqueryvisualizationidunique=");
        b.append(this.savedqueryvisualizationidunique);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("charttype=");
        b.append(this.charttype);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("datadescription=");
        b.append(this.datadescription);
        b.append(", ");
        b.append("primaryentitytypecode=");
        b.append(this.primaryentitytypecode);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("savedqueryvisualizationid=");
        b.append(this.savedqueryvisualizationid);
        b.append(", ");
        b.append("_webresourceid_value=");
        b.append(this._webresourceid_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("isdefault=");
        b.append(this.isdefault);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
