package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aimodelRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_createdonbehalfby_value", 
    "_owningbusinessunit_value", 
    "_modifiedonbehalfby_value", 
    "utcconversiontimezonecode", 
    "msdyn_name", 
    "versionnumber", 
    "statecode", 
    "_ownerid_value", 
    "statuscode", 
    "importsequencenumber", 
    "_msdyn_aimodelid_value", 
    "timezoneruleversionnumber", 
    "overriddencreatedon", 
    "createdon", 
    "_createdby_value", 
    "modifiedon", 
    "msdyn_aibdatasetscontainerid", 
    "_owningteam_value", 
    "_modifiedby_value", 
    "_owninguser_value"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_aibdatasetscontainer extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer";
    }

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_msdyn_aimodelid_value")
    protected String _msdyn_aimodelid_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("msdyn_aibdatasetscontainerid")
    protected String msdyn_aibdatasetscontainerid;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    protected Msdyn_aibdatasetscontainer() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_aibdatasetscontainer() {
        return new Builder();
    }

    public static final class Builder {
        private String _createdonbehalfby_value;
        private String _owningbusinessunit_value;
        private String _modifiedonbehalfby_value;
        private Integer utcconversiontimezonecode;
        private String msdyn_name;
        private Long versionnumber;
        private Integer statecode;
        private String _ownerid_value;
        private Integer statuscode;
        private Integer importsequencenumber;
        private String _msdyn_aimodelid_value;
        private Integer timezoneruleversionnumber;
        private OffsetDateTime overriddencreatedon;
        private OffsetDateTime createdon;
        private String _createdby_value;
        private OffsetDateTime modifiedon;
        private String msdyn_aibdatasetscontainerid;
        private String _owningteam_value;
        private String _modifiedby_value;
        private String _owninguser_value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _msdyn_aimodelid_value(String _msdyn_aimodelid_value) {
            this._msdyn_aimodelid_value = _msdyn_aimodelid_value;
            this.changedFields = changedFields.add("_msdyn_aimodelid_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder msdyn_aibdatasetscontainerid(String msdyn_aibdatasetscontainerid) {
            this.msdyn_aibdatasetscontainerid = msdyn_aibdatasetscontainerid;
            this.changedFields = changedFields.add("msdyn_aibdatasetscontainerid");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Msdyn_aibdatasetscontainer build() {
            Msdyn_aibdatasetscontainer _x = new Msdyn_aibdatasetscontainer();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer";
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.msdyn_name = msdyn_name;
            _x.versionnumber = versionnumber;
            _x.statecode = statecode;
            _x._ownerid_value = _ownerid_value;
            _x.statuscode = statuscode;
            _x.importsequencenumber = importsequencenumber;
            _x._msdyn_aimodelid_value = _msdyn_aimodelid_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.overriddencreatedon = overriddencreatedon;
            _x.createdon = createdon;
            _x._createdby_value = _createdby_value;
            _x.modifiedon = modifiedon;
            _x.msdyn_aibdatasetscontainerid = msdyn_aibdatasetscontainerid;
            _x._owningteam_value = _owningteam_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._owninguser_value = _owninguser_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_aibdatasetscontainerid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_aibdatasetscontainerid.toString()));
        }
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_aibdatasetscontainer with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_aibdatasetscontainer with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_aibdatasetscontainer with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_aibdatasetscontainer withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_aibdatasetscontainer withMsdyn_name(String msdyn_name) {
        Checks.checkIsAscii(msdyn_name);
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_aibdatasetscontainer withVersionnumber(Long versionnumber) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_aibdatasetscontainer withStatecode(Integer statecode) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_aibdatasetscontainer with_ownerid_value(String _ownerid_value) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_aibdatasetscontainer withStatuscode(Integer statuscode) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_aibdatasetscontainer withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_msdyn_aimodelid_value")
    @JsonIgnore
    public Optional<String> get_msdyn_aimodelid_value() {
        return Optional.ofNullable(_msdyn_aimodelid_value);
    }

    public Msdyn_aibdatasetscontainer with_msdyn_aimodelid_value(String _msdyn_aimodelid_value) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_aimodelid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x._msdyn_aimodelid_value = _msdyn_aimodelid_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_aibdatasetscontainer withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_aibdatasetscontainer withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_aibdatasetscontainer withCreatedon(OffsetDateTime createdon) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_aibdatasetscontainer with_createdby_value(String _createdby_value) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_aibdatasetscontainer withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="msdyn_aibdatasetscontainerid")
    @JsonIgnore
    public Optional<String> getMsdyn_aibdatasetscontainerid() {
        return Optional.ofNullable(msdyn_aibdatasetscontainerid);
    }

    public Msdyn_aibdatasetscontainer withMsdyn_aibdatasetscontainerid(String msdyn_aibdatasetscontainerid) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("msdyn_aibdatasetscontainerid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x.msdyn_aibdatasetscontainerid = msdyn_aibdatasetscontainerid;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_aibdatasetscontainer with_owningteam_value(String _owningteam_value) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_aibdatasetscontainer with_modifiedby_value(String _modifiedby_value) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_aibdatasetscontainer with_owninguser_value(String _owninguser_value) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aibdatasetscontainer");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    public Msdyn_aibdatasetscontainer withUnmappedField(String name, String value) {
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_aibdatasetscontainer_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_aibdatasetscontainer_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_aibdatasetscontainer_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_aibdatasetscontainer_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_aibdatasetscontainer_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_aibdatasetscontainer_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_aibdatasetscontainer_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_aibdatasetscontainer_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_aibdatasetscontainer_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_aibdatasetscontainer_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_aibdatasetscontainer_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_aibdatasetscontainer_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_aibdatasetscontainer_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_aibdatasetscontainer_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_aibdatasetscontainer_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_aibdatasetscontainer_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_aibdatasetscontainer_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_aibdatasetscontainer_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_aibdatasetscontainer_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_aibdatasetscontainer_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_aibdatasetscontainer_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_aibdatasetscontainer_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_aibdatasetscontainer_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_aibdatasetscontainer_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_AIBDataset_msdyn_AIBDatasetsContain")
    @JsonIgnore
    public Msdyn_aibdatasetCollectionRequest getMsdyn_AIBDataset_msdyn_AIBDatasetsContain() {
        return new Msdyn_aibdatasetCollectionRequest(
                        contextPath.addSegment("msdyn_AIBDataset_msdyn_AIBDatasetsContain"), RequestHelper.getValue(unmappedFields, "msdyn_AIBDataset_msdyn_AIBDatasetsContain"));
    }

    @NavigationProperty(name="msdyn_AIModelId")
    @JsonIgnore
    public Msdyn_aimodelRequest getMsdyn_AIModelId() {
        return new Msdyn_aimodelRequest(contextPath.addSegment("msdyn_AIModelId"), RequestHelper.getValue(unmappedFields, "msdyn_AIModelId"));
    }

    @NavigationProperty(name="msdyn_AIBFile_msdyn_AIBDatasetsCont")
    @JsonIgnore
    public Msdyn_aibfileCollectionRequest getMsdyn_AIBFile_msdyn_AIBDatasetsCont() {
        return new Msdyn_aibfileCollectionRequest(
                        contextPath.addSegment("msdyn_AIBFile_msdyn_AIBDatasetsCont"), RequestHelper.getValue(unmappedFields, "msdyn_AIBFile_msdyn_AIBDatasetsCont"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aibdatasetscontainer patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aibdatasetscontainer put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aibdatasetscontainer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_aibdatasetscontainer _copy() {
        Msdyn_aibdatasetscontainer _x = new Msdyn_aibdatasetscontainer();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.msdyn_name = msdyn_name;
        _x.versionnumber = versionnumber;
        _x.statecode = statecode;
        _x._ownerid_value = _ownerid_value;
        _x.statuscode = statuscode;
        _x.importsequencenumber = importsequencenumber;
        _x._msdyn_aimodelid_value = _msdyn_aimodelid_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.overriddencreatedon = overriddencreatedon;
        _x.createdon = createdon;
        _x._createdby_value = _createdby_value;
        _x.modifiedon = modifiedon;
        _x.msdyn_aibdatasetscontainerid = msdyn_aibdatasetscontainerid;
        _x._owningteam_value = _owningteam_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_aibdatasetscontainer[");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_msdyn_aimodelid_value=");
        b.append(this._msdyn_aimodelid_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("msdyn_aibdatasetscontainerid=");
        b.append(this.msdyn_aibdatasetscontainerid);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
