package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.request.KbarticleRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_modifiedonbehalfby_value", 
    "createdon", 
    "modifiedon", 
    "_modifiedby_value", 
    "organizationid", 
    "kbarticlecommentid", 
    "_createdonbehalfby_value", 
    "_kbarticleid_value", 
    "title", 
    "versionnumber", 
    "_createdby_value", 
    "commenttext"})
@JsonInclude(Include.NON_NULL)
public class Kbarticlecomment extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.kbarticlecomment";
    }

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("organizationid")
    protected String organizationid;

    @JsonProperty("kbarticlecommentid")
    protected String kbarticlecommentid;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_kbarticleid_value")
    protected String _kbarticleid_value;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("commenttext")
    protected String commenttext;

    protected Kbarticlecomment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderKbarticlecomment() {
        return new Builder();
    }

    public static final class Builder {
        private String _modifiedonbehalfby_value;
        private OffsetDateTime createdon;
        private OffsetDateTime modifiedon;
        private String _modifiedby_value;
        private String organizationid;
        private String kbarticlecommentid;
        private String _createdonbehalfby_value;
        private String _kbarticleid_value;
        private String title;
        private Long versionnumber;
        private String _createdby_value;
        private String commenttext;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder organizationid(String organizationid) {
            this.organizationid = organizationid;
            this.changedFields = changedFields.add("organizationid");
            return this;
        }

        public Builder kbarticlecommentid(String kbarticlecommentid) {
            this.kbarticlecommentid = kbarticlecommentid;
            this.changedFields = changedFields.add("kbarticlecommentid");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _kbarticleid_value(String _kbarticleid_value) {
            this._kbarticleid_value = _kbarticleid_value;
            this.changedFields = changedFields.add("_kbarticleid_value");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder commenttext(String commenttext) {
            this.commenttext = commenttext;
            this.changedFields = changedFields.add("commenttext");
            return this;
        }

        public Kbarticlecomment build() {
            Kbarticlecomment _x = new Kbarticlecomment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.kbarticlecomment";
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.createdon = createdon;
            _x.modifiedon = modifiedon;
            _x._modifiedby_value = _modifiedby_value;
            _x.organizationid = organizationid;
            _x.kbarticlecommentid = kbarticlecommentid;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._kbarticleid_value = _kbarticleid_value;
            _x.title = title;
            _x.versionnumber = versionnumber;
            _x._createdby_value = _createdby_value;
            _x.commenttext = commenttext;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && kbarticlecommentid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(kbarticlecommentid.toString()));
        }
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Kbarticlecomment with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Kbarticlecomment _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticlecomment");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Kbarticlecomment withCreatedon(OffsetDateTime createdon) {
        Kbarticlecomment _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticlecomment");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Kbarticlecomment withModifiedon(OffsetDateTime modifiedon) {
        Kbarticlecomment _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticlecomment");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Kbarticlecomment with_modifiedby_value(String _modifiedby_value) {
        Kbarticlecomment _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticlecomment");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="organizationid")
    @JsonIgnore
    public Optional<String> getOrganizationid() {
        return Optional.ofNullable(organizationid);
    }

    public Kbarticlecomment withOrganizationid(String organizationid) {
        Kbarticlecomment _x = _copy();
        _x.changedFields = changedFields.add("organizationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticlecomment");
        _x.organizationid = organizationid;
        return _x;
    }

    @Property(name="kbarticlecommentid")
    @JsonIgnore
    public Optional<String> getKbarticlecommentid() {
        return Optional.ofNullable(kbarticlecommentid);
    }

    public Kbarticlecomment withKbarticlecommentid(String kbarticlecommentid) {
        Kbarticlecomment _x = _copy();
        _x.changedFields = changedFields.add("kbarticlecommentid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticlecomment");
        _x.kbarticlecommentid = kbarticlecommentid;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Kbarticlecomment with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Kbarticlecomment _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticlecomment");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_kbarticleid_value")
    @JsonIgnore
    public Optional<String> get_kbarticleid_value() {
        return Optional.ofNullable(_kbarticleid_value);
    }

    public Kbarticlecomment with_kbarticleid_value(String _kbarticleid_value) {
        Kbarticlecomment _x = _copy();
        _x.changedFields = changedFields.add("_kbarticleid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticlecomment");
        _x._kbarticleid_value = _kbarticleid_value;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public Kbarticlecomment withTitle(String title) {
        Checks.checkIsAscii(title);
        Kbarticlecomment _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticlecomment");
        _x.title = title;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Kbarticlecomment withVersionnumber(Long versionnumber) {
        Kbarticlecomment _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticlecomment");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Kbarticlecomment with_createdby_value(String _createdby_value) {
        Kbarticlecomment _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticlecomment");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="commenttext")
    @JsonIgnore
    public Optional<String> getCommenttext() {
        return Optional.ofNullable(commenttext);
    }

    public Kbarticlecomment withCommenttext(String commenttext) {
        Checks.checkIsAscii(commenttext);
        Kbarticlecomment _x = _copy();
        _x.changedFields = changedFields.add("commenttext");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticlecomment");
        _x.commenttext = commenttext;
        return _x;
    }

    public Kbarticlecomment withUnmappedField(String name, String value) {
        Kbarticlecomment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="KbArticleComment_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getKbArticleComment_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("KbArticleComment_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "KbArticleComment_BulkDeleteFailures"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="KbArticleComment_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getKbArticleComment_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("KbArticleComment_AsyncOperations"), RequestHelper.getValue(unmappedFields, "KbArticleComment_AsyncOperations"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="kbarticleid")
    @JsonIgnore
    public KbarticleRequest getKbarticleid() {
        return new KbarticleRequest(contextPath.addSegment("kbarticleid"), RequestHelper.getValue(unmappedFields, "kbarticleid"));
    }

    @NavigationProperty(name="KbArticleComment_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getKbArticleComment_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("KbArticleComment_ProcessSessions"), RequestHelper.getValue(unmappedFields, "KbArticleComment_ProcessSessions"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Kbarticlecomment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Kbarticlecomment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Kbarticlecomment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Kbarticlecomment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Kbarticlecomment _copy() {
        Kbarticlecomment _x = new Kbarticlecomment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.createdon = createdon;
        _x.modifiedon = modifiedon;
        _x._modifiedby_value = _modifiedby_value;
        _x.organizationid = organizationid;
        _x.kbarticlecommentid = kbarticlecommentid;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._kbarticleid_value = _kbarticleid_value;
        _x.title = title;
        _x.versionnumber = versionnumber;
        _x._createdby_value = _createdby_value;
        _x.commenttext = commenttext;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Kbarticlecomment[");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("organizationid=");
        b.append(this.organizationid);
        b.append(", ");
        b.append("kbarticlecommentid=");
        b.append(this.kbarticlecommentid);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_kbarticleid_value=");
        b.append(this._kbarticleid_value);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("commenttext=");
        b.append(this.commenttext);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
