package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_teamCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_owninguser_value", 
    "createdon", 
    "ggw_sendgrid_new_applicants_id", 
    "modifiedon", 
    "_createdonbehalfby_value", 
    "_owningbusinessunit_value", 
    "ggw_eventid", 
    "versionnumber", 
    "utcconversiontimezonecode", 
    "ggw_name", 
    "_owningteam_value", 
    "_modifiedby_value", 
    "ggw_sendgrid_id", 
    "_ownerid_value", 
    "overriddencreatedon", 
    "statuscode", 
    "importsequencenumber", 
    "_createdby_value", 
    "statecode", 
    "timezoneruleversionnumber", 
    "_modifiedonbehalfby_value"})
@JsonInclude(Include.NON_NULL)
public class Ggw_event extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ggw_event";
    }

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("ggw_sendgrid_new_applicants_id")
    protected String ggw_sendgrid_new_applicants_id;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("ggw_eventid")
    protected String ggw_eventid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("ggw_name")
    protected String ggw_name;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("ggw_sendgrid_id")
    protected String ggw_sendgrid_id;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    protected Ggw_event() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGgw_event() {
        return new Builder();
    }

    public static final class Builder {
        private String _owninguser_value;
        private OffsetDateTime createdon;
        private String ggw_sendgrid_new_applicants_id;
        private OffsetDateTime modifiedon;
        private String _createdonbehalfby_value;
        private String _owningbusinessunit_value;
        private String ggw_eventid;
        private Long versionnumber;
        private Integer utcconversiontimezonecode;
        private String ggw_name;
        private String _owningteam_value;
        private String _modifiedby_value;
        private String ggw_sendgrid_id;
        private String _ownerid_value;
        private OffsetDateTime overriddencreatedon;
        private Integer statuscode;
        private Integer importsequencenumber;
        private String _createdby_value;
        private Integer statecode;
        private Integer timezoneruleversionnumber;
        private String _modifiedonbehalfby_value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder ggw_sendgrid_new_applicants_id(String ggw_sendgrid_new_applicants_id) {
            this.ggw_sendgrid_new_applicants_id = ggw_sendgrid_new_applicants_id;
            this.changedFields = changedFields.add("ggw_sendgrid_new_applicants_id");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder ggw_eventid(String ggw_eventid) {
            this.ggw_eventid = ggw_eventid;
            this.changedFields = changedFields.add("ggw_eventid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder ggw_name(String ggw_name) {
            this.ggw_name = ggw_name;
            this.changedFields = changedFields.add("ggw_name");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder ggw_sendgrid_id(String ggw_sendgrid_id) {
            this.ggw_sendgrid_id = ggw_sendgrid_id;
            this.changedFields = changedFields.add("ggw_sendgrid_id");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Ggw_event build() {
            Ggw_event _x = new Ggw_event();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ggw_event";
            _x._owninguser_value = _owninguser_value;
            _x.createdon = createdon;
            _x.ggw_sendgrid_new_applicants_id = ggw_sendgrid_new_applicants_id;
            _x.modifiedon = modifiedon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.ggw_eventid = ggw_eventid;
            _x.versionnumber = versionnumber;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.ggw_name = ggw_name;
            _x._owningteam_value = _owningteam_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.ggw_sendgrid_id = ggw_sendgrid_id;
            _x._ownerid_value = _ownerid_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.statuscode = statuscode;
            _x.importsequencenumber = importsequencenumber;
            _x._createdby_value = _createdby_value;
            _x.statecode = statecode;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && ggw_eventid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(ggw_eventid.toString()));
        }
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Ggw_event with_owninguser_value(String _owninguser_value) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Ggw_event withCreatedon(OffsetDateTime createdon) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="ggw_sendgrid_new_applicants_id")
    @JsonIgnore
    public Optional<String> getGgw_sendgrid_new_applicants_id() {
        return Optional.ofNullable(ggw_sendgrid_new_applicants_id);
    }

    public Ggw_event withGgw_sendgrid_new_applicants_id(String ggw_sendgrid_new_applicants_id) {
        Checks.checkIsAscii(ggw_sendgrid_new_applicants_id);
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("ggw_sendgrid_new_applicants_id");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x.ggw_sendgrid_new_applicants_id = ggw_sendgrid_new_applicants_id;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Ggw_event withModifiedon(OffsetDateTime modifiedon) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Ggw_event with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Ggw_event with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="ggw_eventid")
    @JsonIgnore
    public Optional<String> getGgw_eventid() {
        return Optional.ofNullable(ggw_eventid);
    }

    public Ggw_event withGgw_eventid(String ggw_eventid) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("ggw_eventid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x.ggw_eventid = ggw_eventid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Ggw_event withVersionnumber(Long versionnumber) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Ggw_event withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="ggw_name")
    @JsonIgnore
    public Optional<String> getGgw_name() {
        return Optional.ofNullable(ggw_name);
    }

    public Ggw_event withGgw_name(String ggw_name) {
        Checks.checkIsAscii(ggw_name);
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("ggw_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x.ggw_name = ggw_name;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Ggw_event with_owningteam_value(String _owningteam_value) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Ggw_event with_modifiedby_value(String _modifiedby_value) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="ggw_sendgrid_id")
    @JsonIgnore
    public Optional<String> getGgw_sendgrid_id() {
        return Optional.ofNullable(ggw_sendgrid_id);
    }

    public Ggw_event withGgw_sendgrid_id(String ggw_sendgrid_id) {
        Checks.checkIsAscii(ggw_sendgrid_id);
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("ggw_sendgrid_id");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x.ggw_sendgrid_id = ggw_sendgrid_id;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Ggw_event with_ownerid_value(String _ownerid_value) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Ggw_event withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Ggw_event withStatuscode(Integer statuscode) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Ggw_event withImportsequencenumber(Integer importsequencenumber) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Ggw_event with_createdby_value(String _createdby_value) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Ggw_event withStatecode(Integer statecode) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Ggw_event withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Ggw_event with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Ggw_event _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_event");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    public Ggw_event withUnmappedField(String name, String value) {
        Ggw_event _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="ggw_event_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getGgw_event_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ggw_event_SyncErrors"), RequestHelper.getValue(unmappedFields, "ggw_event_SyncErrors"));
    }

    @NavigationProperty(name="ggw_event_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getGgw_event_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("ggw_event_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "ggw_event_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="ggw_event_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getGgw_event_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("ggw_event_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "ggw_event_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="ggw_event_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getGgw_event_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("ggw_event_AsyncOperations"), RequestHelper.getValue(unmappedFields, "ggw_event_AsyncOperations"));
    }

    @NavigationProperty(name="ggw_event_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getGgw_event_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("ggw_event_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "ggw_event_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="ggw_event_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getGgw_event_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("ggw_event_ProcessSession"), RequestHelper.getValue(unmappedFields, "ggw_event_ProcessSession"));
    }

    @NavigationProperty(name="ggw_event_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getGgw_event_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("ggw_event_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "ggw_event_BulkDeleteFailures"));
    }

    @NavigationProperty(name="ggw_event_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getGgw_event_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("ggw_event_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "ggw_event_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="ggw_ggw_event_ggw_team")
    @JsonIgnore
    public Ggw_teamCollectionRequest getGgw_ggw_event_ggw_team() {
        return new Ggw_teamCollectionRequest(
                        contextPath.addSegment("ggw_ggw_event_ggw_team"), RequestHelper.getValue(unmappedFields, "ggw_ggw_event_ggw_team"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Ggw_event patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Ggw_event _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Ggw_event put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Ggw_event _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Ggw_event _copy() {
        Ggw_event _x = new Ggw_event();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._owninguser_value = _owninguser_value;
        _x.createdon = createdon;
        _x.ggw_sendgrid_new_applicants_id = ggw_sendgrid_new_applicants_id;
        _x.modifiedon = modifiedon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.ggw_eventid = ggw_eventid;
        _x.versionnumber = versionnumber;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.ggw_name = ggw_name;
        _x._owningteam_value = _owningteam_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.ggw_sendgrid_id = ggw_sendgrid_id;
        _x._ownerid_value = _ownerid_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.statuscode = statuscode;
        _x.importsequencenumber = importsequencenumber;
        _x._createdby_value = _createdby_value;
        _x.statecode = statecode;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Ggw_event[");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("ggw_sendgrid_new_applicants_id=");
        b.append(this.ggw_sendgrid_new_applicants_id);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("ggw_eventid=");
        b.append(this.ggw_eventid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("ggw_name=");
        b.append(this.ggw_name);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("ggw_sendgrid_id=");
        b.append(this.ggw_sendgrid_id);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
