package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Interval", 
    "AccessTime"})
@JsonInclude(Include.NON_NULL)
public class UserAccessAuditDetail extends AuditDetail implements ODataType {

    @JsonProperty("Interval")
    protected Integer interval;

    @JsonProperty("AccessTime")
    protected OffsetDateTime accessTime;

    protected UserAccessAuditDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.UserAccessAuditDetail";
    }

    @Property(name="Interval")
    @JsonIgnore
    public Optional<Integer> getInterval() {
        return Optional.ofNullable(interval);
    }

    public UserAccessAuditDetail withInterval(Integer interval) {
        UserAccessAuditDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.UserAccessAuditDetail");
        _x.interval = interval;
        return _x;
    }

    @Property(name="AccessTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAccessTime() {
        return Optional.ofNullable(accessTime);
    }

    public UserAccessAuditDetail withAccessTime(OffsetDateTime accessTime) {
        UserAccessAuditDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.UserAccessAuditDetail");
        _x.accessTime = accessTime;
        return _x;
    }

    public UserAccessAuditDetail withUnmappedField(String name, String value) {
        UserAccessAuditDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserAccessAuditDetail() {
        return new Builder();
    }

    public static final class Builder {
        private Integer interval;
        private OffsetDateTime accessTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder interval(Integer interval) {
            this.interval = interval;
            this.changedFields = changedFields.add("Interval");
            return this;
        }

        public Builder accessTime(OffsetDateTime accessTime) {
            this.accessTime = accessTime;
            this.changedFields = changedFields.add("AccessTime");
            return this;
        }

        public UserAccessAuditDetail build() {
            UserAccessAuditDetail _x = new UserAccessAuditDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.UserAccessAuditDetail";
            _x.interval = interval;
            _x.accessTime = accessTime;
            return _x;
        }
    }

    private UserAccessAuditDetail _copy() {
        UserAccessAuditDetail _x = new UserAccessAuditDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.interval = interval;
        _x.accessTime = accessTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserAccessAuditDetail[");
        b.append("Interval=");
        b.append(this.interval);
        b.append(", ");
        b.append("AccessTime=");
        b.append(this.accessTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
