package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Distinct", 
    "NoLock", 
    "SubQueryExpression", 
    "PageInfo", 
    "QueryHints", 
    "LinkEntities", 
    "Criteria", 
    "Orders", 
    "EntityName", 
    "ColumnSet", 
    "TopCount"})
@JsonInclude(Include.NON_NULL)
public class QueryExpression extends QueryBase implements ODataType {

    @JsonProperty("Distinct")
    protected Boolean distinct;

    @JsonProperty("NoLock")
    protected Boolean noLock;

    @JsonProperty("SubQueryExpression")
    protected QueryExpression subQueryExpression;

    @JsonProperty("PageInfo")
    protected PagingInfo pageInfo;

    @JsonProperty("QueryHints")
    protected String queryHints;

    @JsonProperty("LinkEntities")
    protected List<LinkEntity> linkEntities;

    @JsonProperty("LinkEntities@nextLink")
    protected String linkEntitiesNextLink;

    @JsonProperty("Criteria")
    protected FilterExpression criteria;

    @JsonProperty("Orders")
    protected List<OrderExpression> orders;

    @JsonProperty("Orders@nextLink")
    protected String ordersNextLink;

    @JsonProperty("EntityName")
    protected String entityName;

    @JsonProperty("ColumnSet")
    protected ColumnSet columnSet;

    @JsonProperty("TopCount")
    protected Integer topCount;

    protected QueryExpression() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.QueryExpression";
    }

    @Property(name="Distinct")
    @JsonIgnore
    public Optional<Boolean> getDistinct() {
        return Optional.ofNullable(distinct);
    }

    public QueryExpression withDistinct(Boolean distinct) {
        QueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryExpression");
        _x.distinct = distinct;
        return _x;
    }

    @Property(name="NoLock")
    @JsonIgnore
    public Optional<Boolean> getNoLock() {
        return Optional.ofNullable(noLock);
    }

    public QueryExpression withNoLock(Boolean noLock) {
        QueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryExpression");
        _x.noLock = noLock;
        return _x;
    }

    @Property(name="SubQueryExpression")
    @JsonIgnore
    public Optional<QueryExpression> getSubQueryExpression() {
        return Optional.ofNullable(subQueryExpression);
    }

    public QueryExpression withSubQueryExpression(QueryExpression subQueryExpression) {
        QueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryExpression");
        _x.subQueryExpression = subQueryExpression;
        return _x;
    }

    @Property(name="PageInfo")
    @JsonIgnore
    public Optional<PagingInfo> getPageInfo() {
        return Optional.ofNullable(pageInfo);
    }

    public QueryExpression withPageInfo(PagingInfo pageInfo) {
        QueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryExpression");
        _x.pageInfo = pageInfo;
        return _x;
    }

    @Property(name="QueryHints")
    @JsonIgnore
    public Optional<String> getQueryHints() {
        return Optional.ofNullable(queryHints);
    }

    public QueryExpression withQueryHints(String queryHints) {
        Checks.checkIsAscii(queryHints);
        QueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryExpression");
        _x.queryHints = queryHints;
        return _x;
    }

    @Property(name="LinkEntities")
    @JsonIgnore
    public CollectionPage<LinkEntity> getLinkEntities() {
        return new CollectionPage<LinkEntity>(contextPath, LinkEntity.class, this.linkEntities, Optional.ofNullable(linkEntitiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="LinkEntities")
    @JsonIgnore
    public CollectionPage<LinkEntity> getLinkEntities(HttpRequestOptions options) {
        return new CollectionPage<LinkEntity>(contextPath, LinkEntity.class, this.linkEntities, Optional.ofNullable(linkEntitiesNextLink), Collections.emptyList(), options);
    }

    @Property(name="Criteria")
    @JsonIgnore
    public Optional<FilterExpression> getCriteria() {
        return Optional.ofNullable(criteria);
    }

    public QueryExpression withCriteria(FilterExpression criteria) {
        QueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryExpression");
        _x.criteria = criteria;
        return _x;
    }

    @Property(name="Orders")
    @JsonIgnore
    public CollectionPage<OrderExpression> getOrders() {
        return new CollectionPage<OrderExpression>(contextPath, OrderExpression.class, this.orders, Optional.ofNullable(ordersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Orders")
    @JsonIgnore
    public CollectionPage<OrderExpression> getOrders(HttpRequestOptions options) {
        return new CollectionPage<OrderExpression>(contextPath, OrderExpression.class, this.orders, Optional.ofNullable(ordersNextLink), Collections.emptyList(), options);
    }

    @Property(name="EntityName")
    @JsonIgnore
    public Optional<String> getEntityName() {
        return Optional.ofNullable(entityName);
    }

    public QueryExpression withEntityName(String entityName) {
        Checks.checkIsAscii(entityName);
        QueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryExpression");
        _x.entityName = entityName;
        return _x;
    }

    @Property(name="ColumnSet")
    @JsonIgnore
    public Optional<ColumnSet> getColumnSet() {
        return Optional.ofNullable(columnSet);
    }

    public QueryExpression withColumnSet(ColumnSet columnSet) {
        QueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryExpression");
        _x.columnSet = columnSet;
        return _x;
    }

    @Property(name="TopCount")
    @JsonIgnore
    public Optional<Integer> getTopCount() {
        return Optional.ofNullable(topCount);
    }

    public QueryExpression withTopCount(Integer topCount) {
        QueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryExpression");
        _x.topCount = topCount;
        return _x;
    }

    public QueryExpression withUnmappedField(String name, String value) {
        QueryExpression _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderQueryExpression() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean distinct;
        private Boolean noLock;
        private QueryExpression subQueryExpression;
        private PagingInfo pageInfo;
        private String queryHints;
        private List<LinkEntity> linkEntities;
        private String linkEntitiesNextLink;
        private FilterExpression criteria;
        private List<OrderExpression> orders;
        private String ordersNextLink;
        private String entityName;
        private ColumnSet columnSet;
        private Integer topCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder distinct(Boolean distinct) {
            this.distinct = distinct;
            this.changedFields = changedFields.add("Distinct");
            return this;
        }

        public Builder noLock(Boolean noLock) {
            this.noLock = noLock;
            this.changedFields = changedFields.add("NoLock");
            return this;
        }

        public Builder subQueryExpression(QueryExpression subQueryExpression) {
            this.subQueryExpression = subQueryExpression;
            this.changedFields = changedFields.add("SubQueryExpression");
            return this;
        }

        public Builder pageInfo(PagingInfo pageInfo) {
            this.pageInfo = pageInfo;
            this.changedFields = changedFields.add("PageInfo");
            return this;
        }

        public Builder queryHints(String queryHints) {
            this.queryHints = queryHints;
            this.changedFields = changedFields.add("QueryHints");
            return this;
        }

        public Builder linkEntities(List<LinkEntity> linkEntities) {
            this.linkEntities = linkEntities;
            this.changedFields = changedFields.add("LinkEntities");
            return this;
        }

        public Builder linkEntities(LinkEntity... linkEntities) {
            return linkEntities(Arrays.asList(linkEntities));
        }

        public Builder linkEntitiesNextLink(String linkEntitiesNextLink) {
            this.linkEntitiesNextLink = linkEntitiesNextLink;
            this.changedFields = changedFields.add("LinkEntities");
            return this;
        }

        public Builder criteria(FilterExpression criteria) {
            this.criteria = criteria;
            this.changedFields = changedFields.add("Criteria");
            return this;
        }

        public Builder orders(List<OrderExpression> orders) {
            this.orders = orders;
            this.changedFields = changedFields.add("Orders");
            return this;
        }

        public Builder orders(OrderExpression... orders) {
            return orders(Arrays.asList(orders));
        }

        public Builder ordersNextLink(String ordersNextLink) {
            this.ordersNextLink = ordersNextLink;
            this.changedFields = changedFields.add("Orders");
            return this;
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.changedFields = changedFields.add("EntityName");
            return this;
        }

        public Builder columnSet(ColumnSet columnSet) {
            this.columnSet = columnSet;
            this.changedFields = changedFields.add("ColumnSet");
            return this;
        }

        public Builder topCount(Integer topCount) {
            this.topCount = topCount;
            this.changedFields = changedFields.add("TopCount");
            return this;
        }

        public QueryExpression build() {
            QueryExpression _x = new QueryExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.QueryExpression";
            _x.distinct = distinct;
            _x.noLock = noLock;
            _x.subQueryExpression = subQueryExpression;
            _x.pageInfo = pageInfo;
            _x.queryHints = queryHints;
            _x.linkEntities = linkEntities;
            _x.linkEntitiesNextLink = linkEntitiesNextLink;
            _x.criteria = criteria;
            _x.orders = orders;
            _x.ordersNextLink = ordersNextLink;
            _x.entityName = entityName;
            _x.columnSet = columnSet;
            _x.topCount = topCount;
            return _x;
        }
    }

    private QueryExpression _copy() {
        QueryExpression _x = new QueryExpression();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.distinct = distinct;
        _x.noLock = noLock;
        _x.subQueryExpression = subQueryExpression;
        _x.pageInfo = pageInfo;
        _x.queryHints = queryHints;
        _x.linkEntities = linkEntities;
        _x.criteria = criteria;
        _x.orders = orders;
        _x.entityName = entityName;
        _x.columnSet = columnSet;
        _x.topCount = topCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("QueryExpression[");
        b.append("Distinct=");
        b.append(this.distinct);
        b.append(", ");
        b.append("NoLock=");
        b.append(this.noLock);
        b.append(", ");
        b.append("SubQueryExpression=");
        b.append(this.subQueryExpression);
        b.append(", ");
        b.append("PageInfo=");
        b.append(this.pageInfo);
        b.append(", ");
        b.append("QueryHints=");
        b.append(this.queryHints);
        b.append(", ");
        b.append("LinkEntities=");
        b.append(this.linkEntities);
        b.append(", ");
        b.append("Criteria=");
        b.append(this.criteria);
        b.append(", ");
        b.append("Orders=");
        b.append(this.orders);
        b.append(", ");
        b.append("EntityName=");
        b.append(this.entityName);
        b.append(", ");
        b.append("ColumnSet=");
        b.append(this.columnSet);
        b.append(", ");
        b.append("TopCount=");
        b.append(this.topCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
