package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "OutputString", 
    "Exception"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_ConditionXmlConversionResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("OutputString")
    protected String outputString;

    @JsonProperty("Exception")
    protected String exception;

    protected Msdyn_ConditionXmlConversionResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_ConditionXmlConversionResponse";
    }

    @Property(name="OutputString")
    @JsonIgnore
    public Optional<String> getOutputString() {
        return Optional.ofNullable(outputString);
    }

    public Msdyn_ConditionXmlConversionResponse withOutputString(String outputString) {
        Checks.checkIsAscii(outputString);
        Msdyn_ConditionXmlConversionResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_ConditionXmlConversionResponse");
        _x.outputString = outputString;
        return _x;
    }

    @Property(name="Exception")
    @JsonIgnore
    public Optional<String> getException() {
        return Optional.ofNullable(exception);
    }

    public Msdyn_ConditionXmlConversionResponse withException(String exception) {
        Checks.checkIsAscii(exception);
        Msdyn_ConditionXmlConversionResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_ConditionXmlConversionResponse");
        _x.exception = exception;
        return _x;
    }

    public Msdyn_ConditionXmlConversionResponse withUnmappedField(String name, String value) {
        Msdyn_ConditionXmlConversionResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String outputString;
        private String exception;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder outputString(String outputString) {
            this.outputString = outputString;
            this.changedFields = changedFields.add("OutputString");
            return this;
        }

        public Builder exception(String exception) {
            this.exception = exception;
            this.changedFields = changedFields.add("Exception");
            return this;
        }

        public Msdyn_ConditionXmlConversionResponse build() {
            Msdyn_ConditionXmlConversionResponse _x = new Msdyn_ConditionXmlConversionResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_ConditionXmlConversionResponse";
            _x.outputString = outputString;
            _x.exception = exception;
            return _x;
        }
    }

    private Msdyn_ConditionXmlConversionResponse _copy() {
        Msdyn_ConditionXmlConversionResponse _x = new Msdyn_ConditionXmlConversionResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.outputString = outputString;
        _x.exception = exception;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_ConditionXmlConversionResponse[");
        b.append("OutputString=");
        b.append(this.outputString);
        b.append(", ");
        b.append("Exception=");
        b.append(this.exception);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
