package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Message", 
    "ResultEntities", 
    "ReturnStatus"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_CheckForDeletedProcessResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Message")
    protected String message;

    @JsonProperty("ResultEntities")
    protected String resultEntities;

    @JsonProperty("ReturnStatus")
    protected Integer returnStatus;

    protected Msdyn_CheckForDeletedProcessResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_CheckForDeletedProcessResponse";
    }

    @Property(name="Message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public Msdyn_CheckForDeletedProcessResponse withMessage(String message) {
        Checks.checkIsAscii(message);
        Msdyn_CheckForDeletedProcessResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_CheckForDeletedProcessResponse");
        _x.message = message;
        return _x;
    }

    @Property(name="ResultEntities")
    @JsonIgnore
    public Optional<String> getResultEntities() {
        return Optional.ofNullable(resultEntities);
    }

    public Msdyn_CheckForDeletedProcessResponse withResultEntities(String resultEntities) {
        Checks.checkIsAscii(resultEntities);
        Msdyn_CheckForDeletedProcessResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_CheckForDeletedProcessResponse");
        _x.resultEntities = resultEntities;
        return _x;
    }

    @Property(name="ReturnStatus")
    @JsonIgnore
    public Optional<Integer> getReturnStatus() {
        return Optional.ofNullable(returnStatus);
    }

    public Msdyn_CheckForDeletedProcessResponse withReturnStatus(Integer returnStatus) {
        Msdyn_CheckForDeletedProcessResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_CheckForDeletedProcessResponse");
        _x.returnStatus = returnStatus;
        return _x;
    }

    public Msdyn_CheckForDeletedProcessResponse withUnmappedField(String name, String value) {
        Msdyn_CheckForDeletedProcessResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String message;
        private String resultEntities;
        private Integer returnStatus;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("Message");
            return this;
        }

        public Builder resultEntities(String resultEntities) {
            this.resultEntities = resultEntities;
            this.changedFields = changedFields.add("ResultEntities");
            return this;
        }

        public Builder returnStatus(Integer returnStatus) {
            this.returnStatus = returnStatus;
            this.changedFields = changedFields.add("ReturnStatus");
            return this;
        }

        public Msdyn_CheckForDeletedProcessResponse build() {
            Msdyn_CheckForDeletedProcessResponse _x = new Msdyn_CheckForDeletedProcessResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_CheckForDeletedProcessResponse";
            _x.message = message;
            _x.resultEntities = resultEntities;
            _x.returnStatus = returnStatus;
            return _x;
        }
    }

    private Msdyn_CheckForDeletedProcessResponse _copy() {
        Msdyn_CheckForDeletedProcessResponse _x = new Msdyn_CheckForDeletedProcessResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.message = message;
        _x.resultEntities = resultEntities;
        _x.returnStatus = returnStatus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_CheckForDeletedProcessResponse[");
        b.append("Message=");
        b.append(this.message);
        b.append(", ");
        b.append("ResultEntities=");
        b.append(this.resultEntities);
        b.append(", ");
        b.append("ReturnStatus=");
        b.append(this.returnStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
