package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "RequiredComponent", 
    "DependentComponent"})
@JsonInclude(Include.NON_NULL)
public class MissingComponent implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("RequiredComponent")
    protected ComponentDetail requiredComponent;

    @JsonProperty("DependentComponent")
    protected ComponentDetail dependentComponent;

    protected MissingComponent() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.MissingComponent";
    }

    @Property(name="RequiredComponent")
    @JsonIgnore
    public Optional<ComponentDetail> getRequiredComponent() {
        return Optional.ofNullable(requiredComponent);
    }

    public MissingComponent withRequiredComponent(ComponentDetail requiredComponent) {
        MissingComponent _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MissingComponent");
        _x.requiredComponent = requiredComponent;
        return _x;
    }

    @Property(name="DependentComponent")
    @JsonIgnore
    public Optional<ComponentDetail> getDependentComponent() {
        return Optional.ofNullable(dependentComponent);
    }

    public MissingComponent withDependentComponent(ComponentDetail dependentComponent) {
        MissingComponent _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MissingComponent");
        _x.dependentComponent = dependentComponent;
        return _x;
    }

    public MissingComponent withUnmappedField(String name, String value) {
        MissingComponent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ComponentDetail requiredComponent;
        private ComponentDetail dependentComponent;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder requiredComponent(ComponentDetail requiredComponent) {
            this.requiredComponent = requiredComponent;
            this.changedFields = changedFields.add("RequiredComponent");
            return this;
        }

        public Builder dependentComponent(ComponentDetail dependentComponent) {
            this.dependentComponent = dependentComponent;
            this.changedFields = changedFields.add("DependentComponent");
            return this;
        }

        public MissingComponent build() {
            MissingComponent _x = new MissingComponent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.MissingComponent";
            _x.requiredComponent = requiredComponent;
            _x.dependentComponent = dependentComponent;
            return _x;
        }
    }

    private MissingComponent _copy() {
        MissingComponent _x = new MissingComponent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.requiredComponent = requiredComponent;
        _x.dependentComponent = dependentComponent;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MissingComponent[");
        b.append("RequiredComponent=");
        b.append(this.requiredComponent);
        b.append(", ");
        b.append("DependentComponent=");
        b.append(this.dependentComponent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
