package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "UnReferencedFiles"})
@JsonInclude(Include.NON_NULL)
public class EntityFilePointersResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("UnReferencedFiles")
    protected List<String> unReferencedFiles;

    @JsonProperty("UnReferencedFiles@nextLink")
    protected String unReferencedFilesNextLink;

    protected EntityFilePointersResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.EntityFilePointersResponse";
    }

    @Property(name="UnReferencedFiles")
    @JsonIgnore
    public CollectionPage<String> getUnReferencedFiles() {
        return new CollectionPage<String>(contextPath, String.class, this.unReferencedFiles, Optional.ofNullable(unReferencedFilesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="UnReferencedFiles")
    @JsonIgnore
    public CollectionPage<String> getUnReferencedFiles(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.unReferencedFiles, Optional.ofNullable(unReferencedFilesNextLink), Collections.emptyList(), options);
    }

    public EntityFilePointersResponse withUnmappedField(String name, String value) {
        EntityFilePointersResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> unReferencedFiles;
        private String unReferencedFilesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder unReferencedFiles(List<String> unReferencedFiles) {
            this.unReferencedFiles = unReferencedFiles;
            this.changedFields = changedFields.add("UnReferencedFiles");
            return this;
        }

        public Builder unReferencedFiles(String... unReferencedFiles) {
            return unReferencedFiles(Arrays.asList(unReferencedFiles));
        }

        public Builder unReferencedFilesNextLink(String unReferencedFilesNextLink) {
            this.unReferencedFilesNextLink = unReferencedFilesNextLink;
            this.changedFields = changedFields.add("UnReferencedFiles");
            return this;
        }

        public EntityFilePointersResponse build() {
            EntityFilePointersResponse _x = new EntityFilePointersResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.EntityFilePointersResponse";
            _x.unReferencedFiles = unReferencedFiles;
            _x.unReferencedFilesNextLink = unReferencedFilesNextLink;
            return _x;
        }
    }

    private EntityFilePointersResponse _copy() {
        EntityFilePointersResponse _x = new EntityFilePointersResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.unReferencedFiles = unReferencedFiles;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityFilePointersResponse[");
        b.append("UnReferencedFiles=");
        b.append(this.unReferencedFiles);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
