package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.enums.BusinessNotificationSeverity;

@JsonPropertyOrder({
    "@odata.type", 
    "Severity", 
    "Message", 
    "Parameters"})
@JsonInclude(Include.NON_NULL)
public class BusinessNotification implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Severity")
    protected BusinessNotificationSeverity severity;

    @JsonProperty("Message")
    protected String message;

    @JsonProperty("Parameters")
    protected List<BusinessNotificationParameter> parameters;

    @JsonProperty("Parameters@nextLink")
    protected String parametersNextLink;

    protected BusinessNotification() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.BusinessNotification";
    }

    @Property(name="Severity")
    @JsonIgnore
    public Optional<BusinessNotificationSeverity> getSeverity() {
        return Optional.ofNullable(severity);
    }

    public BusinessNotification withSeverity(BusinessNotificationSeverity severity) {
        BusinessNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.BusinessNotification");
        _x.severity = severity;
        return _x;
    }

    @Property(name="Message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public BusinessNotification withMessage(String message) {
        Checks.checkIsAscii(message);
        BusinessNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.BusinessNotification");
        _x.message = message;
        return _x;
    }

    @Property(name="Parameters")
    @JsonIgnore
    public CollectionPage<BusinessNotificationParameter> getParameters() {
        return new CollectionPage<BusinessNotificationParameter>(contextPath, BusinessNotificationParameter.class, this.parameters, Optional.ofNullable(parametersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Parameters")
    @JsonIgnore
    public CollectionPage<BusinessNotificationParameter> getParameters(HttpRequestOptions options) {
        return new CollectionPage<BusinessNotificationParameter>(contextPath, BusinessNotificationParameter.class, this.parameters, Optional.ofNullable(parametersNextLink), Collections.emptyList(), options);
    }

    public BusinessNotification withUnmappedField(String name, String value) {
        BusinessNotification _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BusinessNotificationSeverity severity;
        private String message;
        private List<BusinessNotificationParameter> parameters;
        private String parametersNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder severity(BusinessNotificationSeverity severity) {
            this.severity = severity;
            this.changedFields = changedFields.add("Severity");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("Message");
            return this;
        }

        public Builder parameters(List<BusinessNotificationParameter> parameters) {
            this.parameters = parameters;
            this.changedFields = changedFields.add("Parameters");
            return this;
        }

        public Builder parameters(BusinessNotificationParameter... parameters) {
            return parameters(Arrays.asList(parameters));
        }

        public Builder parametersNextLink(String parametersNextLink) {
            this.parametersNextLink = parametersNextLink;
            this.changedFields = changedFields.add("Parameters");
            return this;
        }

        public BusinessNotification build() {
            BusinessNotification _x = new BusinessNotification();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.BusinessNotification";
            _x.severity = severity;
            _x.message = message;
            _x.parameters = parameters;
            _x.parametersNextLink = parametersNextLink;
            return _x;
        }
    }

    private BusinessNotification _copy() {
        BusinessNotification _x = new BusinessNotification();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.severity = severity;
        _x.message = message;
        _x.parameters = parameters;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BusinessNotification[");
        b.append("Severity=");
        b.append(this.severity);
        b.append(", ");
        b.append("Message=");
        b.append(this.message);
        b.append(", ");
        b.append("Parameters=");
        b.append(this.parameters);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
