/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.enums.DependencyDepth;

@JsonPropertyOrder(value={"@odata.type", "MetadataType", "MetadataSubtype", "EntityLogicalName", "MetadataId", "MetadataName", "MetadataNames", "GetDefault", "DependencyDepth", "ChangedAfter", "Exclude", "AppId", "UserMetadataDelta", "SystemMetadataDelta"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MetadataQuery
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="MetadataType")
    protected String metadataType;
    @JsonProperty(value="MetadataSubtype")
    protected String metadataSubtype;
    @JsonProperty(value="EntityLogicalName")
    protected String entityLogicalName;
    @JsonProperty(value="MetadataId")
    protected String metadataId;
    @JsonProperty(value="MetadataName")
    protected String metadataName;
    @JsonProperty(value="MetadataNames")
    protected List<String> metadataNames;
    @JsonProperty(value="MetadataNames@nextLink")
    protected String metadataNamesNextLink;
    @JsonProperty(value="GetDefault")
    protected Boolean getDefault;
    @JsonProperty(value="DependencyDepth")
    protected DependencyDepth dependencyDepth;
    @JsonProperty(value="ChangedAfter")
    protected String changedAfter;
    @JsonProperty(value="Exclude")
    protected List<String> exclude;
    @JsonProperty(value="Exclude@nextLink")
    protected String excludeNextLink;
    @JsonProperty(value="AppId")
    protected String appId;
    @JsonProperty(value="UserMetadataDelta")
    protected String userMetadataDelta;
    @JsonProperty(value="SystemMetadataDelta")
    protected String systemMetadataDelta;

    protected MetadataQuery() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.MetadataQuery";
    }

    @Property(name="MetadataType")
    @JsonIgnore
    public Optional<String> getMetadataType() {
        return Optional.ofNullable(this.metadataType);
    }

    public MetadataQuery withMetadataType(String metadataType) {
        Checks.checkIsAscii((String)metadataType);
        MetadataQuery _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.MetadataQuery");
        _x.metadataType = metadataType;
        return _x;
    }

    @Property(name="MetadataSubtype")
    @JsonIgnore
    public Optional<String> getMetadataSubtype() {
        return Optional.ofNullable(this.metadataSubtype);
    }

    public MetadataQuery withMetadataSubtype(String metadataSubtype) {
        Checks.checkIsAscii((String)metadataSubtype);
        MetadataQuery _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.MetadataQuery");
        _x.metadataSubtype = metadataSubtype;
        return _x;
    }

    @Property(name="EntityLogicalName")
    @JsonIgnore
    public Optional<String> getEntityLogicalName() {
        return Optional.ofNullable(this.entityLogicalName);
    }

    public MetadataQuery withEntityLogicalName(String entityLogicalName) {
        Checks.checkIsAscii((String)entityLogicalName);
        MetadataQuery _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.MetadataQuery");
        _x.entityLogicalName = entityLogicalName;
        return _x;
    }

    @Property(name="MetadataId")
    @JsonIgnore
    public Optional<String> getMetadataId() {
        return Optional.ofNullable(this.metadataId);
    }

    public MetadataQuery withMetadataId(String metadataId) {
        MetadataQuery _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.MetadataQuery");
        _x.metadataId = metadataId;
        return _x;
    }

    @Property(name="MetadataName")
    @JsonIgnore
    public Optional<String> getMetadataName() {
        return Optional.ofNullable(this.metadataName);
    }

    public MetadataQuery withMetadataName(String metadataName) {
        Checks.checkIsAscii((String)metadataName);
        MetadataQuery _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.MetadataQuery");
        _x.metadataName = metadataName;
        return _x;
    }

    @Property(name="MetadataNames")
    @JsonIgnore
    public CollectionPage<String> getMetadataNames() {
        return new CollectionPage(this.contextPath, String.class, this.metadataNames, Optional.ofNullable(this.metadataNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="MetadataNames")
    @JsonIgnore
    public CollectionPage<String> getMetadataNames(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, String.class, this.metadataNames, Optional.ofNullable(this.metadataNamesNextLink), Collections.emptyList(), options);
    }

    @Property(name="GetDefault")
    @JsonIgnore
    public Optional<Boolean> getGetDefault() {
        return Optional.ofNullable(this.getDefault);
    }

    public MetadataQuery withGetDefault(Boolean getDefault) {
        MetadataQuery _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.MetadataQuery");
        _x.getDefault = getDefault;
        return _x;
    }

    @Property(name="DependencyDepth")
    @JsonIgnore
    public Optional<DependencyDepth> getDependencyDepth() {
        return Optional.ofNullable(this.dependencyDepth);
    }

    public MetadataQuery withDependencyDepth(DependencyDepth dependencyDepth) {
        MetadataQuery _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.MetadataQuery");
        _x.dependencyDepth = dependencyDepth;
        return _x;
    }

    @Property(name="ChangedAfter")
    @JsonIgnore
    public Optional<String> getChangedAfter() {
        return Optional.ofNullable(this.changedAfter);
    }

    public MetadataQuery withChangedAfter(String changedAfter) {
        Checks.checkIsAscii((String)changedAfter);
        MetadataQuery _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.MetadataQuery");
        _x.changedAfter = changedAfter;
        return _x;
    }

    @Property(name="Exclude")
    @JsonIgnore
    public CollectionPage<String> getExclude() {
        return new CollectionPage(this.contextPath, String.class, this.exclude, Optional.ofNullable(this.excludeNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Exclude")
    @JsonIgnore
    public CollectionPage<String> getExclude(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, String.class, this.exclude, Optional.ofNullable(this.excludeNextLink), Collections.emptyList(), options);
    }

    @Property(name="AppId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(this.appId);
    }

    public MetadataQuery withAppId(String appId) {
        MetadataQuery _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.MetadataQuery");
        _x.appId = appId;
        return _x;
    }

    @Property(name="UserMetadataDelta")
    @JsonIgnore
    public Optional<String> getUserMetadataDelta() {
        return Optional.ofNullable(this.userMetadataDelta);
    }

    public MetadataQuery withUserMetadataDelta(String userMetadataDelta) {
        Checks.checkIsAscii((String)userMetadataDelta);
        MetadataQuery _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.MetadataQuery");
        _x.userMetadataDelta = userMetadataDelta;
        return _x;
    }

    @Property(name="SystemMetadataDelta")
    @JsonIgnore
    public Optional<String> getSystemMetadataDelta() {
        return Optional.ofNullable(this.systemMetadataDelta);
    }

    public MetadataQuery withSystemMetadataDelta(String systemMetadataDelta) {
        Checks.checkIsAscii((String)systemMetadataDelta);
        MetadataQuery _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.MetadataQuery");
        _x.systemMetadataDelta = systemMetadataDelta;
        return _x;
    }

    public MetadataQuery withUnmappedField(String name, String value) {
        MetadataQuery _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private MetadataQuery _copy() {
        MetadataQuery _x = new MetadataQuery();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.metadataType = this.metadataType;
        _x.metadataSubtype = this.metadataSubtype;
        _x.entityLogicalName = this.entityLogicalName;
        _x.metadataId = this.metadataId;
        _x.metadataName = this.metadataName;
        _x.metadataNames = this.metadataNames;
        _x.getDefault = this.getDefault;
        _x.dependencyDepth = this.dependencyDepth;
        _x.changedAfter = this.changedAfter;
        _x.exclude = this.exclude;
        _x.appId = this.appId;
        _x.userMetadataDelta = this.userMetadataDelta;
        _x.systemMetadataDelta = this.systemMetadataDelta;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MetadataQuery[");
        b.append("MetadataType=");
        b.append(this.metadataType);
        b.append(", ");
        b.append("MetadataSubtype=");
        b.append(this.metadataSubtype);
        b.append(", ");
        b.append("EntityLogicalName=");
        b.append(this.entityLogicalName);
        b.append(", ");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("MetadataName=");
        b.append(this.metadataName);
        b.append(", ");
        b.append("MetadataNames=");
        b.append(this.metadataNames);
        b.append(", ");
        b.append("GetDefault=");
        b.append(this.getDefault);
        b.append(", ");
        b.append("DependencyDepth=");
        b.append((Object)this.dependencyDepth);
        b.append(", ");
        b.append("ChangedAfter=");
        b.append(this.changedAfter);
        b.append(", ");
        b.append("Exclude=");
        b.append(this.exclude);
        b.append(", ");
        b.append("AppId=");
        b.append(this.appId);
        b.append(", ");
        b.append("UserMetadataDelta=");
        b.append(this.userMetadataDelta);
        b.append(", ");
        b.append("SystemMetadataDelta=");
        b.append(this.systemMetadataDelta);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String metadataType;
        private String metadataSubtype;
        private String entityLogicalName;
        private String metadataId;
        private String metadataName;
        private List<String> metadataNames;
        private String metadataNamesNextLink;
        private Boolean getDefault;
        private DependencyDepth dependencyDepth;
        private String changedAfter;
        private List<String> exclude;
        private String excludeNextLink;
        private String appId;
        private String userMetadataDelta;
        private String systemMetadataDelta;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder metadataType(String metadataType) {
            this.metadataType = metadataType;
            this.changedFields = this.changedFields.add("MetadataType");
            return this;
        }

        public Builder metadataSubtype(String metadataSubtype) {
            this.metadataSubtype = metadataSubtype;
            this.changedFields = this.changedFields.add("MetadataSubtype");
            return this;
        }

        public Builder entityLogicalName(String entityLogicalName) {
            this.entityLogicalName = entityLogicalName;
            this.changedFields = this.changedFields.add("EntityLogicalName");
            return this;
        }

        public Builder metadataId(String metadataId) {
            this.metadataId = metadataId;
            this.changedFields = this.changedFields.add("MetadataId");
            return this;
        }

        public Builder metadataName(String metadataName) {
            this.metadataName = metadataName;
            this.changedFields = this.changedFields.add("MetadataName");
            return this;
        }

        public Builder metadataNames(List<String> metadataNames) {
            this.metadataNames = metadataNames;
            this.changedFields = this.changedFields.add("MetadataNames");
            return this;
        }

        public Builder metadataNames(String ... metadataNames) {
            return this.metadataNames(Arrays.asList(metadataNames));
        }

        public Builder metadataNamesNextLink(String metadataNamesNextLink) {
            this.metadataNamesNextLink = metadataNamesNextLink;
            this.changedFields = this.changedFields.add("MetadataNames");
            return this;
        }

        public Builder getDefault(Boolean getDefault) {
            this.getDefault = getDefault;
            this.changedFields = this.changedFields.add("GetDefault");
            return this;
        }

        public Builder dependencyDepth(DependencyDepth dependencyDepth) {
            this.dependencyDepth = dependencyDepth;
            this.changedFields = this.changedFields.add("DependencyDepth");
            return this;
        }

        public Builder changedAfter(String changedAfter) {
            this.changedAfter = changedAfter;
            this.changedFields = this.changedFields.add("ChangedAfter");
            return this;
        }

        public Builder exclude(List<String> exclude) {
            this.exclude = exclude;
            this.changedFields = this.changedFields.add("Exclude");
            return this;
        }

        public Builder exclude(String ... exclude) {
            return this.exclude(Arrays.asList(exclude));
        }

        public Builder excludeNextLink(String excludeNextLink) {
            this.excludeNextLink = excludeNextLink;
            this.changedFields = this.changedFields.add("Exclude");
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = this.changedFields.add("AppId");
            return this;
        }

        public Builder userMetadataDelta(String userMetadataDelta) {
            this.userMetadataDelta = userMetadataDelta;
            this.changedFields = this.changedFields.add("UserMetadataDelta");
            return this;
        }

        public Builder systemMetadataDelta(String systemMetadataDelta) {
            this.systemMetadataDelta = systemMetadataDelta;
            this.changedFields = this.changedFields.add("SystemMetadataDelta");
            return this;
        }

        public MetadataQuery build() {
            MetadataQuery _x = new MetadataQuery();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.MetadataQuery";
            _x.metadataType = this.metadataType;
            _x.metadataSubtype = this.metadataSubtype;
            _x.entityLogicalName = this.entityLogicalName;
            _x.metadataId = this.metadataId;
            _x.metadataName = this.metadataName;
            _x.metadataNames = this.metadataNames;
            _x.metadataNamesNextLink = this.metadataNamesNextLink;
            _x.getDefault = this.getDefault;
            _x.dependencyDepth = this.dependencyDepth;
            _x.changedAfter = this.changedAfter;
            _x.exclude = this.exclude;
            _x.excludeNextLink = this.excludeNextLink;
            _x.appId = this.appId;
            _x.userMetadataDelta = this.userMetadataDelta;
            _x.systemMetadataDelta = this.systemMetadataDelta;
            return _x;
        }
    }
}

