/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.ResourceInfo;

@JsonPropertyOrder(value={"@odata.type", "ResourceList", "ErrorCode"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ErrorInfo
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="ResourceList")
    protected List<ResourceInfo> resourceList;
    @JsonProperty(value="ResourceList@nextLink")
    protected String resourceListNextLink;
    @JsonProperty(value="ErrorCode")
    protected String errorCode;

    protected ErrorInfo() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ErrorInfo";
    }

    @Property(name="ResourceList")
    @JsonIgnore
    public CollectionPage<ResourceInfo> getResourceList() {
        return new CollectionPage(this.contextPath, ResourceInfo.class, this.resourceList, Optional.ofNullable(this.resourceListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ResourceList")
    @JsonIgnore
    public CollectionPage<ResourceInfo> getResourceList(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, ResourceInfo.class, this.resourceList, Optional.ofNullable(this.resourceListNextLink), Collections.emptyList(), options);
    }

    @Property(name="ErrorCode")
    @JsonIgnore
    public Optional<String> getErrorCode() {
        return Optional.ofNullable(this.errorCode);
    }

    public ErrorInfo withErrorCode(String errorCode) {
        Checks.checkIsAscii((String)errorCode);
        ErrorInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ErrorInfo");
        _x.errorCode = errorCode;
        return _x;
    }

    public ErrorInfo withUnmappedField(String name, String value) {
        ErrorInfo _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ErrorInfo _copy() {
        ErrorInfo _x = new ErrorInfo();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.resourceList = this.resourceList;
        _x.errorCode = this.errorCode;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ErrorInfo[");
        b.append("ResourceList=");
        b.append(this.resourceList);
        b.append(", ");
        b.append("ErrorCode=");
        b.append(this.errorCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private List<ResourceInfo> resourceList;
        private String resourceListNextLink;
        private String errorCode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder resourceList(List<ResourceInfo> resourceList) {
            this.resourceList = resourceList;
            this.changedFields = this.changedFields.add("ResourceList");
            return this;
        }

        public Builder resourceList(ResourceInfo ... resourceList) {
            return this.resourceList(Arrays.asList(resourceList));
        }

        public Builder resourceListNextLink(String resourceListNextLink) {
            this.resourceListNextLink = resourceListNextLink;
            this.changedFields = this.changedFields.add("ResourceList");
            return this;
        }

        public Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            this.changedFields = this.changedFields.add("ErrorCode");
            return this;
        }

        public ErrorInfo build() {
            ErrorInfo _x = new ErrorInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ErrorInfo";
            _x.resourceList = this.resourceList;
            _x.resourceListNextLink = this.resourceListNextLink;
            _x.errorCode = this.errorCode;
            return _x;
        }
    }
}

