/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "Key", "Data"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CacheItem
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Key")
    protected String key;
    @JsonProperty(value="Data")
    protected String data;

    protected CacheItem() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.CacheItem";
    }

    @Property(name="Key")
    @JsonIgnore
    public Optional<String> getKey() {
        return Optional.ofNullable(this.key);
    }

    public CacheItem withKey(String key) {
        Checks.checkIsAscii((String)key);
        CacheItem _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.CacheItem");
        _x.key = key;
        return _x;
    }

    @Property(name="Data")
    @JsonIgnore
    public Optional<String> getData() {
        return Optional.ofNullable(this.data);
    }

    public CacheItem withData(String data) {
        Checks.checkIsAscii((String)data);
        CacheItem _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.CacheItem");
        _x.data = data;
        return _x;
    }

    public CacheItem withUnmappedField(String name, String value) {
        CacheItem _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private CacheItem _copy() {
        CacheItem _x = new CacheItem();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.key = this.key;
        _x.data = this.data;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CacheItem[");
        b.append("Key=");
        b.append(this.key);
        b.append(", ");
        b.append("Data=");
        b.append(this.data);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String key;
        private String data;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder key(String key) {
            this.key = key;
            this.changedFields = this.changedFields.add("Key");
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            this.changedFields = this.changedFields.add("Data");
            return this;
        }

        public CacheItem build() {
            CacheItem _x = new CacheItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.CacheItem";
            _x.key = this.key;
            _x.data = this.data;
            return _x;
        }
    }
}

