package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TargetFieldType implements Enum {

    @JsonProperty("All")
    ALL("All", "0"),

    @JsonProperty("ValidForCreate")
    VALID_FOR_CREATE("ValidForCreate", "1"),

    @JsonProperty("ValidForUpdate")
    VALID_FOR_UPDATE("ValidForUpdate", "2"),

    @JsonProperty("ValidForRead")
    VALID_FOR_READ("ValidForRead", "3");

    private final String name;
    private final String value;

    private TargetFieldType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
