package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum LogicalOperator implements Enum {

    @JsonProperty("And")
    AND("And", "0"),

    @JsonProperty("Or")
    OR("Or", "1");

    private final String name;
    private final String value;

    private LogicalOperator(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
