package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum JoinOperator implements Enum {

    @JsonProperty("Inner")
    INNER("Inner", "0"),

    @JsonProperty("LeftOuter")
    LEFT_OUTER("LeftOuter", "1"),

    @JsonProperty("Natural")
    NATURAL("Natural", "2"),

    @JsonProperty("MatchFirstRowUsingCrossApply")
    MATCH_FIRST_ROW_USING_CROSS_APPLY("MatchFirstRowUsingCrossApply", "3"),

    @JsonProperty("In")
    IN("In", "4"),

    @JsonProperty("Exists")
    EXISTS("Exists", "5"),

    @JsonProperty("Any")
    ANY("Any", "6"),

    @JsonProperty("NotAny")
    NOT_ANY("NotAny", "7"),

    @JsonProperty("All")
    ALL("All", "8"),

    @JsonProperty("NotAll")
    NOT_ALL("NotAll", "9");

    private final String name;
    private final String value;

    private JoinOperator(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
