package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Sitemap;

@JsonIgnoreType
public class SitemapRequest extends EntityRequest<Sitemap> {

    public SitemapRequest(ContextPath contextPath, Optional<Object> value) {
        super(Sitemap.class, contextPath, value);
    }

    public SystemuserRequest siteMap_modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("SiteMap_modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest siteMap_modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("SiteMap_modifiedby"), Optional.empty());
    }

    public SystemuserRequest siteMap_createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("SiteMap_createdonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SystemuserRequest siteMap_createdby() {
        return new SystemuserRequest(contextPath.addSegment("SiteMap_createdby"), Optional.empty());
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Sitemap> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Sitemap>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Sitemap.class, _parameters);
    }

}
