package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Similarityrule;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;

@JsonIgnoreType
public class SimilarityruleRequest extends EntityRequest<Similarityrule> {

    public SimilarityruleRequest(ContextPath contextPath, Optional<Object> value) {
        super(Similarityrule.class, contextPath, value);
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public AsyncoperationCollectionRequest similarityrule_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("similarityrule_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest similarityrule_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("similarityrule_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

}
